/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.client.producer;

import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import java.security.Security;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.inlong.tubemq.client.config.TubeClientConfig;
import org.apache.inlong.tubemq.client.exception.TubeClientException;
import org.apache.inlong.tubemq.client.factory.InnerSessionFactory;
import org.apache.inlong.tubemq.client.producer.MessageProducer;
import org.apache.inlong.tubemq.client.producer.MessageSentCallback;
import org.apache.inlong.tubemq.client.producer.MessageSentResult;
import org.apache.inlong.tubemq.client.producer.PartitionRouter;
import org.apache.inlong.tubemq.client.producer.ProducerManager;
import org.apache.inlong.tubemq.client.producer.RoundRobinPartitionRouter;
import org.apache.inlong.tubemq.client.producer.qltystats.DefaultBrokerRcvQltyStats;
import org.apache.inlong.tubemq.corebase.Message;
import org.apache.inlong.tubemq.corebase.cluster.BrokerInfo;
import org.apache.inlong.tubemq.corebase.cluster.Partition;
import org.apache.inlong.tubemq.corebase.protobuf.generated.ClientBroker;
import org.apache.inlong.tubemq.corebase.utils.AddressUtils;
import org.apache.inlong.tubemq.corebase.utils.MessageFlagUtils;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.corerpc.RpcConfig;
import org.apache.inlong.tubemq.corerpc.RpcServiceFactory;
import org.apache.inlong.tubemq.corerpc.client.Callback;
import org.apache.inlong.tubemq.corerpc.exception.LocalConnException;
import org.apache.inlong.tubemq.corerpc.service.BrokerWriteService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMessageProducer
implements MessageProducer {
    private static final Logger logger = LoggerFactory.getLogger(SimpleMessageProducer.class);
    private final TubeClientConfig producerConfig;
    private final ConcurrentHashMap<String, Long> publishTopicMap = new ConcurrentHashMap();
    private final InnerSessionFactory sessionFactory;
    private final RpcServiceFactory rpcServiceFactory;
    private final ProducerManager producerManager;
    private final PartitionRouter partitionRouter;
    private final DefaultBrokerRcvQltyStats brokerRcvQltyStats;
    private final RpcConfig rpcConfig = new RpcConfig();
    private final AtomicBoolean isShutDown = new AtomicBoolean(false);

    public SimpleMessageProducer(InnerSessionFactory sessionFactory, TubeClientConfig tubeClientConfig) throws TubeClientException {
        Security.setProperty("networkaddress.cache.ttl", "3");
        Security.setProperty("networkaddress.cache.negative.ttl", "1");
        if (sessionFactory == null || tubeClientConfig == null) {
            throw new TubeClientException("Illegal parameter: messageSessionFactory or tubeClientConfig is null!");
        }
        this.producerConfig = tubeClientConfig;
        this.sessionFactory = sessionFactory;
        this.rpcServiceFactory = this.sessionFactory.getRpcServiceFactory();
        this.producerManager = this.sessionFactory.getProducerManager();
        this.brokerRcvQltyStats = sessionFactory.getBrokerRcvQltyStats();
        this.partitionRouter = new RoundRobinPartitionRouter();
        this.rpcConfig.put("rpc.connect.timeout", 3000);
        this.rpcConfig.put("rpc.request.timeout", tubeClientConfig.getRpcTimeoutMs());
        this.rpcConfig.put("rpc.netty.write.highmark", tubeClientConfig.getNettyWriteBufferHighWaterMark());
        this.rpcConfig.put("rpc.netty.write.lowmark", tubeClientConfig.getNettyWriteBufferLowWaterMark());
        this.rpcConfig.put("rpc.netty.worker.count", tubeClientConfig.getRpcConnProcessorCnt());
        this.rpcConfig.put("rpc.netty.worker.thread.name", "tube_producer_netty_worker-");
        this.rpcConfig.put("rpc.netty.worker.mem.size", tubeClientConfig.getRpcNettyWorkMemorySize());
        this.rpcConfig.put("rpc.netty.callback.count", tubeClientConfig.getRpcRspCallBackThreadCnt());
    }

    @Override
    public void publish(String topic) throws TubeClientException {
        if (this.isShutDown.get()) {
            throw new TubeClientException("Status error: producer has been shutdown!");
        }
        if (TStringUtils.isBlank(topic)) {
            throw new TubeClientException("Illegal parameter: blank topic!");
        }
        this.producerManager.publish(topic.trim());
        this.publishTopicMap.putIfAbsent(topic.trim(), System.currentTimeMillis());
    }

    @Override
    public Set<String> publish(Set<String> topicSet) throws TubeClientException {
        if (this.isShutDown.get()) {
            throw new TubeClientException("Status error: producer has been shutdown!");
        }
        if (topicSet == null || topicSet.isEmpty()) {
            throw new TubeClientException("Illegal parameter: topicSet is null or empty!");
        }
        HashSet<String> newTopicSet = new HashSet<String>();
        for (String topicItem : topicSet) {
            if (TStringUtils.isBlank(topicItem)) {
                throw new TubeClientException(new StringBuilder(256).append("Illegal parameter: found blank topic value in topicSet : ").append(topicSet).toString());
            }
            newTopicSet.add(topicItem.trim());
        }
        long curTime = System.currentTimeMillis();
        for (String topicName : newTopicSet) {
            this.publishTopicMap.putIfAbsent(topicName, curTime);
        }
        return this.producerManager.publish(newTopicSet);
    }

    @Override
    public Set<String> getPublishedTopicSet() throws TubeClientException {
        if (this.isShutDown.get()) {
            throw new TubeClientException("Status error: producer has been shutdown!");
        }
        return this.publishTopicMap.keySet();
    }

    @Override
    public boolean isTopicCurAcceptPublish(String topic) throws TubeClientException {
        if (this.isShutDown.get()) {
            throw new TubeClientException("Status error: producer has been shutdown!");
        }
        if (TStringUtils.isBlank(topic)) {
            throw new TubeClientException("Illegal parameter: blank topic!");
        }
        if (this.publishTopicMap.get(topic) == null) {
            return false;
        }
        return this.producerManager.getTopicPartition(topic) != null;
    }

    @Override
    public void shutdown() throws Throwable {
        logger.info("[ShutDown] begin shutdown producer...");
        if (this.isShutDown.get()) {
            return;
        }
        if (this.isShutDown.compareAndSet(false, true)) {
            this.producerManager.removeTopic(this.publishTopicMap.keySet());
            this.publishTopicMap.clear();
            this.sessionFactory.removeClient(this);
            logger.info("[ShutDown] producer has stopped!");
        }
    }

    @Override
    public MessageSentResult sendMessage(Message message) throws TubeClientException, InterruptedException {
        this.checkMessageAndStatus(message);
        Partition partition = this.selectPartition(message, BrokerWriteService.class);
        int brokerId = partition.getBrokerId();
        long startTime = System.currentTimeMillis();
        try {
            this.brokerRcvQltyStats.addSendStatistic(brokerId);
            ClientBroker.SendMessageResponseB2P response = this.getBrokerService(partition.getBroker()).sendMessageP2B(this.createSendMessageRequest(partition, message), AddressUtils.getLocalAddress(), this.producerConfig.isTlsEnable());
            this.rpcServiceFactory.resetRmtAddrErrCount(partition.getBroker().getBrokerAddr());
            this.brokerRcvQltyStats.addReceiveStatistic(brokerId, response.getSuccess());
            if (!response.getSuccess() && response.getErrCode() == 503) {
                this.rpcServiceFactory.addUnavailableBroker(brokerId);
            }
            return this.buildMsgSentResult(System.currentTimeMillis() - startTime, message, partition, response);
        }
        catch (Throwable e) {
            if (e instanceof LocalConnException) {
                this.rpcServiceFactory.addRmtAddrErrCount(partition.getBroker().getBrokerAddr());
            }
            this.producerManager.getClientMetrics().bookFailRpcCall(599);
            partition.increRetries(1);
            this.brokerRcvQltyStats.addReceiveStatistic(brokerId, false);
            throw new TubeClientException("Send message failed", e);
        }
    }

    @Override
    public void sendMessage(final Message message, final MessageSentCallback cb) throws TubeClientException, InterruptedException {
        this.checkMessageAndStatus(message);
        final Partition partition = this.selectPartition(message, BrokerWriteService.AsyncService.class);
        final int brokerId = partition.getBrokerId();
        final long startTime = System.currentTimeMillis();
        try {
            this.brokerRcvQltyStats.addSendStatistic(brokerId);
            this.getAsyncBrokerService(partition.getBroker()).sendMessageP2B(this.createSendMessageRequest(partition, message), AddressUtils.getLocalAddress(), this.producerConfig.isTlsEnable(), new Callback(){

                public void handleResult(Object result) {
                    if (!(result instanceof ClientBroker.SendMessageResponseB2P)) {
                        return;
                    }
                    ClientBroker.SendMessageResponseB2P responseB2P = (ClientBroker.SendMessageResponseB2P)result;
                    MessageSentResult rt = SimpleMessageProducer.this.buildMsgSentResult(System.currentTimeMillis() - startTime, message, partition, responseB2P);
                    partition.resetRetries();
                    SimpleMessageProducer.this.brokerRcvQltyStats.addReceiveStatistic(brokerId, responseB2P.getSuccess());
                    if (!responseB2P.getSuccess() && responseB2P.getErrCode() == 503) {
                        SimpleMessageProducer.this.rpcServiceFactory.addUnavailableBroker(brokerId);
                    }
                    cb.onMessageSent(rt);
                }

                @Override
                public void handleError(Throwable error) {
                    SimpleMessageProducer.this.producerManager.getClientMetrics().bookFailRpcCall(599);
                    partition.increRetries(1);
                    SimpleMessageProducer.this.brokerRcvQltyStats.addReceiveStatistic(brokerId, false);
                    cb.onException(error);
                }
            });
            this.rpcServiceFactory.resetRmtAddrErrCount(partition.getBroker().getBrokerAddr());
        }
        catch (Throwable e) {
            if (e instanceof LocalConnException) {
                this.rpcServiceFactory.addRmtAddrErrCount(partition.getBroker().getBrokerAddr());
            }
            partition.increRetries(1);
            this.brokerRcvQltyStats.addReceiveStatistic(brokerId, false);
            cb.onException(e);
        }
    }

    private void checkMessageAndStatus(Message message) throws TubeClientException {
        int msgSize;
        if (message == null) {
            throw new TubeClientException("Illegal parameter: null message package!");
        }
        if (TStringUtils.isBlank(message.getTopic())) {
            throw new TubeClientException("Illegal parameter: blank topic in message package!");
        }
        if (message.getData() == null || message.getData().length == 0) {
            throw new TubeClientException("Illegal parameter: null data in message package!");
        }
        if (this.publishTopicMap.get(message.getTopic()) == null) {
            throw new TubeClientException(new StringBuilder(512).append("Topic ").append(message.getTopic()).append(" not publish, please publish first!").toString());
        }
        if (this.producerManager.getTopicPartition(message.getTopic()) == null) {
            throw new TubeClientException(new StringBuilder(512).append("Topic ").append(message.getTopic()).append(" not publish, make sure the topic exist or acceptPublish and try later!").toString());
        }
        int n = msgSize = TStringUtils.isBlank(message.getAttribute()) ? message.getData().length : message.getData().length + message.getAttribute().length();
        if (msgSize > this.producerManager.getMaxMsgSize()) {
            throw new TubeClientException(new StringBuilder(512).append("Illegal parameter: over max message length for the total size of").append(" message data and attribute, allowed size is ").append(this.producerManager.getMaxMsgSize()).append(", message's real size is ").append(msgSize).toString());
        }
        if (this.isShutDown.get()) {
            throw new TubeClientException("Status error: producer has been shutdown!");
        }
    }

    private ClientBroker.SendMessageRequestP2B createSendMessageRequest(Partition partition, Message message) {
        ClientBroker.SendMessageRequestP2B.Builder builder = ClientBroker.SendMessageRequestP2B.newBuilder();
        builder.setClientId(this.producerManager.getProducerId());
        builder.setTopicName(partition.getTopic());
        builder.setPartitionId(partition.getPartitionId());
        builder.setData(ByteString.copyFrom(this.encodePayload(message)));
        builder.setFlag(MessageFlagUtils.getFlag(message));
        builder.setSentAddr(this.producerManager.getProducerAddrId());
        builder.setCheckSum(-1);
        if (TStringUtils.isNotBlank(message.getMsgType())) {
            builder.setMsgType(message.getMsgType());
        }
        if (TStringUtils.isNotBlank(message.getMsgTime())) {
            builder.setMsgTime(message.getMsgTime());
        }
        builder = this.producerManager.setAuthorizedTokenInfo(builder);
        return builder.build();
    }

    private byte[] encodePayload(Message message) {
        byte[] payload = message.getData();
        String attribute = message.getAttribute();
        if (TStringUtils.isBlank(attribute)) {
            return payload;
        }
        byte[] attrData = StringUtils.getBytesUtf8(attribute);
        ByteBuffer buffer = ByteBuffer.allocate(4 + attrData.length + payload.length);
        buffer.putInt(attrData.length);
        buffer.put(attrData);
        buffer.put(payload);
        return buffer.array();
    }

    private MessageSentResult buildMsgSentResult(long dltTime, Message message, Partition partition, ClientBroker.SendMessageResponseB2P response) {
        String resultStr = response.getErrMsg();
        if (response.getErrCode() == 200) {
            this.producerManager.getClientMetrics().bookSuccSendMsg(dltTime, message.getTopic(), partition.getPartitionKey(), message.getData().length);
            if (response.hasMessageId()) {
                return new MessageSentResult(true, response.getErrCode(), "Ok!", message, response.getMessageId(), partition, response.getAppendTime(), response.getAppendOffset());
            }
            return new MessageSentResult(true, response.getErrCode(), "Ok!", message, Long.parseLong(resultStr), partition);
        }
        this.producerManager.getClientMetrics().bookFailRpcCall(response.getErrCode());
        return new MessageSentResult(false, response.getErrCode(), resultStr, message, -2L, partition);
    }

    private Partition selectPartition(Message message, Class clazz) throws TubeClientException {
        String topic = message.getTopic();
        StringBuilder sBuilder = new StringBuilder(512);
        Map<Integer, List<Partition>> brokerPartList = this.producerManager.getTopicPartition(topic);
        if (brokerPartList == null || brokerPartList.isEmpty()) {
            throw new TubeClientException(sBuilder.append("Null partition for topic: ").append(message.getTopic()).append(", please try later!").toString());
        }
        List<Partition> partList = this.brokerRcvQltyStats.getAllowedBrokerPartitions(brokerPartList);
        if (partList == null || partList.isEmpty()) {
            throw new TubeClientException(sBuilder.append("No available partition for topic: ").append(message.getTopic()).toString());
        }
        Partition partition = this.partitionRouter.getPartition(message, partList);
        if (partition == null) {
            throw new TubeClientException(new StringBuilder(512).append("Not found available partition for topic: ").append(message.getTopic()).toString());
        }
        if (this.rpcServiceFactory.isServiceEmpty()) {
            return partition;
        }
        BrokerInfo brokerInfo = partition.getBroker();
        int count = 0;
        while (count++ < partList.size() && this.rpcServiceFactory.getOrCreateService(clazz, brokerInfo, this.rpcConfig) == null) {
            partition = this.partitionRouter.getPartition(message, partList);
            brokerInfo = partition.getBroker();
        }
        return partition;
    }

    private BrokerWriteService getBrokerService(BrokerInfo brokerInfo) {
        return this.rpcServiceFactory.getService(BrokerWriteService.class, brokerInfo, this.rpcConfig);
    }

    private BrokerWriteService.AsyncService getAsyncBrokerService(BrokerInfo brokerInfo) {
        return this.rpcServiceFactory.getService(BrokerWriteService.AsyncService.class, brokerInfo, this.rpcConfig);
    }
}

