/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.client.config;

import org.apache.inlong.tubemq.client.config.TubeClientConfig;
import org.apache.inlong.tubemq.corerpc.RpcConfig;

public class TubeClientConfigUtils {
    public static RpcConfig getRpcConfigByClientConfig(TubeClientConfig tubeClientConfig, boolean isSingleSession) {
        RpcConfig config = new RpcConfig();
        config.put("tcp.tls", tubeClientConfig.isTlsEnable());
        if (tubeClientConfig.isTlsEnable()) {
            config.put("tls.truststore.path", tubeClientConfig.getTrustStorePath());
            config.put("tls.truststore.password", tubeClientConfig.getTrustStorePassword());
            config.put("tls.twoway.authentic", tubeClientConfig.isEnableTLSTwoWayAuthentic());
            if (tubeClientConfig.isEnableTLSTwoWayAuthentic()) {
                config.put("tls.keystore.path", tubeClientConfig.getKeyStorePath());
                config.put("tls.keystore.password", tubeClientConfig.getKeyStorePassword());
            }
        }
        config.put("rpc.connect.timeout", 3000);
        config.put("rpc.request.timeout", tubeClientConfig.getRpcTimeoutMs());
        config.put("rpc.netty.write.highmark", tubeClientConfig.getNettyWriteBufferHighWaterMark());
        config.put("rpc.netty.write.lowmark", tubeClientConfig.getNettyWriteBufferLowWaterMark());
        config.put("rpc.netty.worker.count", tubeClientConfig.getRpcConnProcessorCnt());
        if (isSingleSession) {
            config.put("rpc.netty.worker.thread.name", "tube_single_netty_worker-");
        } else {
            config.put("rpc.netty.worker.thread.name", "tube_multi_netty_worker-");
        }
        config.put("rpc.netty.callback.count", tubeClientConfig.getRpcRspCallBackThreadCnt());
        return config;
    }
}

