/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.tubemq.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceFunctionProvider;
import org.apache.flink.table.connector.source.abilities.SupportsReadingMetadata;
import org.apache.flink.table.connector.source.abilities.SupportsWatermarkPushDown;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.util.Preconditions;
import org.apache.inlong.sort.tubemq.FlinkTubeMQConsumer;
import org.apache.inlong.sort.tubemq.table.DynamicTubeMQDeserializationSchema;
import org.apache.inlong.tubemq.corebase.Message;

public class TubeMQTableSource
implements ScanTableSource,
SupportsReadingMetadata,
SupportsWatermarkPushDown {
    private static final String VALUE_METADATA_PREFIX = "value.";
    private final DataType physicalDataType;
    private final DecodingFormat<DeserializationSchema<RowData>> valueDecodingFormat;
    private final String masterAddress;
    private final String topic;
    private final TreeSet<String> tidSet;
    private final String consumerGroup;
    private final Configuration configuration;
    private final String sessionKey;
    private final Optional<String> proctimeAttribute;
    private final boolean ignoreErrors;
    private final boolean innerFormat;
    protected DataType producedDataType;
    protected List<String> metadataKeys;
    @Nullable
    private WatermarkStrategy<RowData> watermarkStrategy;

    public TubeMQTableSource(DataType physicalDataType, DecodingFormat<DeserializationSchema<RowData>> valueDecodingFormat, String masterAddress, String topic, TreeSet<String> tidSet, String consumerGroup, String sessionKey, Configuration configuration, @Nullable WatermarkStrategy<RowData> watermarkStrategy, Optional<String> proctimeAttribute, Boolean ignoreErrors, Boolean innerFormat) {
        Preconditions.checkNotNull((Object)physicalDataType, (String)"Physical data type must not be null.");
        Preconditions.checkNotNull(valueDecodingFormat, (String)"The deserialization schema must not be null.");
        Preconditions.checkNotNull((Object)masterAddress, (String)"The master address must not be null.");
        Preconditions.checkNotNull((Object)topic, (String)"The topic must not be null.");
        Preconditions.checkNotNull(tidSet, (String)"The tid set must not be null.");
        Preconditions.checkNotNull((Object)consumerGroup, (String)"The consumer group must not be null.");
        Preconditions.checkNotNull((Object)configuration, (String)"The configuration must not be null.");
        this.physicalDataType = physicalDataType;
        this.producedDataType = physicalDataType;
        this.metadataKeys = Collections.emptyList();
        this.valueDecodingFormat = valueDecodingFormat;
        this.masterAddress = masterAddress;
        this.topic = topic;
        this.tidSet = tidSet;
        this.consumerGroup = consumerGroup;
        this.sessionKey = sessionKey;
        this.configuration = configuration;
        this.watermarkStrategy = watermarkStrategy;
        this.proctimeAttribute = proctimeAttribute;
        this.ignoreErrors = ignoreErrors;
        this.innerFormat = innerFormat;
    }

    @Override
    public ChangelogMode getChangelogMode() {
        return this.valueDecodingFormat.getChangelogMode();
    }

    @Override
    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext context) {
        LogicalType physicalType = this.physicalDataType.getLogicalType();
        int physicalFieldCount = LogicalTypeChecks.getFieldCount(physicalType);
        IntStream physicalFields = IntStream.range(0, physicalFieldCount);
        DeserializationSchema<RowData> deserialization = this.createDeserialization(context, this.valueDecodingFormat, physicalFields.toArray(), null);
        TypeInformation producedTypeInfo = context.createTypeInformation(this.physicalDataType);
        FlinkTubeMQConsumer<RowData> tubeMQConsumer = this.createTubeMQConsumer(deserialization, producedTypeInfo, this.ignoreErrors);
        return SourceFunctionProvider.of(tubeMQConsumer, (boolean)false);
    }

    @Override
    public DynamicTableSource copy() {
        return new TubeMQTableSource(this.physicalDataType, this.valueDecodingFormat, this.masterAddress, this.topic, this.tidSet, this.consumerGroup, this.sessionKey, this.configuration, this.watermarkStrategy, this.proctimeAttribute, this.ignoreErrors, this.innerFormat);
    }

    @Override
    public String asSummaryString() {
        return "TubeMQ table source";
    }

    @Override
    public Map<String, DataType> listReadableMetadata() {
        LinkedHashMap<String, DataType> metadataMap = new LinkedHashMap<String, DataType>();
        this.valueDecodingFormat.listReadableMetadata().forEach((key, value) -> metadataMap.put(VALUE_METADATA_PREFIX + key, (DataType)value));
        Stream.of(ReadableMetadata.values()).forEachOrdered(m3 -> metadataMap.putIfAbsent(m3.key, m3.dataType));
        return metadataMap;
    }

    @Override
    public void applyReadableMetadata(List<String> metadataKeys, DataType producedDataType) {
        List formatMetadataKeys = metadataKeys.stream().filter(k -> k.startsWith(VALUE_METADATA_PREFIX)).collect(Collectors.toList());
        ArrayList<String> connectorMetadataKeys = new ArrayList<String>(metadataKeys);
        connectorMetadataKeys.removeAll(formatMetadataKeys);
        Map<String, DataType> formatMetadata = this.valueDecodingFormat.listReadableMetadata();
        if (formatMetadata.size() > 0) {
            List<String> requestedFormatMetadataKeys = formatMetadataKeys.stream().map(k -> k.substring(VALUE_METADATA_PREFIX.length())).collect(Collectors.toList());
            this.valueDecodingFormat.applyReadableMetadata(requestedFormatMetadataKeys);
        }
        this.metadataKeys = connectorMetadataKeys;
        this.producedDataType = producedDataType;
    }

    @Override
    public void applyWatermark(WatermarkStrategy<RowData> watermarkStrategy) {
        this.watermarkStrategy = watermarkStrategy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TubeMQTableSource that = (TubeMQTableSource)o;
        return Objects.equals(this.physicalDataType, that.physicalDataType) && Objects.equals(this.valueDecodingFormat, that.valueDecodingFormat) && Objects.equals(this.masterAddress, that.masterAddress) && Objects.equals(this.topic, that.topic) && Objects.equals(String.valueOf(this.tidSet), String.valueOf(that.tidSet)) && Objects.equals(this.consumerGroup, that.consumerGroup) && Objects.equals(this.proctimeAttribute, that.proctimeAttribute) && Objects.equals(this.watermarkStrategy, that.watermarkStrategy);
    }

    public int hashCode() {
        return Objects.hash(this.physicalDataType, this.valueDecodingFormat, this.masterAddress, this.topic, this.tidSet, this.consumerGroup, this.configuration, this.watermarkStrategy, this.proctimeAttribute);
    }

    @Nullable
    private DeserializationSchema<RowData> createDeserialization(DynamicTableSource.Context context, @Nullable DecodingFormat<DeserializationSchema<RowData>> format, int[] projection, @Nullable String prefix) {
        if (format == null) {
            return null;
        }
        DataType physicalFormatDataType = DataTypeUtils.projectRow(this.physicalDataType, projection);
        if (prefix != null) {
            physicalFormatDataType = DataTypeUtils.stripRowPrefix(physicalFormatDataType, prefix);
        }
        return format.createRuntimeDecoder(context, physicalFormatDataType);
    }

    protected FlinkTubeMQConsumer<RowData> createTubeMQConsumer(DeserializationSchema<RowData> deserialization, TypeInformation<RowData> producedTypeInfo, boolean ignoreErrors) {
        DynamicTubeMQDeserializationSchema.MetadataConverter[] metadataConverters = (DynamicTubeMQDeserializationSchema.MetadataConverter[])this.metadataKeys.stream().map(k -> Stream.of(ReadableMetadata.values()).filter(rm -> rm.key.equals(k)).findFirst().orElseThrow(IllegalStateException::new)).map(m3 -> m3.converter).toArray(DynamicTubeMQDeserializationSchema.MetadataConverter[]::new);
        DynamicTubeMQDeserializationSchema tubeMQDeserializer = new DynamicTubeMQDeserializationSchema(deserialization, metadataConverters, producedTypeInfo, ignoreErrors);
        FlinkTubeMQConsumer<RowData> tubeMQConsumer = new FlinkTubeMQConsumer<RowData>(this.masterAddress, this.topic, this.tidSet, this.consumerGroup, tubeMQDeserializer, this.configuration, this.sessionKey, this.innerFormat);
        return tubeMQConsumer;
    }

    static enum ReadableMetadata {
        TOPIC("topic", (DataType)DataTypes.STRING().notNull(), new DynamicTubeMQDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object read(Message msg) {
                return StringData.fromString(msg.getTopic());
            }
        });

        final String key;
        final DataType dataType;
        final DynamicTubeMQDeserializationSchema.MetadataConverter converter;

        private ReadableMetadata(String key, DataType dataType, DynamicTubeMQDeserializationSchema.MetadataConverter converter) {
            this.key = key;
            this.dataType = dataType;
            this.converter = converter;
        }
    }
}

