/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.tubemq.table;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.util.Preconditions;

public class TubeMQOptions {
    public static final String PROPERTIES_PREFIX = "properties.";
    public static final String CONSUMER_FROM_MAX_OFFSET_ALWAYS = "max";
    public static final String CONSUMER_FROM_LATEST_OFFSET = "latest";
    public static final String CONSUMER_FROM_FIRST_OFFSET = "earliest";
    public static final ConfigOption<String> KEY_FORMAT = ConfigOptions.key((String)("key." + FactoryUtil.FORMAT.key())).stringType().noDefaultValue().withDescription("Defines the format identifier for encoding key data. The identifier is used to discover a suitable format factory.");
    public static final ConfigOption<List<String>> KEY_FIELDS = ConfigOptions.key((String)"key.fields").stringType().asList().defaultValues((Object[])new String[0]).withDescription("Defines an explicit list of physical columns from the table schema that configure the data type for the key format. By default, this list is empty and thus a key is undefined.");
    public static final ConfigOption<String> TOPIC = ConfigOptions.key((String)"topic").stringType().noDefaultValue().withDescription("Topic names from which the table is read. Either 'topic' or 'topic-pattern' must be set for source.");
    public static final ConfigOption<String> TOPIC_PATTERN = ConfigOptions.key((String)"topic-pattern").stringType().noDefaultValue().withDescription("Optional topic pattern from which the table is read for source. Either 'topic' or 'topic-pattern' must be set.");
    public static final ConfigOption<String> MASTER_RPC = ConfigOptions.key((String)"master.rpc").stringType().noDefaultValue().withDescription("Required TubeMQ master connection string");
    public static final ConfigOption<String> GROUP_ID = ConfigOptions.key((String)"group.id").stringType().noDefaultValue().withDescription("Required consumer group in TubeMQ consumer");
    public static final ConfigOption<String> TUBE_MESSAGE_NOT_FOUND_WAIT_PERIOD = ConfigOptions.key((String)"tubemq.message.not.found.wait.period").stringType().defaultValue((Object)"350ms").withDescription("The time of waiting period if tubeMQ broker return message not found.");
    public static final ConfigOption<Long> TUBE_SUBSCRIBE_RETRY_TIMEOUT = ConfigOptions.key((String)"tubemq.subscribe.retry.timeout").longType().defaultValue((Object)300000L).withDescription("The time of subscribing tubeMQ timeout, in millisecond");
    public static final ConfigOption<Integer> SOURCE_EVENT_QUEUE_CAPACITY = ConfigOptions.key((String)"source.event.queue.capacity").intType().defaultValue((Object)1024);
    public static final ConfigOption<String> SESSION_KEY = ConfigOptions.key((String)"session.key").stringType().defaultValue((Object)"default_session_key").withDescription("The session key for this consumer group at startup.");
    public static final ConfigOption<List<String>> TID = ConfigOptions.key((String)"topic.tid").stringType().asList().noDefaultValue().withDescription("The tid owned this topic.");
    public static final ConfigOption<Integer> MAX_RETRIES = ConfigOptions.key((String)"max.retries").intType().defaultValue((Object)5).withDescription("The maximum number of retries when an exception is caught.");
    public static final ConfigOption<Boolean> BOOTSTRAP_FROM_MAX = ConfigOptions.key((String)"bootstrap.from.max").booleanType().defaultValue((Object)true).withDescription("True if consuming from the most recent position when the tubemq source starts.. It only takes effect when the tubemq source does not recover from checkpoints.");
    public static final ConfigOption<String> SOURCE_MAX_IDLE_TIME = ConfigOptions.key((String)"source.task.max.idle.time").stringType().defaultValue((Object)"5min").withDescription("The max time of the source marked as temporarily idle.");
    public static final ConfigOption<String> MESSAGE_NOT_FOUND_WAIT_PERIOD = ConfigOptions.key((String)"message.not.found.wait.period").stringType().defaultValue((Object)"500ms").withDescription("The time of waiting period if tubemq broker return message not found.");
    public static final ConfigOption<ValueFieldsStrategy> VALUE_FIELDS_INCLUDE = ConfigOptions.key((String)"value.fields-include").enumType(ValueFieldsStrategy.class).defaultValue((Object)ValueFieldsStrategy.ALL).withDescription(String.format("Defines a strategy how to deal with key columns in the data type of the value format. By default, '%s' physical columns of the table schema will be included in the value format which means that the key columns appear in the data type for both the key and value format.", new Object[]{ValueFieldsStrategy.ALL}));
    public static final ConfigOption<String> KEY_FIELDS_PREFIX = ConfigOptions.key((String)"key.fields-prefix").stringType().noDefaultValue().withDescription(Description.builder().text("Defines a custom prefix for all fields of the key format to avoid name clashes with fields of the value format. By default, the prefix is empty.").linebreak().text(String.format("If a custom prefix is defined, both the table schema and '%s' will work with prefixed names.", KEY_FIELDS.key())).linebreak().text("When constructing the data type of the key format, the prefix will be removed and the non-prefixed names will be used within the key format.").linebreak().text(String.format("Please note that this option requires that '%s' must be '%s'.", new Object[]{VALUE_FIELDS_INCLUDE.key(), ValueFieldsStrategy.EXCEPT_KEY})).build());
    private static final Set<String> CONSUMER_STARTUP_MODE_ENUMS = new HashSet<String>(Arrays.asList("max", "latest", "earliest"));

    public static void validateTableSourceOptions(ReadableConfig tableOptions) {
        TubeMQOptions.validateSourceTopic(tableOptions);
    }

    public static void validateSourceTopic(ReadableConfig tableOptions) {
        Optional topic = tableOptions.getOptional(TOPIC);
        Optional pattern = tableOptions.getOptional(TOPIC_PATTERN);
        if (topic.isPresent() && pattern.isPresent()) {
            throw new ValidationException("Option 'topic' and 'topic-pattern' shouldn't be set together.");
        }
        if (!topic.isPresent() && !pattern.isPresent()) {
            throw new ValidationException("Either 'topic' or 'topic-pattern' must be set.");
        }
    }

    public static int[] createValueFormatProjection(ReadableConfig options, DataType physicalDataType) {
        LogicalType physicalType = physicalDataType.getLogicalType();
        Preconditions.checkArgument((boolean)LogicalTypeChecks.hasRoot(physicalType, LogicalTypeRoot.ROW), (Object)"Row data type expected.");
        int physicalFieldCount = LogicalTypeChecks.getFieldCount(physicalType);
        IntStream physicalFields = IntStream.range(0, physicalFieldCount);
        String keyPrefix = options.getOptional(KEY_FIELDS_PREFIX).orElse("");
        ValueFieldsStrategy strategy = (ValueFieldsStrategy)((Object)options.get(VALUE_FIELDS_INCLUDE));
        if (strategy == ValueFieldsStrategy.ALL) {
            if (keyPrefix.length() > 0) {
                throw new ValidationException(String.format("A key prefix is not allowed when option '%s' is set to '%s'. Set it to '%s' instead to avoid field overlaps.", new Object[]{VALUE_FIELDS_INCLUDE.key(), ValueFieldsStrategy.ALL, ValueFieldsStrategy.EXCEPT_KEY}));
            }
            return physicalFields.toArray();
        }
        if (strategy == ValueFieldsStrategy.EXCEPT_KEY) {
            int[] keyProjection = TubeMQOptions.createKeyFormatProjection(options, physicalDataType);
            return physicalFields.filter(pos -> IntStream.of(keyProjection).noneMatch(k -> k == pos)).toArray();
        }
        throw new TableException("Unknown value fields strategy:" + (Object)((Object)strategy));
    }

    public static int[] createKeyFormatProjection(ReadableConfig options, DataType physicalDataType) {
        LogicalType physicalType = physicalDataType.getLogicalType();
        Preconditions.checkArgument((boolean)LogicalTypeChecks.hasRoot(physicalType, LogicalTypeRoot.ROW), (Object)"Row data type expected.");
        Optional optionalKeyFormat = options.getOptional(KEY_FORMAT);
        Optional optionalKeyFields = options.getOptional(KEY_FIELDS);
        if (!optionalKeyFormat.isPresent() && optionalKeyFields.isPresent()) {
            throw new ValidationException(String.format("The option '%s' can only be declared if a key format is defined using '%s'.", KEY_FIELDS.key(), KEY_FORMAT.key()));
        }
        if (optionalKeyFormat.isPresent() && (!optionalKeyFields.isPresent() || ((List)optionalKeyFields.get()).size() == 0)) {
            throw new ValidationException(String.format("A key format '%s' requires the declaration of one or more of key fields using '%s'.", KEY_FORMAT.key(), KEY_FIELDS.key()));
        }
        if (!optionalKeyFormat.isPresent()) {
            return new int[0];
        }
        String keyPrefix = options.getOptional(KEY_FIELDS_PREFIX).orElse("");
        List keyFields = (List)optionalKeyFields.get();
        List<String> physicalFields = LogicalTypeChecks.getFieldNames(physicalType);
        return keyFields.stream().mapToInt(keyField -> {
            int pos = physicalFields.indexOf(keyField);
            if (pos < 0) {
                throw new ValidationException(String.format("Could not find the field '%s' in the table schema for usage in the key format.A key field must be a regular, physical column.The following columns can be selected in the '%s' option:\n%s", keyField, KEY_FIELDS.key(), physicalFields));
            }
            if (!keyField.startsWith(keyPrefix)) {
                throw new ValidationException(String.format("All fields in '%s' must be prefixed with '%s' when option '%s' is set but field '%s' is not prefixed.", KEY_FIELDS.key(), keyPrefix, KEY_FIELDS_PREFIX.key(), keyField));
            }
            return pos;
        }).toArray();
    }

    public static Configuration getTubeMQProperties(Map<String, String> tableOptions) {
        Configuration tubeMQProperties = new Configuration();
        if (TubeMQOptions.hasTubeMQClientProperties(tableOptions)) {
            tableOptions.keySet().stream().filter(key -> key.startsWith(PROPERTIES_PREFIX)).forEach(key -> {
                String value = (String)tableOptions.get(key);
                String subKey = key.substring(PROPERTIES_PREFIX.length());
                tubeMQProperties.toMap().put(subKey, value);
            });
        }
        return tubeMQProperties;
    }

    private static boolean hasTubeMQClientProperties(Map<String, String> tableOptions) {
        return tableOptions.keySet().stream().anyMatch(k -> k.startsWith(PROPERTIES_PREFIX));
    }

    public static String getSourceTopics(ReadableConfig tableOptions) {
        return tableOptions.getOptional(TOPIC).orElse(null);
    }

    public static String getMasterRpcAddress(ReadableConfig tableOptions) {
        return tableOptions.getOptional(MASTER_RPC).orElse(null);
    }

    public static TreeSet<String> getTiSet(ReadableConfig tableOptions) {
        final TreeSet<String> set = new TreeSet<String>();
        tableOptions.getOptional(TID).ifPresent(new Consumer<List<String>>(){

            @Override
            public void accept(List<String> strings) {
                set.addAll(strings);
            }
        });
        return set;
    }

    public static String getConsumerGroup(ReadableConfig tableOptions) {
        return tableOptions.getOptional(GROUP_ID).orElse(null);
    }

    public static String getSessionKey(ReadableConfig tableOptions) {
        return (String)tableOptions.getOptional(SESSION_KEY).orElse(SESSION_KEY.defaultValue());
    }

    public static enum ValueFieldsStrategy {
        ALL,
        EXCEPT_KEY;

    }
}

