/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.tubemq.table;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.format.Format;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.RowKind;
import org.apache.inlong.sort.tubemq.table.TubeMQOptions;
import org.apache.inlong.sort.tubemq.table.TubeMQTableSource;

public class TubeMQDynamicTableFactory
implements DynamicTableSourceFactory {
    public static final String IDENTIFIER = "tubemq";
    public static final List<String> INNERFORMATTYPE = Arrays.asList("inlong-msg");
    public static boolean innerFormat = false;

    private static DecodingFormat<DeserializationSchema<RowData>> getValueDecodingFormat(FactoryUtil.TableFactoryHelper helper) {
        return helper.discoverOptionalDecodingFormat(DeserializationFormatFactory.class, FactoryUtil.FORMAT).orElseGet(() -> helper.discoverDecodingFormat(DeserializationFormatFactory.class, FactoryUtil.FORMAT));
    }

    private static void validatePKConstraints(ObjectIdentifier tableName, CatalogTable catalogTable, Format format) {
        if (catalogTable.getSchema().getPrimaryKey().isPresent() && format.getChangelogMode().containsOnly(RowKind.INSERT)) {
            Configuration options = Configuration.fromMap(catalogTable.getOptions());
            String formatName = (String)options.getOptional(FactoryUtil.FORMAT).orElse(options.get(FactoryUtil.FORMAT));
            innerFormat = INNERFORMATTYPE.contains(formatName);
            throw new ValidationException(String.format("The TubeMQ table '%s' with '%s' format doesn't support defining PRIMARY KEY constraint on the table, because it can't guarantee the semantic of primary key.", tableName.asSummaryString(), formatName));
        }
    }

    private static Optional<DecodingFormat<DeserializationSchema<RowData>>> getKeyDecodingFormat(FactoryUtil.TableFactoryHelper helper) {
        Optional<DecodingFormat<DeserializationSchema<RowData>>> keyDecodingFormat = helper.discoverOptionalDecodingFormat(DeserializationFormatFactory.class, TubeMQOptions.KEY_FORMAT);
        keyDecodingFormat.ifPresent(format -> {
            if (!format.getChangelogMode().containsOnly(RowKind.INSERT)) {
                throw new ValidationException(String.format("A key format should only deal with INSERT-only records. But %s has a changelog mode of %s.", helper.getOptions().get(TubeMQOptions.KEY_FORMAT), format.getChangelogMode()));
            }
        });
        return keyDecodingFormat;
    }

    @Override
    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper(this, context);
        ReadableConfig tableOptions = helper.getOptions();
        DecodingFormat<DeserializationSchema<RowData>> valueDecodingFormat = TubeMQDynamicTableFactory.getValueDecodingFormat(helper);
        helper.validate();
        TubeMQDynamicTableFactory.validatePKConstraints(context.getObjectIdentifier(), context.getCatalogTable(), valueDecodingFormat);
        Configuration properties = TubeMQOptions.getTubeMQProperties(context.getCatalogTable().getOptions());
        DataType physicalDataType = context.getCatalogTable().getSchema().toPhysicalRowDataType();
        return this.createTubeMQTableSource(physicalDataType, valueDecodingFormat, TubeMQOptions.getSourceTopics(tableOptions), TubeMQOptions.getMasterRpcAddress(tableOptions), TubeMQOptions.getTiSet(tableOptions), TubeMQOptions.getConsumerGroup(tableOptions), TubeMQOptions.getSessionKey(tableOptions), properties);
    }

    protected TubeMQTableSource createTubeMQTableSource(DataType physicalDataType, DecodingFormat<DeserializationSchema<RowData>> valueDecodingFormat, String topic, String url, TreeSet<String> tid, String consumerGroup, String sessionKey, Configuration properties) {
        return new TubeMQTableSource(physicalDataType, valueDecodingFormat, url, topic, tid, consumerGroup, sessionKey, properties, null, null, false, innerFormat);
    }

    @Override
    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(TubeMQOptions.MASTER_RPC);
        return options;
    }

    @Override
    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(FactoryUtil.FORMAT);
        options.add(TubeMQOptions.TOPIC);
        options.add(TubeMQOptions.GROUP_ID);
        options.add(TubeMQOptions.TID);
        options.add(TubeMQOptions.SESSION_KEY);
        options.add(TubeMQOptions.BOOTSTRAP_FROM_MAX);
        options.add(TubeMQOptions.TOPIC_PATTERN);
        return options;
    }
}

