/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.tubemq.table;

import com.google.common.base.Objects;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.util.Collector;
import org.apache.inlong.tubemq.corebase.Message;

public class DynamicTubeMQDeserializationSchema
implements DeserializationSchema<RowData> {
    private final DeserializationSchema<RowData> deserializationSchema;
    private final MetadataConverter[] metadataConverters;
    private final TypeInformation<RowData> producedTypeInfo;
    private final boolean ignoreErrors;

    public DynamicTubeMQDeserializationSchema(DeserializationSchema<RowData> schema, MetadataConverter[] metadataConverters, TypeInformation<RowData> producedTypeInfo, boolean ignoreErrors) {
        this.deserializationSchema = schema;
        this.metadataConverters = metadataConverters;
        this.producedTypeInfo = producedTypeInfo;
        this.ignoreErrors = ignoreErrors;
    }

    public RowData deserialize(byte[] bytes) throws IOException {
        return (RowData)this.deserializationSchema.deserialize(bytes);
    }

    public void deserialize(byte[] message, Collector<RowData> out) throws IOException {
        this.deserializationSchema.deserialize(message, out);
    }

    public boolean isEndOfStream(RowData rowData) {
        return false;
    }

    public TypeInformation<RowData> getProducedType() {
        return this.producedTypeInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DynamicTubeMQDeserializationSchema)) {
            return false;
        }
        DynamicTubeMQDeserializationSchema that = (DynamicTubeMQDeserializationSchema)o;
        return this.ignoreErrors == that.ignoreErrors && Objects.equal(Arrays.stream(this.metadataConverters).collect(Collectors.toList()), Arrays.stream(that.metadataConverters).collect(Collectors.toList())) && Objects.equal(this.deserializationSchema, that.deserializationSchema) && Objects.equal(this.producedTypeInfo, that.producedTypeInfo);
    }

    public int hashCode() {
        return Objects.hashCode(this.deserializationSchema, this.metadataConverters, this.producedTypeInfo, this.ignoreErrors);
    }

    private void emitRow(Message head, GenericRowData physicalRow, Collector<RowData> out) {
        if (this.metadataConverters.length == 0) {
            out.collect((Object)physicalRow);
            return;
        }
        int physicalArity = physicalRow.getArity();
        int metadataArity = this.metadataConverters.length;
        GenericRowData producedRow = new GenericRowData(physicalRow.getRowKind(), physicalArity + metadataArity);
        for (int physicalPos = 0; physicalPos < physicalArity; ++physicalPos) {
            producedRow.setField(physicalPos, physicalRow.getField(physicalPos));
        }
        for (int metadataPos = 0; metadataPos < metadataArity; ++metadataPos) {
            producedRow.setField(physicalArity + metadataPos, this.metadataConverters[metadataPos].read(head));
        }
        out.collect((Object)producedRow);
    }

    static interface MetadataConverter
    extends Serializable {
        public Object read(Message var1);
    }
}

