/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.AbstractList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentCount;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.ConstantArgumentCount;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeCasts;
import org.apache.flink.util.Preconditions;

@Internal
public final class OrInputTypeStrategy
implements InputTypeStrategy {
    private final List<? extends InputTypeStrategy> inputStrategies;

    public OrInputTypeStrategy(List<? extends InputTypeStrategy> inputStrategies) {
        Preconditions.checkArgument((inputStrategies.size() > 0 ? 1 : 0) != 0);
        this.inputStrategies = inputStrategies;
    }

    @Override
    public ArgumentCount getArgumentCount() {
        final AbstractList<ArgumentCount> counts = new AbstractList<ArgumentCount>(){

            @Override
            public ArgumentCount get(int index) {
                return ((InputTypeStrategy)OrInputTypeStrategy.this.inputStrategies.get(index)).getArgumentCount();
            }

            @Override
            public int size() {
                return OrInputTypeStrategy.this.inputStrategies.size();
            }
        };
        final Integer min2 = OrInputTypeStrategy.commonMin((List<ArgumentCount>)counts);
        final Integer max = OrInputTypeStrategy.commonMax((List<ArgumentCount>)counts);
        ArgumentCount compositeCount = new ArgumentCount(){

            @Override
            public boolean isValidCount(int count) {
                for (ArgumentCount c : counts) {
                    if (!c.isValidCount(count)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Optional<Integer> getMinCount() {
                return Optional.ofNullable(min2);
            }

            @Override
            public Optional<Integer> getMaxCount() {
                return Optional.ofNullable(max);
            }
        };
        if (min2 == null || max == null) {
            return compositeCount;
        }
        for (int i = min2.intValue(); i <= max; ++i) {
            if (compositeCount.isValidCount(i)) continue;
            return compositeCount;
        }
        if (min2.equals(max)) {
            return ConstantArgumentCount.of(min2);
        }
        return ConstantArgumentCount.between(min2, max);
    }

    @Override
    public Optional<List<DataType>> inferInputTypes(CallContext callContext, boolean throwOnFailure) {
        List<LogicalType> actualTypes = callContext.getArgumentDataTypes().stream().map(DataType::getLogicalType).collect(Collectors.toList());
        Optional<List<DataType>> closestDataTypes = Optional.empty();
        for (InputTypeStrategy inputTypeStrategy : this.inputStrategies) {
            Optional<List<DataType>> inferredDataTypes = inputTypeStrategy.inferInputTypes(callContext, false);
            if (!inferredDataTypes.isPresent()) continue;
            List<LogicalType> inferredTypes = inferredDataTypes.get().stream().map(DataType::getLogicalType).collect(Collectors.toList());
            if (LogicalTypeCasts.supportsAvoidingCast(actualTypes, inferredTypes)) {
                return inferredDataTypes;
            }
            if (closestDataTypes.isPresent()) continue;
            closestDataTypes = inferredDataTypes;
        }
        return closestDataTypes;
    }

    @Override
    public List<Signature> getExpectedSignatures(FunctionDefinition definition) {
        return this.inputStrategies.stream().flatMap(v -> v.getExpectedSignatures(definition).stream()).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrInputTypeStrategy that = (OrInputTypeStrategy)o;
        return Objects.equals(this.inputStrategies, that.inputStrategies);
    }

    public int hashCode() {
        return Objects.hash(this.inputStrategies);
    }

    @Nullable
    private static Integer commonMin(List<ArgumentCount> counts) {
        int commonMin = Integer.MAX_VALUE;
        for (ArgumentCount count : counts) {
            Optional<Integer> min2 = count.getMinCount();
            if (!min2.isPresent()) {
                return null;
            }
            commonMin = Math.min(commonMin, min2.get());
        }
        if (commonMin == Integer.MAX_VALUE) {
            return null;
        }
        return commonMin;
    }

    @Nullable
    private static Integer commonMax(List<ArgumentCount> counts) {
        int commonMax = Integer.MIN_VALUE;
        for (ArgumentCount count : counts) {
            Optional<Integer> max = count.getMaxCount();
            if (!max.isPresent()) {
                return null;
            }
            commonMax = Math.max(commonMax, max.get());
        }
        if (commonMax == Integer.MIN_VALUE) {
            return null;
        }
        return commonMax;
    }
}

