/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.FunctionDescriptor;
import org.apache.flink.table.descriptors.FunctionDescriptorValidator;
import org.apache.flink.table.descriptors.LiteralValueValidator;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.functions.python.utils.PythonFunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionService {
    private static final Logger LOG = LoggerFactory.getLogger(FunctionService.class);

    public static UserDefinedFunction createFunction(FunctionDescriptor descriptor) {
        return FunctionService.createFunction(descriptor, Thread.currentThread().getContextClassLoader());
    }

    public static UserDefinedFunction createFunction(FunctionDescriptor descriptor, ClassLoader classLoader) {
        return FunctionService.createFunction(descriptor, classLoader, true);
    }

    public static UserDefinedFunction createFunction(FunctionDescriptor descriptor, ClassLoader classLoader, boolean performValidation) {
        return FunctionService.createFunction(descriptor, classLoader, performValidation, (ReadableConfig)new Configuration());
    }

    public static UserDefinedFunction createFunction(FunctionDescriptor descriptor, ClassLoader classLoader, boolean performValidation, ReadableConfig config) {
        Object instance;
        DescriptorProperties properties = new DescriptorProperties(true);
        properties.putProperties(descriptor.toProperties());
        if (performValidation) {
            new FunctionDescriptorValidator().validate(properties);
        }
        switch (properties.getString("from")) {
            case "class": {
                instance = FunctionService.generateInstance("", properties, classLoader);
                break;
            }
            case "python": {
                String fullyQualifiedName = properties.getString("fully-qualified-name");
                instance = PythonFunctionUtils.getPythonFunction(fullyQualifiedName, config, classLoader);
                break;
            }
            default: {
                throw new ValidationException(String.format("Unsupported function descriptor: %s", properties.getString("from")));
            }
        }
        if (!UserDefinedFunction.class.isAssignableFrom(instance.getClass())) {
            throw new ValidationException(String.format("Instantiated class '%s' is not a user-defined function.", instance.getClass().getName()));
        }
        return (UserDefinedFunction)instance;
    }

    private static <T> T generateInstance(String keyPrefix, DescriptorProperties descriptorProperties, ClassLoader classLoader) {
        Constructor<?> constructor;
        Class<?> instanceClass;
        String instanceClassName = descriptorProperties.getString(keyPrefix + "class");
        try {
            instanceClass = Class.forName(instanceClassName, true, classLoader);
        }
        catch (Exception e) {
            String msg = String.format("Could not find class '%s' for creating an instance.", instanceClassName);
            LOG.error(msg, e);
            throw new ValidationException(msg);
        }
        String constructorPrefix = keyPrefix + "constructor";
        List<Map<String, String>> constructorProps = descriptorProperties.getVariableIndexedProperties(constructorPrefix, new ArrayList<String>());
        ArrayList<Object> parameterList = new ArrayList<Object>();
        for (int i = 0; i < constructorProps.size(); ++i) {
            String constructorKey = constructorPrefix + "." + i + ".";
            if (constructorProps.get(i).containsKey("class")) {
                parameterList.add(FunctionService.generateInstance(constructorKey, descriptorProperties, classLoader));
                continue;
            }
            Object literalValue = LiteralValueValidator.getValue(constructorKey, descriptorProperties);
            parameterList.add(literalValue);
        }
        String parameterNames = parameterList.stream().map(t -> t.getClass().getName()).reduce((s1, s2) -> s1 + ", " + s2).orElse("");
        try {
            constructor = instanceClass.getConstructor((Class[])parameterList.stream().map(Object::getClass).toArray(Class[]::new));
        }
        catch (Exception e) {
            String msg = String.format("Cannot find a public constructor with parameter types '%s' for '%s'.", parameterNames, instanceClassName);
            LOG.error(msg, e);
            throw new ValidationException(msg);
        }
        try {
            return (T)constructor.newInstance(parameterList.toArray());
        }
        catch (Exception e) {
            String msg = String.format("Error while creating instance of class '%s' with parameter types '%s'.", instanceClassName, parameterNames);
            LOG.error(msg, e);
            throw new ValidationException(msg);
        }
    }
}

