/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.factories;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DelegatingConfiguration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.NoMatchingTableFactoryException;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CommonCatalogOptions;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.CatalogFactory;
import org.apache.flink.table.factories.DecodingFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.EncodingFormatFactory;
import org.apache.flink.table.factories.Factory;
import org.apache.flink.table.factories.TableFactoryService;
import org.apache.flink.table.utils.EncodingUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicEvolving
public final class FactoryUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FactoryUtil.class);
    public static final ConfigOption<Integer> PROPERTY_VERSION = ConfigOptions.key((String)"property-version").intType().defaultValue((Object)1).withDescription("Version of the overall property design. This option is meant for future backwards compatibility.");
    public static final ConfigOption<String> CONNECTOR = ConfigOptions.key((String)"connector").stringType().noDefaultValue().withDescription("Uniquely identifies the connector of a dynamic table that is used for accessing data in an external system. Its value is used during table source and table sink discovery.");
    public static final ConfigOption<String> FORMAT = ConfigOptions.key((String)"format").stringType().noDefaultValue().withDescription("Defines the format identifier for encoding data. The identifier is used to discover a suitable format factory.");
    public static final ConfigOption<Integer> SINK_PARALLELISM = ConfigOptions.key((String)"sink.parallelism").intType().noDefaultValue().withDescription("Defines a custom parallelism for the sink. By default, if this option is not defined, the planner will derive the parallelism for each statement individually by also considering the global configuration.");
    public static final String FORMAT_SUFFIX = ".format";
    public static final String PLACEHOLDER_SYMBOL = "#";

    public static DynamicTableSource createTableSource(@Nullable Catalog catalog, ObjectIdentifier objectIdentifier, ResolvedCatalogTable catalogTable, ReadableConfig configuration, ClassLoader classLoader, boolean isTemporary) {
        DefaultDynamicTableContext context = new DefaultDynamicTableContext(objectIdentifier, catalogTable, configuration, classLoader, isTemporary);
        try {
            DynamicTableSourceFactory factory = FactoryUtil.getDynamicTableFactory(DynamicTableSourceFactory.class, catalog, context);
            return factory.createDynamicTableSource(context);
        }
        catch (Throwable t) {
            throw new ValidationException(String.format("Unable to create a source for reading table '%s'.\n\nTable options are:\n\n%s", objectIdentifier.asSummaryString(), catalogTable.getOptions().entrySet().stream().map(e -> FactoryUtil.stringifyOption((String)e.getKey(), (String)e.getValue())).sorted().collect(Collectors.joining("\n"))), t);
        }
    }

    public static DynamicTableSink createTableSink(@Nullable Catalog catalog, ObjectIdentifier objectIdentifier, ResolvedCatalogTable catalogTable, ReadableConfig configuration, ClassLoader classLoader, boolean isTemporary) {
        DefaultDynamicTableContext context = new DefaultDynamicTableContext(objectIdentifier, catalogTable, configuration, classLoader, isTemporary);
        try {
            DynamicTableSinkFactory factory = FactoryUtil.getDynamicTableFactory(DynamicTableSinkFactory.class, catalog, context);
            return factory.createDynamicTableSink(context);
        }
        catch (Throwable t) {
            throw new ValidationException(String.format("Unable to create a sink for writing table '%s'.\n\nTable options are:\n\n%s", objectIdentifier.asSummaryString(), catalogTable.getOptions().entrySet().stream().map(e -> FactoryUtil.stringifyOption((String)e.getKey(), (String)e.getValue())).sorted().collect(Collectors.joining("\n"))), t);
        }
    }

    public static CatalogFactoryHelper createCatalogFactoryHelper(CatalogFactory factory, CatalogFactory.Context context) {
        return new CatalogFactoryHelper(factory, context);
    }

    public static TableFactoryHelper createTableFactoryHelper(DynamicTableFactory factory, DynamicTableFactory.Context context) {
        return new TableFactoryHelper(factory, context);
    }

    public static Catalog createCatalog(String catalogName, Map<String, String> options, ReadableConfig configuration, ClassLoader classLoader) {
        try {
            CatalogFactory legacyFactory = TableFactoryService.find(CatalogFactory.class, options, classLoader);
            return legacyFactory.createCatalog(catalogName, options);
        }
        catch (NoMatchingTableFactoryException e) {
            DefaultCatalogContext discoveryContext = new DefaultCatalogContext(catalogName, options, configuration, classLoader);
            try {
                CatalogFactory factory = FactoryUtil.getCatalogFactory(discoveryContext);
                Map<String, String> factoryOptions = options.entrySet().stream().filter(entry -> !CommonCatalogOptions.CATALOG_TYPE.key().equals(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                DefaultCatalogContext context = new DefaultCatalogContext(catalogName, factoryOptions, configuration, classLoader);
                return factory.createCatalog(context);
            }
            catch (Throwable t) {
                throw new ValidationException(String.format("Unable to create catalog '%s'.%n%nCatalog options are:%n%s", catalogName, options.entrySet().stream().map(optionEntry -> FactoryUtil.stringifyOption((String)optionEntry.getKey(), (String)optionEntry.getValue())).sorted().collect(Collectors.joining("\n"))), t);
            }
        }
    }

    public static <T extends Factory> T discoverFactory(ClassLoader classLoader, Class<T> factoryClass, String factoryIdentifier) {
        List<Factory> factories = FactoryUtil.discoverFactories(classLoader);
        List foundFactories = factories.stream().filter(f -> factoryClass.isAssignableFrom(f.getClass())).collect(Collectors.toList());
        if (foundFactories.isEmpty()) {
            throw new ValidationException(String.format("Could not find any factories that implement '%s' in the classpath.", factoryClass.getName()));
        }
        List matchingFactories = foundFactories.stream().filter(f -> f.factoryIdentifier().equals(factoryIdentifier)).collect(Collectors.toList());
        if (matchingFactories.isEmpty()) {
            throw new ValidationException(String.format("Could not find any factory for identifier '%s' that implements '%s' in the classpath.\n\nAvailable factory identifiers are:\n\n%s", factoryIdentifier, factoryClass.getName(), foundFactories.stream().map(Factory::factoryIdentifier).distinct().sorted().collect(Collectors.joining("\n"))));
        }
        if (matchingFactories.size() > 1) {
            throw new ValidationException(String.format("Multiple factories for identifier '%s' that implement '%s' found in the classpath.\n\nAmbiguous factory classes are:\n\n%s", factoryIdentifier, factoryClass.getName(), matchingFactories.stream().map(f -> f.getClass().getName()).sorted().collect(Collectors.joining("\n"))));
        }
        return (T)((Factory)matchingFactories.get(0));
    }

    public static void validateFactoryOptions(Factory factory, ReadableConfig options) {
        FactoryUtil.validateFactoryOptions(factory.requiredOptions(), factory.optionalOptions(), options);
    }

    public static void validateFactoryOptions(Set<ConfigOption<?>> requiredOptions, Set<ConfigOption<?>> optionalOptions, ReadableConfig options) {
        List missingRequiredOptions = requiredOptions.stream().filter(option -> !option.key().contains(PLACEHOLDER_SYMBOL)).filter(option -> FactoryUtil.readOption(options, option) == null).map(ConfigOption::key).sorted().collect(Collectors.toList());
        if (!missingRequiredOptions.isEmpty()) {
            throw new ValidationException(String.format("One or more required options are missing.\n\nMissing required options are:\n\n%s", String.join((CharSequence)"\n", missingRequiredOptions)));
        }
        optionalOptions.forEach(option -> FactoryUtil.readOption(options, option));
    }

    public static void validateUnconsumedKeys(String factoryIdentifier, Set<String> allOptionKeys, Set<String> consumedOptionKeys) {
        HashSet<String> remainingOptionKeys = new HashSet<String>(allOptionKeys);
        remainingOptionKeys.removeAll(consumedOptionKeys);
        if (!remainingOptionKeys.isEmpty()) {
            throw new ValidationException(String.format("Unsupported options found for '%s'.\n\nUnsupported options:\n\n%s\n\nSupported options:\n\n%s", factoryIdentifier, remainingOptionKeys.stream().sorted().collect(Collectors.joining("\n")), consumedOptionKeys.stream().sorted().collect(Collectors.joining("\n"))));
        }
    }

    private static <T extends DynamicTableFactory> T getDynamicTableFactory(Class<T> factoryClass, @Nullable Catalog catalog, DefaultDynamicTableContext context) {
        Factory factory;
        if (catalog != null && (factory = (Factory)catalog.getFactory().filter(f -> factoryClass.isAssignableFrom(f.getClass())).orElse(null)) != null) {
            return (T)((DynamicTableFactory)factory);
        }
        String connectorOption = context.getCatalogTable().getOptions().get(CONNECTOR.key());
        if (connectorOption == null) {
            throw new ValidationException(String.format("Table options do not contain an option key '%s' for discovering a connector.", CONNECTOR.key()));
        }
        try {
            return (T)((DynamicTableFactory)FactoryUtil.discoverFactory(context.getClassLoader(), factoryClass, connectorOption));
        }
        catch (ValidationException e) {
            throw FactoryUtil.enrichNoMatchingConnectorError(factoryClass, context, connectorOption);
        }
    }

    private static CatalogFactory getCatalogFactory(CatalogFactory.Context context) {
        String catalogType = context.getOptions().get(CommonCatalogOptions.CATALOG_TYPE.key());
        if (catalogType == null) {
            throw new ValidationException(String.format("Catalog options do not contain an option key '%s' for discovering a catalog.", CommonCatalogOptions.CATALOG_TYPE.key()));
        }
        return FactoryUtil.discoverFactory(context.getClassLoader(), CatalogFactory.class, catalogType);
    }

    private static ValidationException enrichNoMatchingConnectorError(Class<?> factoryClass, DefaultDynamicTableContext context, String connectorOption) {
        DynamicTableFactory factory;
        try {
            factory = FactoryUtil.discoverFactory(context.getClassLoader(), DynamicTableFactory.class, connectorOption);
        }
        catch (ValidationException e) {
            return new ValidationException(String.format("Cannot discover a connector using option: %s", FactoryUtil.stringifyOption(CONNECTOR.key(), connectorOption)), e);
        }
        Class<DynamicTableSourceFactory> sourceFactoryClass = DynamicTableSourceFactory.class;
        Class<DynamicTableSinkFactory> sinkFactoryClass = DynamicTableSinkFactory.class;
        if (sourceFactoryClass.equals(factoryClass) && sinkFactoryClass.isAssignableFrom(factory.getClass())) {
            return new ValidationException(String.format("Connector '%s' can only be used as a sink. It cannot be used as a source.", connectorOption));
        }
        if (sinkFactoryClass.equals(factoryClass) && sourceFactoryClass.isAssignableFrom(factory.getClass())) {
            return new ValidationException(String.format("Connector '%s' can only be used as a source. It cannot be used as a sink.", connectorOption));
        }
        return new ValidationException(String.format("Connector '%s' does neither implement the '%s' nor the '%s' interface.", connectorOption, sourceFactoryClass.getName(), sinkFactoryClass.getName()));
    }

    private static List<Factory> discoverFactories(ClassLoader classLoader) {
        try {
            LinkedList<Factory> result = new LinkedList<Factory>();
            ServiceLoader.load(Factory.class, classLoader).iterator().forEachRemaining(result::add);
            return result;
        }
        catch (ServiceConfigurationError e) {
            LOG.error("Could not load service provider for factories.", e);
            throw new TableException("Could not load service provider for factories.", e);
        }
    }

    private static String stringifyOption(String key, String value) {
        return String.format("'%s'='%s'", EncodingUtils.escapeSingleQuotes(key), EncodingUtils.escapeSingleQuotes(value));
    }

    private static <T> T readOption(ReadableConfig options, ConfigOption<T> option) {
        try {
            return (T)options.get(option);
        }
        catch (Throwable t) {
            throw new ValidationException(String.format("Invalid value for option '%s'.", option.key()), t);
        }
    }

    private FactoryUtil() {
    }

    public static class DefaultCatalogContext
    implements CatalogFactory.Context {
        private final String name;
        private final Map<String, String> options;
        private final ReadableConfig configuration;
        private final ClassLoader classLoader;

        public DefaultCatalogContext(String name, Map<String, String> options, ReadableConfig configuration, ClassLoader classLoader) {
            this.name = name;
            this.options = options;
            this.configuration = configuration;
            this.classLoader = classLoader;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Map<String, String> getOptions() {
            return this.options;
        }

        @Override
        public ReadableConfig getConfiguration() {
            return this.configuration;
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.classLoader;
        }
    }

    public static class DefaultDynamicTableContext
    implements DynamicTableFactory.Context {
        private final ObjectIdentifier objectIdentifier;
        private final ResolvedCatalogTable catalogTable;
        private final ReadableConfig configuration;
        private final ClassLoader classLoader;
        private final boolean isTemporary;

        public DefaultDynamicTableContext(ObjectIdentifier objectIdentifier, ResolvedCatalogTable catalogTable, ReadableConfig configuration, ClassLoader classLoader, boolean isTemporary) {
            this.objectIdentifier = objectIdentifier;
            this.catalogTable = catalogTable;
            this.configuration = configuration;
            this.classLoader = classLoader;
            this.isTemporary = isTemporary;
        }

        @Override
        public ObjectIdentifier getObjectIdentifier() {
            return this.objectIdentifier;
        }

        @Override
        public ResolvedCatalogTable getCatalogTable() {
            return this.catalogTable;
        }

        @Override
        public ReadableConfig getConfiguration() {
            return this.configuration;
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        @Override
        public boolean isTemporary() {
            return this.isTemporary;
        }
    }

    public static class TableFactoryHelper {
        private final DynamicTableFactory tableFactory;
        private final DynamicTableFactory.Context context;
        private final Configuration allOptions;
        private final Set<String> consumedOptionKeys;

        private TableFactoryHelper(DynamicTableFactory tableFactory, DynamicTableFactory.Context context) {
            this.tableFactory = tableFactory;
            this.context = context;
            this.allOptions = Configuration.fromMap(context.getCatalogTable().getOptions());
            this.consumedOptionKeys = new HashSet<String>();
            this.consumedOptionKeys.add(PROPERTY_VERSION.key());
            this.consumedOptionKeys.add(CONNECTOR.key());
            this.consumedOptionKeys.addAll(tableFactory.requiredOptions().stream().map(ConfigOption::key).collect(Collectors.toSet()));
            this.consumedOptionKeys.addAll(tableFactory.optionalOptions().stream().map(ConfigOption::key).collect(Collectors.toSet()));
        }

        public <I, F extends DecodingFormatFactory<I>> DecodingFormat<I> discoverDecodingFormat(Class<F> formatFactoryClass, ConfigOption<String> formatOption) {
            return this.discoverOptionalDecodingFormat(formatFactoryClass, formatOption).orElseThrow(() -> new ValidationException(String.format("Could not find required scan format '%s'.", formatOption.key())));
        }

        public <I, F extends DecodingFormatFactory<I>> Optional<DecodingFormat<I>> discoverOptionalDecodingFormat(Class<F> formatFactoryClass, ConfigOption<String> formatOption) {
            return this.discoverOptionalFormatFactory(formatFactoryClass, formatOption).map(formatFactory -> {
                String formatPrefix = this.formatPrefix((Factory)formatFactory, formatOption);
                try {
                    return formatFactory.createDecodingFormat(this.context, this.projectOptions(formatPrefix));
                }
                catch (Throwable t) {
                    throw new ValidationException(String.format("Error creating scan format '%s' in option space '%s'.", formatFactory.factoryIdentifier(), formatPrefix), t);
                }
            });
        }

        public <I, F extends EncodingFormatFactory<I>> EncodingFormat<I> discoverEncodingFormat(Class<F> formatFactoryClass, ConfigOption<String> formatOption) {
            return this.discoverOptionalEncodingFormat(formatFactoryClass, formatOption).orElseThrow(() -> new ValidationException(String.format("Could not find required sink format '%s'.", formatOption.key())));
        }

        public <I, F extends EncodingFormatFactory<I>> Optional<EncodingFormat<I>> discoverOptionalEncodingFormat(Class<F> formatFactoryClass, ConfigOption<String> formatOption) {
            return this.discoverOptionalFormatFactory(formatFactoryClass, formatOption).map(formatFactory -> {
                String formatPrefix = this.formatPrefix((Factory)formatFactory, formatOption);
                try {
                    return formatFactory.createEncodingFormat(this.context, this.projectOptions(formatPrefix));
                }
                catch (Throwable t) {
                    throw new ValidationException(String.format("Error creating sink format '%s' in option space '%s'.", formatFactory.factoryIdentifier(), formatPrefix), t);
                }
            });
        }

        public void validate() {
            FactoryUtil.validateFactoryOptions(this.tableFactory, (ReadableConfig)this.allOptions);
            FactoryUtil.validateUnconsumedKeys(this.tableFactory.factoryIdentifier(), this.allOptions.keySet(), this.consumedOptionKeys);
        }

        public void validateExcept(String ... prefixesToSkip) {
            Preconditions.checkArgument((prefixesToSkip.length > 0 ? 1 : 0) != 0, (Object)"Prefixes to skip can not be empty.");
            List<String> prefixesList = Arrays.asList(prefixesToSkip);
            this.consumedOptionKeys.addAll(this.allOptions.keySet().stream().filter(key -> prefixesList.stream().anyMatch(key::startsWith)).collect(Collectors.toSet()));
            this.validate();
        }

        public ReadableConfig getOptions() {
            return this.allOptions;
        }

        private <F extends Factory> Optional<F> discoverOptionalFormatFactory(Class<F> formatFactoryClass, ConfigOption<String> formatOption) {
            String identifier = (String)this.allOptions.get(formatOption);
            if (identifier == null) {
                return Optional.empty();
            }
            F factory = FactoryUtil.discoverFactory(this.context.getClassLoader(), formatFactoryClass, identifier);
            String formatPrefix = this.formatPrefix((Factory)factory, formatOption);
            this.consumedOptionKeys.addAll(factory.requiredOptions().stream().map(ConfigOption::key).map(k -> formatPrefix + k).collect(Collectors.toSet()));
            this.consumedOptionKeys.addAll(factory.optionalOptions().stream().map(ConfigOption::key).map(k -> formatPrefix + k).collect(Collectors.toSet()));
            return Optional.of(factory);
        }

        private String formatPrefix(Factory formatFactory, ConfigOption<String> formatOption) {
            String identifier = formatFactory.factoryIdentifier();
            if (formatOption.key().equals(FORMAT.key())) {
                return identifier + ".";
            }
            if (formatOption.key().endsWith(FactoryUtil.FORMAT_SUFFIX)) {
                String keyPrefix = formatOption.key().substring(0, formatOption.key().length() - FactoryUtil.FORMAT_SUFFIX.length());
                return keyPrefix + "." + identifier + ".";
            }
            throw new ValidationException("Format identifier key should be 'format' or suffix with '.format', don't support format identifier key '" + formatOption.key() + "'.");
        }

        private ReadableConfig projectOptions(String formatPrefix) {
            return new DelegatingConfiguration(this.allOptions, formatPrefix);
        }
    }

    @PublicEvolving
    public static class CatalogFactoryHelper {
        private final CatalogFactory catalogFactory;
        private final CatalogFactory.Context context;
        private final Configuration configuration;
        private final Set<String> consumedOptionKeys;

        public CatalogFactoryHelper(CatalogFactory catalogFactory, CatalogFactory.Context context) {
            this.catalogFactory = catalogFactory;
            this.context = context;
            this.configuration = Configuration.fromMap(context.getOptions());
            this.consumedOptionKeys = new HashSet<String>();
            this.consumedOptionKeys.add(PROPERTY_VERSION.key());
            Stream.concat(catalogFactory.requiredOptions().stream(), catalogFactory.optionalOptions().stream()).map(ConfigOption::key).forEach(this.consumedOptionKeys::add);
        }

        public void validate() {
            FactoryUtil.validateFactoryOptions(this.catalogFactory, (ReadableConfig)this.configuration);
            FactoryUtil.validateUnconsumedKeys(this.catalogFactory.factoryIdentifier(), this.configuration.keySet(), this.consumedOptionKeys);
        }

        public void validateExcept(String ... prefixesToSkip) {
            Preconditions.checkArgument((prefixesToSkip.length > 0 ? 1 : 0) != 0, (Object)"Prefixes to skip can not be empty.");
            List<String> prefixesList = Arrays.asList(prefixesToSkip);
            this.consumedOptionKeys.addAll(this.configuration.keySet().stream().filter(key -> prefixesList.stream().anyMatch(key::startsWith)).collect(Collectors.toSet()));
            this.validate();
        }

        public ReadableConfig getOptions() {
            return this.configuration;
        }
    }
}

