/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data;

import java.util.Map;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.MapData;

@PublicEvolving
public final class GenericMapData
implements MapData {
    private final Map<?, ?> map;

    public GenericMapData(Map<?, ?> map) {
        this.map = map;
    }

    public Object get(Object key) {
        return this.map.get(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public ArrayData keyArray() {
        Object[] keys = this.map.keySet().toArray();
        return new GenericArrayData(keys);
    }

    @Override
    public ArrayData valueArray() {
        Object[] values = this.map.values().toArray();
        return new GenericArrayData(values);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenericMapData)) {
            return false;
        }
        return GenericMapData.deepEquals(this.map, ((GenericMapData)o).map);
    }

    private static <K, V> boolean deepEquals(Map<K, V> m1, Map<?, ?> m22) {
        if (m1.size() != m22.size()) {
            return false;
        }
        try {
            for (Map.Entry<K, V> e : m1.entrySet()) {
                K key = e.getKey();
                V value = e.getValue();
                if (!(value == null ? m22.get(key) != null || !m22.containsKey(key) : !Objects.deepEquals(value, m22.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException | NullPointerException unused) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        for (Object key : this.map.keySet()) {
            result += 31 * Objects.hashCode(key);
        }
        return result;
    }
}

