/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.persistence;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import java.util.zip.CheckedOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.jute.InputArchive;
import org.apache.jute.OutputArchive;
import org.apache.zookeeper.common.AtomicFileOutputStream;
import org.apache.zookeeper.server.persistence.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xerial.snappy.SnappyCodec;
import org.xerial.snappy.SnappyInputStream;
import org.xerial.snappy.SnappyOutputStream;

public class SnapStream {
    private static final Logger LOG = LoggerFactory.getLogger(SnapStream.class);
    public static final String ZOOKEEPER_SHAPSHOT_STREAM_MODE = "zookeeper.snapshot.compression.method";
    private static StreamMode streamMode = StreamMode.fromString(System.getProperty("zookeeper.snapshot.compression.method", StreamMode.DEFAULT_MODE.getName()));

    public static CheckedInputStream getInputStream(File file) throws IOException {
        InputStream is;
        FileInputStream fis = new FileInputStream(file);
        switch (SnapStream.getStreamMode(file.getName())) {
            case GZIP: {
                is = new GZIPInputStream(fis);
                break;
            }
            case SNAPPY: {
                is = new SnappyInputStream(fis);
                break;
            }
            default: {
                is = new BufferedInputStream(fis);
            }
        }
        return new CheckedInputStream(is, new Adler32());
    }

    public static CheckedOutputStream getOutputStream(File file, boolean fsync) throws IOException {
        OutputStream os;
        OutputStream fos = fsync ? new AtomicFileOutputStream(file) : new FileOutputStream(file);
        switch (streamMode) {
            case GZIP: {
                os = new GZIPOutputStream(fos);
                break;
            }
            case SNAPPY: {
                os = new SnappyOutputStream(fos);
                break;
            }
            default: {
                os = new BufferedOutputStream(fos);
            }
        }
        return new CheckedOutputStream(os, new Adler32());
    }

    public static void sealStream(CheckedOutputStream os, OutputArchive oa) throws IOException {
        long val2 = os.getChecksum().getValue();
        oa.writeLong(val2, "val");
        oa.writeString("/", "path");
    }

    static void checkSealIntegrity(CheckedInputStream is, InputArchive ia) throws IOException {
        long checkSum = is.getChecksum().getValue();
        long val2 = ia.readLong("val");
        ia.readString("path");
        if (val2 != checkSum) {
            throw new IOException("CRC corruption");
        }
    }

    public static boolean isValidSnapshot(File file) throws IOException {
        if (file == null || Util.getZxidFromName(file.getName(), "snapshot") == -1L) {
            return false;
        }
        boolean isValid = false;
        switch (SnapStream.getStreamMode(file.getName())) {
            case GZIP: {
                isValid = SnapStream.isValidGZipStream(file);
                break;
            }
            case SNAPPY: {
                isValid = SnapStream.isValidSnappyStream(file);
                break;
            }
            default: {
                isValid = SnapStream.isValidCheckedStream(file);
            }
        }
        return isValid;
    }

    public static void setStreamMode(StreamMode mode) {
        streamMode = mode;
    }

    public static StreamMode getStreamMode() {
        return streamMode;
    }

    public static StreamMode getStreamMode(String fileName) {
        String[] splitSnapName = fileName.split("\\.");
        if (splitSnapName.length > 1) {
            String mode = splitSnapName[splitSnapName.length - 1];
            return StreamMode.fromString(mode);
        }
        return StreamMode.CHECKED;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isValidGZipStream(File f) throws IOException {
        byte[] byteArray = new byte[2];
        try (FileInputStream fis = new FileInputStream(f);){
            if (2 != fis.read(byteArray, 0, 2)) {
                LOG.error("Read incorrect number of bytes from {}", (Object)f.getName());
                boolean bl2 = false;
                return bl2;
            }
            ByteBuffer bb = ByteBuffer.wrap(byteArray);
            byte[] magicHeader = new byte[2];
            bb.get(magicHeader, 0, 2);
            int magic = magicHeader[0] & 0xFF | magicHeader[1] << 8 & 0xFF00;
            boolean bl = magic == 35615;
            return bl;
        }
        catch (FileNotFoundException e) {
            LOG.error("Unable to open file {}", (Object)f.getName(), (Object)e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isValidSnappyStream(File f) throws IOException {
        byte[] byteArray = new byte[SnappyCodec.MAGIC_LEN];
        try (FileInputStream fis = new FileInputStream(f);){
            if (SnappyCodec.MAGIC_LEN != fis.read(byteArray, 0, SnappyCodec.MAGIC_LEN)) {
                LOG.error("Read incorrect number of bytes from {}", (Object)f.getName());
                boolean bl2 = false;
                return bl2;
            }
            ByteBuffer bb = ByteBuffer.wrap(byteArray);
            byte[] magicHeader = new byte[SnappyCodec.MAGIC_LEN];
            bb.get(magicHeader, 0, SnappyCodec.MAGIC_LEN);
            boolean bl = Arrays.equals(magicHeader, SnappyCodec.getMagicHeader());
            return bl;
        }
        catch (FileNotFoundException e) {
            LOG.error("Unable to open file {}", (Object)f.getName(), (Object)e);
            return false;
        }
    }

    private static boolean isValidCheckedStream(File f) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(f, "r");){
            int readlen;
            int l;
            if (raf.length() < 10L) {
                boolean bl = false;
                return bl;
            }
            raf.seek(raf.length() - 5L);
            byte[] bytes = new byte[5];
            for (readlen = 0; readlen < 5 && (l = raf.read(bytes, readlen, bytes.length - readlen)) >= 0; readlen += l) {
            }
            if (readlen != bytes.length) {
                LOG.info("Invalid snapshot {}. too short, len = {} bytes", (Object)f.getName(), (Object)readlen);
                boolean bl = false;
                return bl;
            }
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            int len = bb.getInt();
            byte b = bb.get();
            if (len != 1 || b != 47) {
                LOG.info("Invalid snapshot {}. len = {}, byte = {}", f.getName(), len, b & 0xFF);
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    static {
        LOG.info("{} = {}", (Object)ZOOKEEPER_SHAPSHOT_STREAM_MODE, (Object)streamMode);
    }

    public static enum StreamMode {
        GZIP("gz"),
        SNAPPY("snappy"),
        CHECKED("");

        public static final StreamMode DEFAULT_MODE;
        private String name;

        private StreamMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getFileExtension() {
            return this.name.isEmpty() ? "" : "." + this.name;
        }

        public static StreamMode fromString(String name) {
            for (StreamMode c : StreamMode.values()) {
                if (c.getName().compareToIgnoreCase(name) != 0) continue;
                return c;
            }
            return DEFAULT_MODE;
        }

        static {
            DEFAULT_MODE = CHECKED;
        }
    }
}

