/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.cli;

import java.util.Arrays;
import org.apache.flink.elasticsearch7.shaded.org.apache.commons.cli.CommandLine;
import org.apache.flink.elasticsearch7.shaded.org.apache.commons.cli.Options;
import org.apache.flink.elasticsearch7.shaded.org.apache.commons.cli.ParseException;
import org.apache.flink.elasticsearch7.shaded.org.apache.commons.cli.PosixParser;
import org.apache.zookeeper.AddWatchMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.cli.CliCommand;
import org.apache.zookeeper.cli.CliException;
import org.apache.zookeeper.cli.CliParseException;
import org.apache.zookeeper.cli.CliWrapperException;

public class AddWatchCommand
extends CliCommand {
    private static final Options options = new Options();
    private static final AddWatchMode defaultMode = AddWatchMode.PERSISTENT_RECURSIVE;
    private CommandLine cl;
    private AddWatchMode mode = defaultMode;

    public AddWatchCommand() {
        super("addWatch", "[-m mode] path # optional mode is one of " + Arrays.toString((Object[])AddWatchMode.values()) + " - default is " + defaultMode.name());
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws CliParseException {
        PosixParser parser = new PosixParser();
        try {
            this.cl = parser.parse(options, cmdArgs);
        }
        catch (ParseException ex) {
            throw new CliParseException(ex);
        }
        if (this.cl.getArgs().length != 2) {
            throw new CliParseException(this.getUsageStr());
        }
        if (this.cl.hasOption("m")) {
            try {
                this.mode = AddWatchMode.valueOf(this.cl.getOptionValue("m").toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new CliParseException(this.getUsageStr());
            }
        }
        return this;
    }

    @Override
    public boolean exec() throws CliException {
        String path = this.cl.getArgs()[1];
        try {
            this.zk.addWatch(path, this.mode);
        }
        catch (InterruptedException | KeeperException ex) {
            throw new CliWrapperException(ex);
        }
        return false;
    }

    static {
        options.addOption("m", true, "");
    }
}

