/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.resource.loader;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.flink.elasticsearch7.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.apache.velocity.util.ExtProperties;

public class DataSourceResourceLoader
extends ResourceLoader {
    private String dataSourceName;
    private String tableName;
    private String keyColumn;
    private String templateColumn;
    private String timestampColumn;
    private InitialContext ctx;
    private DataSource dataSource;
    private Connection connection = null;
    private PreparedStatement templatePrepStatement = null;
    private PreparedStatement timestampPrepStatement = null;

    @Override
    public void init(ExtProperties configuration) {
        this.dataSourceName = StringUtils.trim(configuration.getString("datasource_url"));
        this.tableName = StringUtils.trim(configuration.getString("resource.table"));
        this.keyColumn = StringUtils.trim(configuration.getString("resource.key_column"));
        this.templateColumn = StringUtils.trim(configuration.getString("resource.template_column"));
        this.timestampColumn = StringUtils.trim(configuration.getString("resource.timestamp_column"));
        if (this.dataSource != null) {
            this.log.debug("DataSourceResourceLoader: using dataSource instance with table \"{}\"", (Object)this.tableName);
            this.log.debug("DataSourceResourceLoader: using columns \"{}\", \"{}\" and \"{}\"", this.keyColumn, this.templateColumn, this.timestampColumn);
            this.log.trace("DataSourceResourceLoader initialized.");
        } else if (this.dataSourceName != null) {
            this.log.debug("DataSourceResourceLoader: using \"{}\" datasource with table \"{}\"", (Object)this.dataSourceName, (Object)this.tableName);
            this.log.debug("DataSourceResourceLoader: using columns \"{}\", \"{}\" and \"{}\"", this.keyColumn, this.templateColumn, this.timestampColumn);
            this.log.trace("DataSourceResourceLoader initialized.");
        } else {
            String msg = "DataSourceResourceLoader not properly initialized. No DataSource was identified.";
            this.log.error(msg);
            throw new RuntimeException(msg);
        }
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public boolean isSourceModified(Resource resource) {
        return resource.getLastModified() != this.readLastModified(resource, "checking timestamp");
    }

    @Override
    public long getLastModified(Resource resource) {
        return this.readLastModified(resource, "getting timestamp");
    }

    @Override
    public synchronized Reader getResourceReader(String name, String encoding) throws ResourceNotFoundException {
        if (StringUtils.isEmpty(name)) {
            throw new ResourceNotFoundException("DataSourceResourceLoader: Template name was empty or null");
        }
        ResultSet rs = null;
        try {
            this.checkDBConnection();
            rs = this.fetchResult(this.templatePrepStatement, name);
            if (rs.next()) {
                Reader reader = this.getReader(rs, this.templateColumn, encoding);
                if (reader == null) {
                    throw new ResourceNotFoundException("DataSourceResourceLoader: template column for '" + name + "' is null");
                }
                return new SelfCleaningReader(reader, rs);
            }
            throw new ResourceNotFoundException("DataSourceResourceLoader: could not find resource '" + name + "'");
        }
        catch (SQLException | NamingException sqle) {
            String msg = "DataSourceResourceLoader: database problem while getting resource '" + name + "': ";
            this.log.error(msg, sqle);
            throw new ResourceNotFoundException(msg);
        }
    }

    private long readLastModified(Resource resource, String operation) {
        long timeStamp = 0L;
        String name = resource.getName();
        if (name == null || name.length() == 0) {
            String msg = "DataSourceResourceLoader: Template name was empty or null";
            this.log.error(msg);
            throw new NullPointerException(msg);
        }
        ResultSet rs = null;
        try {
            this.checkDBConnection();
            rs = this.fetchResult(this.timestampPrepStatement, name);
            if (!rs.next()) {
                String msg = "DataSourceResourceLoader: could not find resource " + name + " while " + operation;
                this.log.error(msg);
                throw new ResourceNotFoundException(msg);
            }
            Timestamp ts = rs.getTimestamp(this.timestampColumn);
            timeStamp = ts != null ? ts.getTime() : 0L;
            this.closeResultSet(rs);
        }
        catch (SQLException | NamingException sqle) {
            try {
                String msg = "DataSourceResourceLoader: database problem while " + operation + " of '" + name + "': ";
                this.log.error(msg, sqle);
                throw new VelocityException(msg, sqle, this.rsvc.getLogContext().getStackTrace());
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                throw throwable;
            }
        }
        return timeStamp;
    }

    private void openDBConnection() throws NamingException, SQLException {
        if (this.dataSource == null) {
            if (this.ctx == null) {
                this.ctx = new InitialContext();
            }
            this.dataSource = (DataSource)this.ctx.lookup(this.dataSourceName);
        }
        if (this.connection != null) {
            this.closeDBConnection();
        }
        this.connection = this.dataSource.getConnection();
        this.templatePrepStatement = this.prepareStatement(this.connection, this.templateColumn, this.tableName, this.keyColumn);
        this.timestampPrepStatement = this.prepareStatement(this.connection, this.timestampColumn, this.tableName, this.keyColumn);
    }

    private void checkDBConnection() throws NamingException, SQLException {
        if (this.connection == null || !this.connection.isValid(0)) {
            this.openDBConnection();
        }
    }

    protected void finalize() throws Throwable {
        this.closeDBConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeDBConnection() {
        if (this.templatePrepStatement != null) {
            try {
                this.templatePrepStatement.close();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (SQLException re) {
            }
            finally {
                this.templatePrepStatement = null;
            }
        }
        if (this.timestampPrepStatement != null) {
            try {
                this.timestampPrepStatement.close();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (SQLException re) {
            }
            finally {
                this.timestampPrepStatement = null;
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (SQLException sQLException) {
            }
            finally {
                this.connection = null;
            }
        }
    }

    private void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected PreparedStatement prepareStatement(Connection conn, String columnNames, String tableName, String keyColumn) throws SQLException {
        PreparedStatement ps = conn.prepareStatement("SELECT " + columnNames + " FROM " + tableName + " WHERE " + keyColumn + " = ?");
        return ps;
    }

    protected ResultSet fetchResult(PreparedStatement ps, String templateName) throws SQLException {
        ps.setString(1, templateName);
        return ps.executeQuery();
    }

    protected Reader getReader(ResultSet resultSet, String column, String encoding) throws SQLException {
        return resultSet.getCharacterStream(column);
    }

    private static class SelfCleaningReader
    extends FilterReader {
        private ResultSet resultSet;

        public SelfCleaningReader(Reader reader, ResultSet resultSet) {
            super(reader);
            this.resultSet = resultSet;
        }

        @Override
        public void close() throws IOException {
            super.close();
            try {
                this.resultSet.close();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

