/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.elasticsearch.table;

import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Period;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import org.apache.flink.table.api.TableColumn;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.LogicalType;

public class KeyExtractor
implements Function<RowData, String>,
Serializable {
    private final FieldFormatter[] fieldFormatters;
    private final String keyDelimiter;

    private KeyExtractor(FieldFormatter[] fieldFormatters, String keyDelimiter) {
        this.fieldFormatters = fieldFormatters;
        this.keyDelimiter = keyDelimiter;
    }

    @Override
    public String apply(RowData rowData) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.fieldFormatters.length; ++i) {
            if (i > 0) {
                builder.append(this.keyDelimiter);
            }
            String value = this.fieldFormatters[i].format(rowData);
            builder.append(value);
        }
        return builder.toString();
    }

    public static Function<RowData, String> createKeyExtractor(TableSchema schema, String keyDelimiter) {
        return schema.getPrimaryKey().map(key -> {
            HashMap<String, ColumnWithIndex> namesToColumns = new HashMap<String, ColumnWithIndex>();
            List tableColumns = schema.getTableColumns();
            for (int i = 0; i < schema.getFieldCount(); ++i) {
                TableColumn column2 = (TableColumn)tableColumns.get(i);
                namesToColumns.put(column2.getName(), new ColumnWithIndex(column2, i));
            }
            FieldFormatter[] fieldFormatters = (FieldFormatter[])key.getColumns().stream().map(namesToColumns::get).map(column -> KeyExtractor.toFormatter(column.index, column.getType())).toArray(FieldFormatter[]::new);
            return new KeyExtractor(fieldFormatters, keyDelimiter);
        }).orElseGet(() -> (Function<RowData, String> & Serializable)row -> null);
    }

    private static FieldFormatter toFormatter(int index, LogicalType type) {
        switch (type.getTypeRoot()) {
            case DATE: {
                return row -> LocalDate.ofEpochDay(row.getInt(index)).toString();
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return row -> LocalTime.ofNanoOfDay((long)row.getInt(index) * 1000000L).toString();
            }
            case INTERVAL_YEAR_MONTH: {
                return row -> Period.ofDays(row.getInt(index)).toString();
            }
            case INTERVAL_DAY_TIME: {
                return row -> Duration.ofMillis(row.getLong(index)).toString();
            }
            case DISTINCT_TYPE: {
                return KeyExtractor.toFormatter(index, ((DistinctType)type).getSourceType());
            }
        }
        RowData.FieldGetter fieldGetter = RowData.createFieldGetter((LogicalType)type, (int)index);
        return row -> fieldGetter.getFieldOrNull(row).toString();
    }

    private static class ColumnWithIndex {
        public TableColumn column;
        public int index;

        public ColumnWithIndex(TableColumn column, int index) {
            this.column = column;
            this.index = index;
        }

        public LogicalType getType() {
            return this.column.getType().getLogicalType();
        }

        public int getIndex() {
            return this.index;
        }
    }

    private static interface FieldFormatter
    extends Serializable {
        public String format(RowData var1);
    }
}

