/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.elasticsearch.table;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;

public class ElasticsearchValidationUtils {
    private static final Set<LogicalTypeRoot> ILLEGAL_PRIMARY_KEY_TYPES = new LinkedHashSet<LogicalTypeRoot>();

    public static void validatePrimaryKey(TableSchema schema) {
        schema.getPrimaryKey().ifPresent(key -> {
            List illegalTypes = key.getColumns().stream().map(fieldName -> {
                LogicalType logicalType = ((DataType)schema.getFieldDataType(fieldName).get()).getLogicalType();
                if (LogicalTypeChecks.hasRoot((LogicalType)logicalType, (LogicalTypeRoot)LogicalTypeRoot.DISTINCT_TYPE)) {
                    return ((DistinctType)logicalType).getSourceType().getTypeRoot();
                }
                return logicalType.getTypeRoot();
            }).filter(ILLEGAL_PRIMARY_KEY_TYPES::contains).collect(Collectors.toList());
            if (!illegalTypes.isEmpty()) {
                throw new ValidationException(String.format("The table has a primary key on columns of illegal types: %s.\n Elasticsearch sink does not support primary keys on columns of types: %s.", illegalTypes, ILLEGAL_PRIMARY_KEY_TYPES));
            }
        });
    }

    private ElasticsearchValidationUtils() {
    }

    static {
        ILLEGAL_PRIMARY_KEY_TYPES.add(LogicalTypeRoot.ARRAY);
        ILLEGAL_PRIMARY_KEY_TYPES.add(LogicalTypeRoot.MAP);
        ILLEGAL_PRIMARY_KEY_TYPES.add(LogicalTypeRoot.MULTISET);
        ILLEGAL_PRIMARY_KEY_TYPES.add(LogicalTypeRoot.STRUCTURED_TYPE);
        ILLEGAL_PRIMARY_KEY_TYPES.add(LogicalTypeRoot.ROW);
        ILLEGAL_PRIMARY_KEY_TYPES.add(LogicalTypeRoot.RAW);
        ILLEGAL_PRIMARY_KEY_TYPES.add(LogicalTypeRoot.BINARY);
        ILLEGAL_PRIMARY_KEY_TYPES.add(LogicalTypeRoot.VARBINARY);
    }
}

