/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.util;

import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import org.apache.flink.elasticsearch7.shaded.org.apache.commons.lang3.math.NumberUtils;

public class IpPort {
    public static final String SEPARATOR = ":";
    public final String ip;
    public final int port;
    public final String key;
    public final InetSocketAddress addr;

    public IpPort(String ip, int port) {
        this.ip = ip;
        this.port = port;
        this.key = IpPort.getIpPortKey(ip, port);
        this.addr = new InetSocketAddress(ip, port);
    }

    public IpPort(InetSocketAddress addr) {
        this.ip = addr.getHostName();
        this.port = addr.getPort();
        this.key = IpPort.getIpPortKey(this.ip, this.port);
        this.addr = addr;
    }

    public static String getIpPortKey(String ip, int port) {
        return ip + SEPARATOR + port;
    }

    public static IpPort parseIpPort(String ipPort) {
        String[] splits = ipPort.split(SEPARATOR);
        if (splits.length == 2) {
            String strIp = splits[0];
            String strPort = splits[1];
            int port = NumberUtils.toInt(strPort, 0);
            if (port > 0) {
                return new IpPort(strIp, port);
            }
        }
        return null;
    }

    public static InetSocketAddress parseInetSocketAddress(Channel channel) {
        InetSocketAddress destAddr = null;
        if (channel.remoteAddress() instanceof InetSocketAddress) {
            destAddr = (InetSocketAddress)channel.remoteAddress();
        } else {
            String sendIp = channel.remoteAddress().toString();
            destAddr = new InetSocketAddress(sendIp, 0);
        }
        return destAddr;
    }

    public int hashCode() {
        int result = this.ip.hashCode();
        result = 31 * result + this.port;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!(o instanceof IpPort)) {
            return false;
        }
        try {
            IpPort ctp = (IpPort)o;
            if (this.ip != null && this.ip.equals(ctp.port) && this.port == ctp.port) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public String toString() {
        return this.key;
    }
}

