/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.tools;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.apache.commons.lang.StringUtils;
import org.apache.flume.Context;
import org.apache.flume.conf.ConfigurationException;

public class FlumeBeanConfigurator {
    public static void setConfigurationFields(Object configurable, Map<String, String> properties) throws ConfigurationException {
        Class<?> clazz = configurable.getClass();
        for (Method method : clazz.getMethods()) {
            String fieldName;
            String value;
            String methodName = method.getName();
            if (!methodName.startsWith("set") || method.getParameterTypes().length != 1 || (value = properties.get(StringUtils.uncapitalize(fieldName = methodName.substring(3)))) == null) continue;
            Class<?> fieldType = method.getParameterTypes()[0];
            try {
                if (fieldType.equals(String.class)) {
                    method.invoke(configurable, value);
                    continue;
                }
                if (fieldType.equals(Boolean.TYPE)) {
                    method.invoke(configurable, Boolean.parseBoolean(value));
                    continue;
                }
                if (fieldType.equals(Short.TYPE)) {
                    method.invoke(configurable, Short.parseShort(value));
                    continue;
                }
                if (fieldType.equals(Long.TYPE)) {
                    method.invoke(configurable, Long.parseLong(value));
                    continue;
                }
                if (fieldType.equals(Float.TYPE)) {
                    method.invoke(configurable, Float.valueOf(Float.parseFloat(value)));
                    continue;
                }
                if (fieldType.equals(Integer.TYPE)) {
                    method.invoke(configurable, Integer.parseInt(value));
                    continue;
                }
                if (fieldType.equals(Double.TYPE)) {
                    method.invoke(configurable, Double.parseDouble(value));
                    continue;
                }
                if (fieldType.equals(Character.TYPE)) {
                    method.invoke(configurable, Character.valueOf(value.charAt(0)));
                    continue;
                }
                if (fieldType.equals(Byte.TYPE)) {
                    method.invoke(configurable, Byte.parseByte(value));
                    continue;
                }
                if (fieldType.equals(String[].class)) {
                    method.invoke(configurable, new Object[]{value.split("\\s+")});
                    continue;
                }
                throw new ConfigurationException("Unable to configure component due to an unsupported type on field: " + fieldName);
            }
            catch (Exception ex) {
                if (ex instanceof ConfigurationException) {
                    throw (ConfigurationException)ex;
                }
                throw new ConfigurationException("Unable to configure component: ", ex);
            }
        }
    }

    public static void setConfigurationFields(Object configurable, Context context) throws ConfigurationException {
        Class<?> clazz = configurable.getClass();
        ImmutableMap<String, String> properties = context.getSubProperties(clazz.getSimpleName() + ".");
        FlumeBeanConfigurator.setConfigurationFields(configurable, properties);
    }

    public static void setConfigurationFields(Object configurable, Context context, String subPropertiesPrefix) throws ConfigurationException {
        ImmutableMap<String, String> properties = context.getSubProperties(subPropertiesPrefix);
        FlumeBeanConfigurator.setConfigurationFields(configurable, properties);
    }
}

