/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.thrift;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;

public class ThriftFlumeEvent
implements TBase<ThriftFlumeEvent, _Fields>,
Serializable,
Cloneable,
Comparable<ThriftFlumeEvent> {
    private static final TStruct STRUCT_DESC = new TStruct("ThriftFlumeEvent");
    private static final TField HEADERS_FIELD_DESC = new TField("headers", 13, 1);
    private static final TField BODY_FIELD_DESC = new TField("body", 11, 2);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public Map<String, String> headers;
    public ByteBuffer body;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public ThriftFlumeEvent() {
    }

    public ThriftFlumeEvent(Map<String, String> headers, ByteBuffer body) {
        this();
        this.headers = headers;
        this.body = TBaseHelper.copyBinary(body);
    }

    public ThriftFlumeEvent(ThriftFlumeEvent other) {
        if (other.isSetHeaders()) {
            HashMap<String, String> __this__headers = new HashMap<String, String>(other.headers);
            this.headers = __this__headers;
        }
        if (other.isSetBody()) {
            this.body = TBaseHelper.copyBinary(other.body);
        }
    }

    public ThriftFlumeEvent deepCopy() {
        return new ThriftFlumeEvent(this);
    }

    @Override
    public void clear() {
        this.headers = null;
        this.body = null;
    }

    public int getHeadersSize() {
        return this.headers == null ? 0 : this.headers.size();
    }

    public void putToHeaders(String key, String val2) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(key, val2);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public ThriftFlumeEvent setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public void unsetHeaders() {
        this.headers = null;
    }

    public boolean isSetHeaders() {
        return this.headers != null;
    }

    public void setHeadersIsSet(boolean value) {
        if (!value) {
            this.headers = null;
        }
    }

    public byte[] getBody() {
        this.setBody(TBaseHelper.rightSize(this.body));
        return this.body == null ? null : this.body.array();
    }

    public ByteBuffer bufferForBody() {
        return TBaseHelper.copyBinary(this.body);
    }

    public ThriftFlumeEvent setBody(byte[] body) {
        this.body = body == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(body, body.length));
        return this;
    }

    public ThriftFlumeEvent setBody(ByteBuffer body) {
        this.body = TBaseHelper.copyBinary(body);
        return this;
    }

    public void unsetBody() {
        this.body = null;
    }

    public boolean isSetBody() {
        return this.body != null;
    }

    public void setBodyIsSet(boolean value) {
        if (!value) {
            this.body = null;
        }
    }

    @Override
    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case HEADERS: {
                if (value == null) {
                    this.unsetHeaders();
                    break;
                }
                this.setHeaders((Map)value);
                break;
            }
            case BODY: {
                if (value == null) {
                    this.unsetBody();
                    break;
                }
                this.setBody((ByteBuffer)value);
            }
        }
    }

    @Override
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case HEADERS: {
                return this.getHeaders();
            }
            case BODY: {
                return this.getBody();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case HEADERS: {
                return this.isSetHeaders();
            }
            case BODY: {
                return this.isSetBody();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof ThriftFlumeEvent) {
            return this.equals((ThriftFlumeEvent)that);
        }
        return false;
    }

    public boolean equals(ThriftFlumeEvent that) {
        if (that == null) {
            return false;
        }
        boolean this_present_headers = this.isSetHeaders();
        boolean that_present_headers = that.isSetHeaders();
        if (this_present_headers || that_present_headers) {
            if (!this_present_headers || !that_present_headers) {
                return false;
            }
            if (!this.headers.equals(that.headers)) {
                return false;
            }
        }
        boolean this_present_body = this.isSetBody();
        boolean that_present_body = that.isSetBody();
        if (this_present_body || that_present_body) {
            if (!this_present_body || !that_present_body) {
                return false;
            }
            if (!this.body.equals(that.body)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Object> list = new ArrayList<Object>();
        boolean present_headers = this.isSetHeaders();
        list.add(present_headers);
        if (present_headers) {
            list.add(this.headers);
        }
        boolean present_body = this.isSetBody();
        list.add(present_body);
        if (present_body) {
            list.add(this.body);
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(ThriftFlumeEvent other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetHeaders()).compareTo(other.isSetHeaders());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetHeaders() && (lastComparison = TBaseHelper.compareTo(this.headers, other.headers)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetBody()).compareTo(other.isSetBody());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetBody() && (lastComparison = TBaseHelper.compareTo(this.body, other.body)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (ThriftFlumeEvent)this);
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (ThriftFlumeEvent)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ThriftFlumeEvent(");
        boolean first = true;
        sb.append("headers:");
        if (this.headers == null) {
            sb.append("null");
        } else {
            sb.append(this.headers);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("body:");
        if (this.body == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString(this.body, sb);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.headers == null) {
            throw new TProtocolException("Required field 'headers' was not present! Struct: " + this.toString());
        }
        if (this.body == null) {
            throw new TProtocolException("Required field 'body' was not present! Struct: " + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read(new TCompactProtocol(new TIOStreamTransport(in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new ThriftFlumeEventStandardSchemeFactory());
        schemes.put(TupleScheme.class, new ThriftFlumeEventTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.HEADERS, new FieldMetaData("headers", 1, new MapMetaData(13, new FieldValueMetaData(11), new FieldValueMetaData(11))));
        tmpMap.put(_Fields.BODY, new FieldMetaData("body", 1, new FieldValueMetaData(11, true)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(ThriftFlumeEvent.class, metaDataMap);
    }

    private static class ThriftFlumeEventTupleScheme
    extends TupleScheme<ThriftFlumeEvent> {
        private ThriftFlumeEventTupleScheme() {
        }

        @Override
        public void write(TProtocol prot, ThriftFlumeEvent struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI32(struct.headers.size());
            for (Map.Entry<String, String> _iter5 : struct.headers.entrySet()) {
                oprot.writeString(_iter5.getKey());
                oprot.writeString(_iter5.getValue());
            }
            oprot.writeBinary(struct.body);
        }

        @Override
        public void read(TProtocol prot, ThriftFlumeEvent struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            TMap _map6 = new TMap(11, 11, iprot.readI32());
            struct.headers = new HashMap<String, String>(2 * _map6.size);
            for (int _i9 = 0; _i9 < _map6.size; ++_i9) {
                String _key7 = iprot.readString();
                String _val8 = iprot.readString();
                struct.headers.put(_key7, _val8);
            }
            struct.setHeadersIsSet(true);
            struct.body = iprot.readBinary();
            struct.setBodyIsSet(true);
        }
    }

    private static class ThriftFlumeEventTupleSchemeFactory
    implements SchemeFactory {
        private ThriftFlumeEventTupleSchemeFactory() {
        }

        public ThriftFlumeEventTupleScheme getScheme() {
            return new ThriftFlumeEventTupleScheme();
        }
    }

    private static class ThriftFlumeEventStandardScheme
    extends StandardScheme<ThriftFlumeEvent> {
        private ThriftFlumeEventStandardScheme() {
        }

        @Override
        public void read(TProtocol iprot, ThriftFlumeEvent struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 13) {
                            TMap _map0 = iprot.readMapBegin();
                            struct.headers = new HashMap<String, String>(2 * _map0.size);
                            for (int _i3 = 0; _i3 < _map0.size; ++_i3) {
                                String _key1 = iprot.readString();
                                String _val2 = iprot.readString();
                                struct.headers.put(_key1, _val2);
                            }
                            iprot.readMapEnd();
                            struct.setHeadersIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.body = iprot.readBinary();
                            struct.setBodyIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        @Override
        public void write(TProtocol oprot, ThriftFlumeEvent struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.headers != null) {
                oprot.writeFieldBegin(HEADERS_FIELD_DESC);
                oprot.writeMapBegin(new TMap(11, 11, struct.headers.size()));
                for (Map.Entry<String, String> _iter4 : struct.headers.entrySet()) {
                    oprot.writeString(_iter4.getKey());
                    oprot.writeString(_iter4.getValue());
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            if (struct.body != null) {
                oprot.writeFieldBegin(BODY_FIELD_DESC);
                oprot.writeBinary(struct.body);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class ThriftFlumeEventStandardSchemeFactory
    implements SchemeFactory {
        private ThriftFlumeEventStandardSchemeFactory() {
        }

        public ThriftFlumeEventStandardScheme getScheme() {
            return new ThriftFlumeEventStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        HEADERS(1, "headers"),
        BODY(2, "body");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return HEADERS;
                }
                case 2: {
                    return BODY;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

