/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.source;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import org.apache.flume.ChannelException;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.FlumeException;
import org.apache.flume.PollableSource;
import org.apache.flume.conf.BatchSizeSupported;
import org.apache.flume.conf.Configurable;
import org.apache.flume.event.EventBuilder;
import org.apache.flume.instrumentation.SourceCounter;
import org.apache.flume.source.AbstractPollableSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceGeneratorSource
extends AbstractPollableSource
implements Configurable,
BatchSizeSupported {
    private static final Logger logger = LoggerFactory.getLogger(SequenceGeneratorSource.class);
    private int batchSize;
    private SourceCounter sourceCounter;
    private long totalEvents;
    private long eventsSent = 0L;

    @Override
    protected void doConfigure(Context context) throws FlumeException {
        this.batchSize = context.getInteger("batchSize", 1);
        this.totalEvents = context.getLong("totalEvents", Long.MAX_VALUE);
        Preconditions.checkArgument(this.batchSize > 0, "batchSize was %s but expected positive", new Object[]{this.batchSize});
        if (this.sourceCounter == null) {
            this.sourceCounter = new SourceCounter(this.getName());
        }
    }

    @Override
    protected PollableSource.Status doProcess() throws EventDeliveryException {
        PollableSource.Status status = PollableSource.Status.READY;
        long eventsSentTX = this.eventsSent;
        try {
            if (this.batchSize == 1) {
                if (eventsSentTX < this.totalEvents) {
                    this.getChannelProcessor().processEvent(EventBuilder.withBody(String.valueOf(eventsSentTX++).getBytes()));
                    this.sourceCounter.incrementEventAcceptedCount();
                } else {
                    status = PollableSource.Status.BACKOFF;
                }
            } else {
                ArrayList<Event> batchArrayList = new ArrayList<Event>(this.batchSize);
                for (int i = 0; i < this.batchSize; ++i) {
                    if (eventsSentTX >= this.totalEvents) {
                        status = PollableSource.Status.BACKOFF;
                        break;
                    }
                    batchArrayList.add(i, EventBuilder.withBody(String.valueOf(eventsSentTX++).getBytes()));
                }
                if (!batchArrayList.isEmpty()) {
                    this.getChannelProcessor().processEventBatch(batchArrayList);
                    this.sourceCounter.incrementAppendBatchAcceptedCount();
                    this.sourceCounter.addToEventAcceptedCount(batchArrayList.size());
                }
            }
            this.eventsSent = eventsSentTX;
        }
        catch (ChannelException ex) {
            logger.error(this.getName() + " source could not write to channel.", ex);
            this.sourceCounter.incrementChannelWriteFail();
        }
        return status;
    }

    @Override
    protected void doStart() throws FlumeException {
        logger.info("Sequence generator source do starting");
        this.sourceCounter.start();
        logger.debug("Sequence generator source do started");
    }

    @Override
    protected void doStop() throws FlumeException {
        logger.info("Sequence generator source do stopping");
        this.sourceCounter.stop();
        logger.info("Sequence generator source do stopped. Metrics:{}", (Object)this.getName(), (Object)this.sourceCounter);
    }

    @Override
    public long getBatchSize() {
        return this.batchSize;
    }
}

