/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.source;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayOutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.flume.ChannelException;
import org.apache.flume.Context;
import org.apache.flume.CounterGroup;
import org.apache.flume.Event;
import org.apache.flume.EventDrivenSource;
import org.apache.flume.conf.Configurable;
import org.apache.flume.conf.Configurables;
import org.apache.flume.event.EventBuilder;
import org.apache.flume.source.AbstractSource;
import org.jboss.netty.bootstrap.ConnectionlessBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.AdaptiveReceiveBufferSizePredictorFactory;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.socket.oio.OioDatagramChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetcatUdpSource
extends AbstractSource
implements EventDrivenSource,
Configurable {
    private int port;
    private int maxsize = 65536;
    private String host = null;
    private Channel nettyChannel;
    private String remoteHostHeader = "REMOTE_ADDRESS";
    private static final Logger logger = LoggerFactory.getLogger(NetcatUdpSource.class);
    private CounterGroup counterGroup = new CounterGroup();
    private static final int DEFAULT_MIN_SIZE = 2048;
    private static final int DEFAULT_INITIAL_SIZE = 2048;
    private static final String REMOTE_ADDRESS_HEADER = "remoteAddress";
    private static final String CONFIG_PORT = "port";
    private static final String CONFIG_HOST = "bind";

    @Override
    public void start() {
        ConnectionlessBootstrap serverBootstrap = new ConnectionlessBootstrap(new OioDatagramChannelFactory(Executors.newCachedThreadPool()));
        final NetcatHandler handler = new NetcatHandler();
        serverBootstrap.setOption("receiveBufferSizePredictorFactory", new AdaptiveReceiveBufferSizePredictorFactory(2048, 2048, this.maxsize));
        serverBootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            @Override
            public ChannelPipeline getPipeline() {
                return Channels.pipeline(handler);
            }
        });
        this.nettyChannel = this.host == null ? serverBootstrap.bind(new InetSocketAddress(this.port)) : serverBootstrap.bind(new InetSocketAddress(this.host, this.port));
        super.start();
    }

    @Override
    public void stop() {
        logger.info("Netcat UDP Source stopping...");
        logger.info("Metrics:{}", (Object)this.counterGroup);
        if (this.nettyChannel != null) {
            this.nettyChannel.close();
            try {
                this.nettyChannel.getCloseFuture().await(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                logger.warn("netty server stop interrupted", e);
            }
            finally {
                this.nettyChannel = null;
            }
        }
        super.stop();
    }

    @Override
    public void configure(Context context) {
        Configurables.ensureRequiredNonNull(context, CONFIG_PORT);
        this.port = context.getInteger(CONFIG_PORT);
        this.host = context.getString(CONFIG_HOST);
        this.remoteHostHeader = context.getString(REMOTE_ADDRESS_HEADER);
    }

    @VisibleForTesting
    public int getSourcePort() {
        SocketAddress localAddress = this.nettyChannel.getLocalAddress();
        if (localAddress instanceof InetSocketAddress) {
            InetSocketAddress addr = (InetSocketAddress)localAddress;
            return addr.getPort();
        }
        return 0;
    }

    public class NetcatHandler
    extends SimpleChannelHandler {
        private Event extractEvent(ChannelBuffer in, SocketAddress remoteAddress) {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put(NetcatUdpSource.this.remoteHostHeader, remoteAddress.toString());
            byte b = 0;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Event e = null;
            boolean doneReading = false;
            while (!doneReading && in.readable()) {
                b = in.readByte();
                if (b == 10) {
                    doneReading = true;
                    continue;
                }
                baos.write(b);
            }
            e = EventBuilder.withBody(baos.toByteArray(), headers);
            return e;
        }

        @Override
        public void messageReceived(ChannelHandlerContext ctx, MessageEvent mEvent) {
            try {
                Event e = this.extractEvent((ChannelBuffer)mEvent.getMessage(), mEvent.getRemoteAddress());
                if (e == null) {
                    return;
                }
                NetcatUdpSource.this.getChannelProcessor().processEvent(e);
                NetcatUdpSource.this.counterGroup.incrementAndGet("events.success");
            }
            catch (ChannelException ex) {
                NetcatUdpSource.this.counterGroup.incrementAndGet("events.dropped");
                logger.error("Error writing to channel", ex);
            }
            catch (RuntimeException ex) {
                NetcatUdpSource.this.counterGroup.incrementAndGet("events.dropped");
                logger.error("Error retrieving event from udp stream, event dropped", ex);
            }
        }
    }
}

