/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.hdfs;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.serialization.EventSerializer;
import org.apache.flume.serialization.EventSerializerFactory;
import org.apache.flume.sink.hdfs.AbstractHDFSWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HDFSDataStream
extends AbstractHDFSWriter {
    private static final Logger logger = LoggerFactory.getLogger(HDFSDataStream.class);
    private FSDataOutputStream outStream;
    private String serializerType;
    private Context serializerContext;
    private EventSerializer serializer;
    private boolean useRawLocalFileSystem;

    @Override
    public void configure(Context context) {
        super.configure(context);
        this.serializerType = context.getString("serializer", "TEXT");
        this.useRawLocalFileSystem = context.getBoolean("hdfs.useRawLocalFileSystem", false);
        this.serializerContext = new Context(context.getSubProperties("serializer."));
        logger.info("Serializer = " + this.serializerType + ", UseRawLocalFileSystem = " + this.useRawLocalFileSystem);
    }

    @VisibleForTesting
    protected FileSystem getDfs(Configuration conf, Path dstPath) throws IOException {
        return dstPath.getFileSystem(conf);
    }

    protected void doOpen(Configuration conf, Path dstPath, FileSystem hdfs) throws IOException {
        if (this.useRawLocalFileSystem) {
            if (hdfs instanceof LocalFileSystem) {
                hdfs = ((LocalFileSystem)hdfs).getRaw();
            } else {
                logger.warn("useRawLocalFileSystem is set to true but file system is not of type LocalFileSystem: " + hdfs.getClass().getName());
            }
        }
        boolean appending = false;
        if (conf.getBoolean("hdfs.append.support", false) && hdfs.isFile(dstPath)) {
            this.outStream = hdfs.append(dstPath);
            appending = true;
        } else {
            this.outStream = hdfs.create(dstPath);
        }
        this.serializer = EventSerializerFactory.getInstance(this.serializerType, this.serializerContext, (OutputStream)this.outStream);
        if (appending && !this.serializer.supportsReopen()) {
            this.outStream.close();
            this.serializer = null;
            throw new IOException("serializer (" + this.serializerType + ") does not support append");
        }
        this.registerCurrentStream(this.outStream, hdfs, dstPath);
        if (appending) {
            this.serializer.afterReopen();
        } else {
            this.serializer.afterCreate();
        }
    }

    @Override
    public void open(String filePath) throws IOException {
        Configuration conf = new Configuration();
        Path dstPath = new Path(filePath);
        FileSystem hdfs = this.getDfs(conf, dstPath);
        this.doOpen(conf, dstPath, hdfs);
    }

    @Override
    public void open(String filePath, CompressionCodec codec, SequenceFile.CompressionType cType) throws IOException {
        this.open(filePath);
    }

    @Override
    public void append(Event e) throws IOException {
        this.serializer.write(e);
    }

    @Override
    public void sync() throws IOException {
        this.serializer.flush();
        this.outStream.flush();
        this.hflushOrSync(this.outStream);
    }

    @Override
    public void close() throws IOException {
        this.serializer.flush();
        this.serializer.beforeClose();
        this.outStream.flush();
        this.hflushOrSync(this.outStream);
        this.outStream.close();
        this.unregisterCurrentStream();
    }
}

