/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.serialization;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.flume.annotations.InterfaceAudience;
import org.apache.flume.annotations.InterfaceStability;
import org.apache.flume.serialization.PositionTracker;
import org.apache.flume.serialization.TransferStateFileMeta;
import org.apache.flume.tools.PlatformDetect;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DurablePositionTracker
implements PositionTracker {
    private final File trackerFile;
    private final DataFileWriter<TransferStateFileMeta> writer;
    private final DataFileReader<TransferStateFileMeta> reader;
    private final TransferStateFileMeta metaCache;
    private String target;
    private boolean isOpen;

    public static DurablePositionTracker getInstance(File trackerFile, String target) throws IOException {
        if (!trackerFile.exists()) {
            return new DurablePositionTracker(trackerFile, target);
        }
        DurablePositionTracker oldTracker = new DurablePositionTracker(trackerFile, target);
        String existingTarget = oldTracker.getTarget();
        long targetPosition = oldTracker.getPosition();
        oldTracker.close();
        File tmpMeta = File.createTempFile(trackerFile.getName(), ".tmp", trackerFile.getParentFile());
        tmpMeta.delete();
        DurablePositionTracker tmpTracker = new DurablePositionTracker(tmpMeta, existingTarget);
        tmpTracker.storePosition(targetPosition);
        tmpTracker.close();
        if (PlatformDetect.isWindows() && !trackerFile.delete()) {
            throw new IOException("Unable to delete existing meta file " + trackerFile);
        }
        if (!tmpMeta.renameTo(trackerFile)) {
            throw new IOException("Unable to rename " + tmpMeta + " to " + trackerFile);
        }
        DurablePositionTracker newTracker = new DurablePositionTracker(trackerFile, existingTarget);
        return newTracker;
    }

    DurablePositionTracker(File trackerFile, String target) throws IOException {
        Preconditions.checkNotNull(trackerFile, "trackerFile must not be null");
        Preconditions.checkNotNull(target, "target must not be null");
        this.trackerFile = trackerFile;
        this.target = target;
        SpecificDatumWriter dout = new SpecificDatumWriter(TransferStateFileMeta.SCHEMA$);
        SpecificDatumReader din = new SpecificDatumReader(TransferStateFileMeta.SCHEMA$);
        this.writer = new DataFileWriter(dout);
        if (trackerFile.exists()) {
            this.writer.appendTo(trackerFile);
            this.reader = new DataFileReader(trackerFile, din);
            this.target = this.reader.getMetaString("file");
        } else {
            this.target = target;
            this.writer.setMeta("file", target);
            this.writer.create(TransferStateFileMeta.SCHEMA$, trackerFile);
            this.reader = new DataFileReader(trackerFile, din);
        }
        target = this.getTarget();
        this.metaCache = TransferStateFileMeta.newBuilder().setOffset(0L).build();
        this.initReader();
        this.isOpen = true;
    }

    private void initReader() throws IOException {
        long syncPos = this.trackerFile.length() - 256L;
        if (syncPos < 0L) {
            syncPos = 0L;
        }
        this.reader.sync(syncPos);
        while (this.reader.hasNext()) {
            this.reader.next(this.metaCache);
        }
    }

    @Override
    public synchronized void storePosition(long position) throws IOException {
        this.metaCache.setOffset(position);
        this.writer.append(this.metaCache);
        this.writer.sync();
        this.writer.flush();
    }

    @Override
    public synchronized long getPosition() {
        return this.metaCache.getOffset();
    }

    @Override
    public String getTarget() {
        return this.target;
    }

    @Override
    public void close() throws IOException {
        if (this.isOpen) {
            this.writer.close();
            this.reader.close();
            this.isOpen = false;
        }
    }
}

