/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.node;

import com.google.common.eventbus.EventBus;
import java.io.IOException;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.apache.curator.framework.recipes.cache.NodeCacheListener;
import org.apache.flume.FlumeException;
import org.apache.flume.conf.FlumeConfiguration;
import org.apache.flume.lifecycle.LifecycleAware;
import org.apache.flume.lifecycle.LifecycleState;
import org.apache.flume.node.AbstractZooKeeperConfigurationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollingZooKeeperConfigurationProvider
extends AbstractZooKeeperConfigurationProvider
implements LifecycleAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(PollingZooKeeperConfigurationProvider.class);
    private final EventBus eventBus;
    private final CuratorFramework client;
    private NodeCache agentNodeCache;
    private FlumeConfiguration flumeConfiguration;
    private LifecycleState lifecycleState;

    public PollingZooKeeperConfigurationProvider(String agentName, String zkConnString, String basePath, EventBus eventBus) {
        super(agentName, zkConnString, basePath);
        this.eventBus = eventBus;
        this.client = this.createClient();
        this.agentNodeCache = null;
        this.flumeConfiguration = null;
        this.lifecycleState = LifecycleState.IDLE;
    }

    @Override
    protected FlumeConfiguration getFlumeConfiguration() {
        return this.flumeConfiguration;
    }

    @Override
    public void start() {
        LOGGER.debug("Starting...");
        try {
            this.client.start();
            try {
                this.agentNodeCache = new NodeCache(this.client, this.basePath + "/" + this.getAgentName());
                this.agentNodeCache.start();
                this.agentNodeCache.getListenable().addListener(new NodeCacheListener(){

                    @Override
                    public void nodeChanged() throws Exception {
                        PollingZooKeeperConfigurationProvider.this.refreshConfiguration();
                    }
                });
            }
            catch (Exception e) {
                this.client.close();
                throw e;
            }
        }
        catch (Exception e) {
            this.lifecycleState = LifecycleState.ERROR;
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new FlumeException(e);
        }
        this.lifecycleState = LifecycleState.START;
    }

    private void refreshConfiguration() throws IOException {
        LOGGER.info("Refreshing configuration from ZooKeeper");
        byte[] data = null;
        ChildData childData = this.agentNodeCache.getCurrentData();
        if (childData != null) {
            data = childData.getData();
        }
        this.flumeConfiguration = this.configFromBytes(data);
        this.eventBus.post(this.getConfiguration());
    }

    @Override
    public void stop() {
        LOGGER.debug("Stopping...");
        if (this.agentNodeCache != null) {
            try {
                this.agentNodeCache.close();
            }
            catch (IOException e) {
                LOGGER.warn("Encountered exception while stopping", e);
                this.lifecycleState = LifecycleState.ERROR;
            }
        }
        try {
            this.client.close();
        }
        catch (Exception e) {
            LOGGER.warn("Error stopping Curator client", e);
            this.lifecycleState = LifecycleState.ERROR;
        }
        if (this.lifecycleState != LifecycleState.ERROR) {
            this.lifecycleState = LifecycleState.STOP;
        }
    }

    @Override
    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }
}

