/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.node;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.flink.elasticsearch7.shaded.org.apache.commons.cli.CommandLine;
import org.apache.flink.elasticsearch7.shaded.org.apache.commons.cli.GnuParser;
import org.apache.flink.elasticsearch7.shaded.org.apache.commons.cli.HelpFormatter;
import org.apache.flink.elasticsearch7.shaded.org.apache.commons.cli.Option;
import org.apache.flink.elasticsearch7.shaded.org.apache.commons.cli.Options;
import org.apache.flink.elasticsearch7.shaded.org.apache.commons.cli.ParseException;
import org.apache.flume.Channel;
import org.apache.flume.Context;
import org.apache.flume.instrumentation.MonitorService;
import org.apache.flume.instrumentation.MonitoringType;
import org.apache.flume.lifecycle.LifecycleAware;
import org.apache.flume.lifecycle.LifecycleState;
import org.apache.flume.lifecycle.LifecycleSupervisor;
import org.apache.flume.node.MaterializedConfiguration;
import org.apache.flume.node.PollingPropertiesFileConfigurationProvider;
import org.apache.flume.node.PollingZooKeeperConfigurationProvider;
import org.apache.flume.node.PropertiesFileConfigurationProvider;
import org.apache.flume.node.StaticZooKeeperConfigurationProvider;
import org.apache.flume.util.SSLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Application {
    private static final Logger logger = LoggerFactory.getLogger(Application.class);
    public static final String CONF_MONITOR_CLASS = "flume.monitoring.type";
    public static final String CONF_MONITOR_PREFIX = "flume.monitoring.";
    private final List<LifecycleAware> components;
    private final LifecycleSupervisor supervisor;
    private MaterializedConfiguration materializedConfiguration;
    private MonitorService monitorServer;
    private final ReentrantLock lifecycleLock = new ReentrantLock();

    public Application() {
        this(new ArrayList<LifecycleAware>(0));
    }

    public Application(List<LifecycleAware> components) {
        this.components = components;
        this.supervisor = new LifecycleSupervisor();
    }

    public void start() {
        this.lifecycleLock.lock();
        try {
            for (LifecycleAware component : this.components) {
                this.supervisor.supervise(component, new LifecycleSupervisor.SupervisorPolicy.AlwaysRestartPolicy(), LifecycleState.START);
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    @Subscribe
    public void handleConfigurationEvent(MaterializedConfiguration conf) {
        try {
            this.lifecycleLock.lockInterruptibly();
            this.stopAllComponents();
            this.startAllComponents(conf);
        }
        catch (InterruptedException e) {
            logger.info("Interrupted while trying to handle configuration event");
            return;
        }
        finally {
            if (this.lifecycleLock.isHeldByCurrentThread()) {
                this.lifecycleLock.unlock();
            }
        }
    }

    public void stop() {
        this.lifecycleLock.lock();
        this.stopAllComponents();
        try {
            this.supervisor.stop();
            if (this.monitorServer != null) {
                this.monitorServer.stop();
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    private void stopAllComponents() {
        if (this.materializedConfiguration != null) {
            logger.info("Shutting down configuration: {}", (Object)this.materializedConfiguration);
            for (Map.Entry entry : this.materializedConfiguration.getSourceRunners().entrySet()) {
                try {
                    logger.info("Stopping Source " + (String)entry.getKey());
                    this.supervisor.unsupervise((LifecycleAware)entry.getValue());
                }
                catch (Exception e) {
                    logger.error("Error while stopping {}", entry.getValue(), (Object)e);
                }
            }
            for (Map.Entry entry : this.materializedConfiguration.getSinkRunners().entrySet()) {
                try {
                    logger.info("Stopping Sink " + (String)entry.getKey());
                    this.supervisor.unsupervise((LifecycleAware)entry.getValue());
                }
                catch (Exception e) {
                    logger.error("Error while stopping {}", entry.getValue(), (Object)e);
                }
            }
            for (Map.Entry entry : this.materializedConfiguration.getChannels().entrySet()) {
                try {
                    logger.info("Stopping Channel " + (String)entry.getKey());
                    this.supervisor.unsupervise((LifecycleAware)entry.getValue());
                }
                catch (Exception e) {
                    logger.error("Error while stopping {}", entry.getValue(), (Object)e);
                }
            }
        }
        if (this.monitorServer != null) {
            this.monitorServer.stop();
        }
    }

    private void startAllComponents(MaterializedConfiguration materializedConfiguration) {
        logger.info("Starting new configuration:{}", (Object)materializedConfiguration);
        this.materializedConfiguration = materializedConfiguration;
        for (Map.Entry entry : materializedConfiguration.getChannels().entrySet()) {
            try {
                logger.info("Starting Channel " + (String)entry.getKey());
                this.supervisor.supervise((LifecycleAware)entry.getValue(), new LifecycleSupervisor.SupervisorPolicy.AlwaysRestartPolicy(), LifecycleState.START);
            }
            catch (Exception e) {
                logger.error("Error while starting {}", entry.getValue(), (Object)e);
            }
        }
        for (Channel ch : materializedConfiguration.getChannels().values()) {
            while (ch.getLifecycleState() != LifecycleState.START && !this.supervisor.isComponentInErrorState(ch)) {
                try {
                    logger.info("Waiting for channel: " + ch.getName() + " to start. Sleeping for 500 ms");
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    logger.error("Interrupted while waiting for channel to start.", e);
                    Throwables.propagate(e);
                }
            }
        }
        for (Map.Entry entry : materializedConfiguration.getSinkRunners().entrySet()) {
            try {
                logger.info("Starting Sink " + (String)entry.getKey());
                this.supervisor.supervise((LifecycleAware)entry.getValue(), new LifecycleSupervisor.SupervisorPolicy.AlwaysRestartPolicy(), LifecycleState.START);
            }
            catch (Exception e) {
                logger.error("Error while starting {}", entry.getValue(), (Object)e);
            }
        }
        for (Map.Entry entry : materializedConfiguration.getSourceRunners().entrySet()) {
            try {
                logger.info("Starting Source " + (String)entry.getKey());
                this.supervisor.supervise((LifecycleAware)entry.getValue(), new LifecycleSupervisor.SupervisorPolicy.AlwaysRestartPolicy(), LifecycleState.START);
            }
            catch (Exception e) {
                logger.error("Error while starting {}", entry.getValue(), (Object)e);
            }
        }
        this.loadMonitoring();
    }

    private void loadMonitoring() {
        block5: {
            Properties systemProps = System.getProperties();
            Set<String> keys = systemProps.stringPropertyNames();
            try {
                Class<Object> klass;
                if (!keys.contains(CONF_MONITOR_CLASS)) break block5;
                String monitorType = systemProps.getProperty(CONF_MONITOR_CLASS);
                try {
                    klass = MonitoringType.valueOf(monitorType.toUpperCase(Locale.ENGLISH)).getMonitorClass();
                }
                catch (Exception e) {
                    klass = Class.forName(monitorType);
                }
                this.monitorServer = (MonitorService)klass.newInstance();
                Context context = new Context();
                for (String key : keys) {
                    if (!key.startsWith(CONF_MONITOR_PREFIX)) continue;
                    context.put(key.substring(CONF_MONITOR_PREFIX.length()), systemProps.getProperty(key));
                }
                this.monitorServer.configure(context);
                this.monitorServer.start();
            }
            catch (Exception e) {
                logger.warn("Error starting monitoring. Monitoring might not be available.", e);
            }
        }
    }

    public static void main(String[] args) {
        try {
            Application application;
            SSLUtil.initGlobalSSLParameters();
            Options options = new Options();
            Option option = new Option("n", "name", true, "the name of this agent");
            option.setRequired(true);
            options.addOption(option);
            option = new Option("f", "conf-file", true, "specify a config file (required if -z missing)");
            option.setRequired(false);
            options.addOption(option);
            option = new Option(null, "no-reload-conf", false, "do not reload config file if changed");
            options.addOption(option);
            option = new Option("z", "zkConnString", true, "specify the ZooKeeper connection to use (required if -f missing)");
            option.setRequired(false);
            options.addOption(option);
            option = new Option("p", "zkBasePath", true, "specify the base path in ZooKeeper for agent configs");
            option.setRequired(false);
            options.addOption(option);
            option = new Option("h", "help", false, "display help text");
            options.addOption(option);
            GnuParser parser = new GnuParser();
            CommandLine commandLine = parser.parse(options, args);
            if (commandLine.hasOption('h')) {
                new HelpFormatter().printHelp("flume-ng agent", options, true);
                return;
            }
            String agentName = commandLine.getOptionValue('n');
            boolean reload = !commandLine.hasOption("no-reload-conf");
            boolean isZkConfigured = false;
            if (commandLine.hasOption('z') || commandLine.hasOption("zkConnString")) {
                isZkConfigured = true;
            }
            if (isZkConfigured) {
                String zkConnectionStr = commandLine.getOptionValue('z');
                String baseZkPath = commandLine.getOptionValue('p');
                if (reload) {
                    EventBus eventBus = new EventBus(agentName + "-event-bus");
                    ArrayList<LifecycleAware> components = Lists.newArrayList();
                    PollingZooKeeperConfigurationProvider zookeeperConfigurationProvider = new PollingZooKeeperConfigurationProvider(agentName, zkConnectionStr, baseZkPath, eventBus);
                    components.add(zookeeperConfigurationProvider);
                    application = new Application(components);
                    eventBus.register(application);
                } else {
                    StaticZooKeeperConfigurationProvider zookeeperConfigurationProvider = new StaticZooKeeperConfigurationProvider(agentName, zkConnectionStr, baseZkPath);
                    application = new Application();
                    application.handleConfigurationEvent(zookeeperConfigurationProvider.getConfiguration());
                }
            } else {
                File configurationFile = new File(commandLine.getOptionValue('f'));
                if (!configurationFile.exists() && System.getProperty("flume.called.from.service") == null) {
                    String path = configurationFile.getPath();
                    try {
                        path = configurationFile.getCanonicalPath();
                    }
                    catch (IOException ex) {
                        logger.error("Failed to read canonical path for file: " + path, ex);
                    }
                    throw new ParseException("The specified configuration file does not exist: " + path);
                }
                ArrayList<LifecycleAware> components = Lists.newArrayList();
                if (reload) {
                    EventBus eventBus = new EventBus(agentName + "-event-bus");
                    PollingPropertiesFileConfigurationProvider configurationProvider = new PollingPropertiesFileConfigurationProvider(agentName, configurationFile, eventBus, 30);
                    components.add(configurationProvider);
                    application = new Application(components);
                    eventBus.register(application);
                } else {
                    PropertiesFileConfigurationProvider configurationProvider = new PropertiesFileConfigurationProvider(agentName, configurationFile);
                    application = new Application();
                    application.handleConfigurationEvent(configurationProvider.getConfiguration());
                }
            }
            application.start();
            final Application appReference = application;
            Runtime.getRuntime().addShutdownHook(new Thread("agent-shutdown-hook"){

                @Override
                public void run() {
                    appReference.stop();
                }
            });
        }
        catch (Exception e) {
            logger.error("A fatal error occurred while running. Exception follows.", e);
        }
    }
}

