/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.interceptor;

import java.util.List;
import java.util.Map;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.interceptor.Interceptor;

public class TimestampInterceptor
implements Interceptor {
    private final boolean preserveExisting;
    private final String header;

    private TimestampInterceptor(boolean preserveExisting, String header) {
        this.preserveExisting = preserveExisting;
        this.header = header;
    }

    @Override
    public void initialize() {
    }

    @Override
    public Event intercept(Event event) {
        Map<String, String> headers = event.getHeaders();
        if (!this.preserveExisting || !headers.containsKey(this.header)) {
            long now = System.currentTimeMillis();
            headers.put(this.header, Long.toString(now));
        }
        return event;
    }

    @Override
    public List<Event> intercept(List<Event> events) {
        for (Event event : events) {
            this.intercept(event);
        }
        return events;
    }

    @Override
    public void close() {
    }

    public static class Constants {
        public static final String CONFIG_PRESERVE = "preserveExisting";
        public static final boolean DEFAULT_PRESERVE = false;
        public static final String CONFIG_HEADER_NAME = "headerName";
        public static final String DEFAULT_HEADER_NAME = "timestamp";
    }

    public static class Builder
    implements Interceptor.Builder {
        private boolean preserveExisting = false;
        private String header = "timestamp";

        @Override
        public Interceptor build() {
            return new TimestampInterceptor(this.preserveExisting, this.header);
        }

        @Override
        public void configure(Context context) {
            this.preserveExisting = context.getBoolean("preserveExisting", false);
            this.header = context.getString("headerName", "timestamp");
        }
    }
}

