/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.jdbc;

import org.apache.flume.ChannelException;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.Transaction;
import org.apache.flume.annotations.Disposable;
import org.apache.flume.annotations.InterfaceAudience;
import org.apache.flume.annotations.InterfaceStability;
import org.apache.flume.channel.AbstractChannel;
import org.apache.flume.channel.jdbc.JdbcChannelProvider;
import org.apache.flume.channel.jdbc.JdbcChannelProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Disposable
@InterfaceAudience.Private
@InterfaceStability.Stable
public class JdbcChannel
extends AbstractChannel {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcChannel.class);
    private JdbcChannelProvider provider;

    @Override
    public void put(Event event) throws ChannelException {
        this.getProvider().persistEvent(this.getName(), event);
    }

    @Override
    public Event take() throws ChannelException {
        return this.getProvider().removeEvent(this.getName());
    }

    @Override
    public Transaction getTransaction() {
        return this.getProvider().getTransaction();
    }

    @Override
    public void stop() {
        JdbcChannelProviderFactory.releaseProvider(this.getName());
        this.provider = null;
        super.stop();
    }

    private JdbcChannelProvider getProvider() {
        return this.provider;
    }

    @Override
    public void configure(Context context) {
        this.provider = JdbcChannelProviderFactory.getProvider(context, this.getName());
        LOG.info("JDBC Channel initialized: " + this.getName());
    }
}

