/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.file;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.flume.channel.file.TransactionEventRecord;
import org.apache.flume.channel.file.proto.ProtosFactory;

class Take
extends TransactionEventRecord {
    private int offset;
    private int fileID;

    Take(Long transactionID, Long logWriteOrderID) {
        super(transactionID, logWriteOrderID);
    }

    Take(Long transactionID, Long logWriteOrderID, int offset, int fileID) {
        this(transactionID, logWriteOrderID);
        this.offset = offset;
        this.fileID = fileID;
    }

    int getOffset() {
        return this.offset;
    }

    int getFileID() {
        return this.fileID;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.offset = in.readInt();
        this.fileID = in.readInt();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.offset);
        out.writeInt(this.fileID);
    }

    @Override
    void writeProtos(OutputStream out) throws IOException {
        ProtosFactory.Take.Builder takeBuilder = ProtosFactory.Take.newBuilder();
        takeBuilder.setFileID(this.fileID);
        takeBuilder.setOffset(this.offset);
        takeBuilder.build().writeDelimitedTo(out);
    }

    @Override
    void readProtos(InputStream in) throws IOException {
        ProtosFactory.Take take = Preconditions.checkNotNull(ProtosFactory.Take.parseDelimitedFrom(in), "Take cannot be null");
        this.fileID = take.getFileID();
        this.offset = take.getOffset();
    }

    @Override
    short getRecordType() {
        return TransactionEventRecord.Type.TAKE.get();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Take [offset=");
        builder.append(this.offset);
        builder.append(", fileID=");
        builder.append(this.fileID);
        builder.append(", getLogWriteOrderID()=");
        builder.append(this.getLogWriteOrderID());
        builder.append(", getTransactionID()=");
        builder.append(this.getTransactionID());
        builder.append("]");
        return builder.toString();
    }
}

