/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.file;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.apache.commons.io.FileUtils;
import org.apache.flume.annotations.InterfaceAudience;
import org.apache.flume.annotations.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xerial.snappy.SnappyInputStream;
import org.xerial.snappy.SnappyOutputStream;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class Serialization {
    static final long SIZE_OF_INT = 4L;
    static final int SIZE_OF_LONG = 8;
    static final int VERSION_2 = 2;
    static final int VERSION_3 = 3;
    public static final String METADATA_FILENAME = ".meta";
    public static final String METADATA_TMP_FILENAME = ".tmp";
    public static final String OLD_METADATA_FILENAME = ".meta.old";
    private static final int FILE_BUFFER_SIZE = 65536;
    public static final Logger LOG = LoggerFactory.getLogger(Serialization.class);

    private Serialization() {
    }

    static File getMetaDataTempFile(File metaDataFile) {
        String metaDataFileName = metaDataFile.getName() + METADATA_TMP_FILENAME;
        return new File(metaDataFile.getParentFile(), metaDataFileName);
    }

    static File getMetaDataFile(File file) {
        String metaDataFileName = file.getName() + METADATA_FILENAME;
        return new File(file.getParentFile(), metaDataFileName);
    }

    static File getOldMetaDataFile(File file) {
        String oldMetaDataFileName = file.getName() + OLD_METADATA_FILENAME;
        return new File(file.getParentFile(), oldMetaDataFileName);
    }

    static boolean deleteAllFiles(File checkpointDir, @Nullable Set<String> excludes) {
        if (!checkpointDir.isDirectory()) {
            return false;
        }
        File[] files = checkpointDir.listFiles();
        if (files == null) {
            return false;
        }
        if (files.length == 0) {
            return true;
        }
        StringBuilder builder = new StringBuilder("Deleted the following files: ");
        if (excludes == null) {
            excludes = Collections.emptySet();
        }
        for (File file : files) {
            if (excludes.contains(file.getName())) {
                LOG.info("Skipping " + file.getName() + " because it is in excludes set");
                continue;
            }
            if (!FileUtils.deleteQuietly(file)) {
                LOG.info(builder.toString());
                LOG.error("Error while attempting to delete: " + file.getAbsolutePath());
                return false;
            }
            builder.append(", ").append(file.getName());
        }
        builder.append(".");
        LOG.info(builder.toString());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File from, File to) throws IOException {
        Preconditions.checkNotNull(from, "Source file is null, file copy failed.");
        Preconditions.checkNotNull(to, "Destination file is null, file copy failed.");
        Preconditions.checkState(from.exists(), "Source file: " + from.toString() + " does not exist.");
        Preconditions.checkState(!to.exists(), "Destination file: " + to.toString() + " unexpectedly exists.");
        BufferedInputStream in = null;
        RandomAccessFile out = null;
        try {
            int read;
            in = new BufferedInputStream(new FileInputStream(from));
            out = new RandomAccessFile(to, "rw");
            byte[] buf = new byte[65536];
            int total = 0;
            while ((read = in.read(buf)) != -1) {
                out.write(buf, 0, read);
                total += read;
            }
            out.getFD().sync();
            Preconditions.checkState((long)total == from.length(), "The size of the origin file and destination file are not equal.");
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            LOG.error("Error while attempting to copy " + from.toString() + " to " + to.toString() + ".", ex);
            Throwables.propagate(ex);
        }
        finally {
            Throwable th = null;
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Throwable ex) {
                LOG.error("Error while closing input file.", ex);
                th = ex;
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {
                LOG.error("Error while closing output file.", ex);
                Throwables.propagate(ex);
            }
            if (th != null) {
                Throwables.propagate(th);
            }
        }
        throw new IOException("Copying file: " + from.toString() + " to: " + to.toString() + " may have failed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compressFile(File uncompressed, File compressed) throws IOException {
        Preconditions.checkNotNull(uncompressed, "Source file is null, compression failed.");
        Preconditions.checkNotNull(compressed, "Destination file is null, compression failed.");
        Preconditions.checkState(uncompressed.exists(), "Source file: " + uncompressed.toString() + " does not exist.");
        Preconditions.checkState(!compressed.exists(), "Compressed file: " + compressed.toString() + " unexpectedly exists.");
        BufferedInputStream in = null;
        FileOutputStream out = null;
        SnappyOutputStream snappyOut = null;
        try {
            boolean read;
            in = new BufferedInputStream(new FileInputStream(uncompressed));
            out = new FileOutputStream(compressed);
            snappyOut = new SnappyOutputStream(out);
            byte[] buf = new byte[65536];
            while (!(read = in.read(buf))) {
                snappyOut.write(buf, 0, read ? 1 : 0);
            }
            out.getFD().sync();
            read = true;
            return read;
        }
        catch (Exception ex) {
            LOG.error("Error while attempting to compress " + uncompressed.toString() + " to " + compressed.toString() + ".", ex);
            Throwables.propagate(ex);
        }
        finally {
            Throwable th = null;
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Throwable ex) {
                LOG.error("Error while closing input file.", ex);
                th = ex;
            }
            try {
                if (snappyOut != null) {
                    snappyOut.close();
                }
            }
            catch (IOException ex) {
                LOG.error("Error while closing output file.", ex);
                Throwables.propagate(ex);
            }
            if (th != null) {
                Throwables.propagate(th);
            }
        }
        throw new IOException("Copying file: " + uncompressed.toString() + " to: " + compressed.toString() + " may have failed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean decompressFile(File compressed, File decompressed) throws IOException {
        Preconditions.checkNotNull(compressed, "Source file is null, decompression failed.");
        Preconditions.checkNotNull(decompressed, "Destination file is null, decompression failed.");
        Preconditions.checkState(compressed.exists(), "Source file: " + compressed.toString() + " does not exist.");
        Preconditions.checkState(!decompressed.exists(), "Decompressed file: " + decompressed.toString() + " unexpectedly exists.");
        BufferedInputStream in = null;
        SnappyInputStream snappyIn = null;
        FileOutputStream out = null;
        try {
            boolean read;
            in = new BufferedInputStream(new FileInputStream(compressed));
            snappyIn = new SnappyInputStream(in);
            out = new FileOutputStream(decompressed);
            byte[] buf = new byte[65536];
            while (!(read = snappyIn.read(buf))) {
                out.write(buf, 0, read ? 1 : 0);
            }
            out.getFD().sync();
            read = true;
            return read;
        }
        catch (Exception ex) {
            LOG.error("Error while attempting to compress " + compressed.toString() + " to " + decompressed.toString() + ".", ex);
            Throwables.propagate(ex);
        }
        finally {
            Throwable th = null;
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Throwable ex) {
                LOG.error("Error while closing input file.", ex);
                th = ex;
            }
            try {
                if (snappyIn != null) {
                    snappyIn.close();
                }
            }
            catch (IOException ex) {
                LOG.error("Error while closing output file.", ex);
                Throwables.propagate(ex);
            }
            if (th != null) {
                Throwables.propagate(th);
            }
        }
        throw new IOException("Decompressing file: " + compressed.toString() + " to: " + decompressed.toString() + " may have failed.");
    }
}

