/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.file;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.flume.channel.file.TransactionEventRecord;
import org.apache.flume.channel.file.proto.ProtosFactory;

class Commit
extends TransactionEventRecord {
    private short type;

    Commit(Long transactionID, Long logWriteOrderID) {
        super(transactionID, logWriteOrderID);
    }

    Commit(Long transactionID, Long logWriteOrderID, short type) {
        this(transactionID, logWriteOrderID);
        this.type = type;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.type = in.readShort();
    }

    @Override
    void writeProtos(OutputStream out) throws IOException {
        ProtosFactory.Commit.Builder commitBuilder = ProtosFactory.Commit.newBuilder();
        commitBuilder.setType(this.type);
        commitBuilder.build().writeDelimitedTo(out);
    }

    @Override
    void readProtos(InputStream in) throws IOException {
        ProtosFactory.Commit commit = Preconditions.checkNotNull(ProtosFactory.Commit.parseDelimitedFrom(in), "Commit cannot be null");
        this.type = (short)commit.getType();
    }

    short getType() {
        return this.type;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeShort(this.type);
    }

    @Override
    short getRecordType() {
        return TransactionEventRecord.Type.COMMIT.get();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Commit [type=");
        builder.append(this.type);
        builder.append(", getLogWriteOrderID()=");
        builder.append(this.getLogWriteOrderID());
        builder.append(", getTransactionID()=");
        builder.append(this.getTransactionID());
        builder.append("]");
        return builder.toString();
    }
}

