/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel;

import com.google.common.base.Preconditions;
import java.util.Locale;
import org.apache.flume.Channel;
import org.apache.flume.ChannelFactory;
import org.apache.flume.FlumeException;
import org.apache.flume.conf.channel.ChannelType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultChannelFactory
implements ChannelFactory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultChannelFactory.class);

    @Override
    public Channel create(String name, String type) throws FlumeException {
        Preconditions.checkNotNull(name, "name");
        Preconditions.checkNotNull(type, "type");
        logger.info("Creating instance of channel {} type {}", (Object)name, (Object)type);
        Class<? extends Channel> channelClass = this.getClass(type);
        try {
            return channelClass.newInstance();
        }
        catch (Exception ex) {
            throw new FlumeException("Unable to create channel: " + name + ", type: " + type + ", class: " + channelClass.getName(), ex);
        }
    }

    @Override
    public Class<? extends Channel> getClass(String type) throws FlumeException {
        String channelClassName = type;
        ChannelType channelType = ChannelType.OTHER;
        try {
            channelType = ChannelType.valueOf(type.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException ex) {
            logger.debug("Channel type {} is a custom type", (Object)type);
        }
        if (!channelType.equals(ChannelType.OTHER)) {
            channelClassName = channelType.getChannelClassName();
        }
        try {
            return Class.forName(channelClassName);
        }
        catch (Exception ex) {
            throw new FlumeException("Unable to load channel type: " + type + ", class: " + channelClassName, ex);
        }
    }
}

