/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch7;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.elasticsearch7.shaded.org.apache.http.HttpHost;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.delete.DeleteRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.index.IndexRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.update.UpdateRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.RestClientBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentType;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.connectors.elasticsearch.ActionRequestFailureHandler;
import org.apache.flink.streaming.connectors.elasticsearch.ElasticsearchSinkBase;
import org.apache.flink.streaming.connectors.elasticsearch.ElasticsearchUpsertTableSinkBase;
import org.apache.flink.streaming.connectors.elasticsearch7.ElasticsearchSink;
import org.apache.flink.streaming.connectors.elasticsearch7.RestClientFactory;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.types.Row;

@Internal
public class Elasticsearch7UpsertTableSink
extends ElasticsearchUpsertTableSinkBase {
    @VisibleForTesting
    static final ElasticsearchUpsertTableSinkBase.RequestFactory UPDATE_REQUEST_FACTORY = new Elasticsearch7RequestFactory();

    public Elasticsearch7UpsertTableSink(boolean isAppendOnly, TableSchema schema, List<ElasticsearchUpsertTableSinkBase.Host> hosts, String index, String keyDelimiter, String keyNullLiteral, SerializationSchema<Row> serializationSchema, XContentType contentType, ActionRequestFailureHandler failureHandler, Map<ElasticsearchUpsertTableSinkBase.SinkOption, String> sinkOptions) {
        super(isAppendOnly, schema, hosts, index, "", keyDelimiter, keyNullLiteral, serializationSchema, contentType, failureHandler, sinkOptions, UPDATE_REQUEST_FACTORY);
    }

    @VisibleForTesting
    Elasticsearch7UpsertTableSink(boolean isAppendOnly, TableSchema schema, List<ElasticsearchUpsertTableSinkBase.Host> hosts, String index, String docType, String keyDelimiter, String keyNullLiteral, SerializationSchema<Row> serializationSchema, XContentType contentType, ActionRequestFailureHandler failureHandler, Map<ElasticsearchUpsertTableSinkBase.SinkOption, String> sinkOptions) {
        super(isAppendOnly, schema, hosts, index, docType, keyDelimiter, keyNullLiteral, serializationSchema, contentType, failureHandler, sinkOptions, UPDATE_REQUEST_FACTORY);
    }

    @Override
    protected ElasticsearchUpsertTableSinkBase copy(boolean isAppendOnly, TableSchema schema, List<ElasticsearchUpsertTableSinkBase.Host> hosts, String index, String docType, String keyDelimiter, String keyNullLiteral, SerializationSchema<Row> serializationSchema, XContentType contentType, ActionRequestFailureHandler failureHandler, Map<ElasticsearchUpsertTableSinkBase.SinkOption, String> sinkOptions, ElasticsearchUpsertTableSinkBase.RequestFactory requestFactory) {
        return new Elasticsearch7UpsertTableSink(isAppendOnly, schema, hosts, index, keyDelimiter, keyNullLiteral, serializationSchema, contentType, failureHandler, sinkOptions);
    }

    @Override
    protected SinkFunction<Tuple2<Boolean, Row>> createSinkFunction(List<ElasticsearchUpsertTableSinkBase.Host> hosts, ActionRequestFailureHandler failureHandler, Map<ElasticsearchUpsertTableSinkBase.SinkOption, String> sinkOptions, ElasticsearchUpsertTableSinkBase.ElasticsearchUpsertSinkFunction upsertSinkFunction) {
        List<HttpHost> httpHosts = hosts.stream().map(host -> new HttpHost(host.hostname, host.port, host.protocol)).collect(Collectors.toList());
        ElasticsearchSink.Builder<Tuple2<Boolean, Row>> builder = this.createBuilder(upsertSinkFunction, httpHosts);
        builder.setFailureHandler(failureHandler);
        Optional.ofNullable(sinkOptions.get((Object)ElasticsearchUpsertTableSinkBase.SinkOption.BULK_FLUSH_MAX_ACTIONS)).ifPresent(v -> builder.setBulkFlushMaxActions(Integer.valueOf(v)));
        Optional.ofNullable(sinkOptions.get((Object)ElasticsearchUpsertTableSinkBase.SinkOption.BULK_FLUSH_MAX_SIZE)).ifPresent(v -> builder.setBulkFlushMaxSizeMb(MemorySize.parse((String)v).getMebiBytes()));
        Optional.ofNullable(sinkOptions.get((Object)ElasticsearchUpsertTableSinkBase.SinkOption.BULK_FLUSH_INTERVAL)).ifPresent(v -> builder.setBulkFlushInterval(Long.valueOf(v)));
        Optional.ofNullable(sinkOptions.get((Object)ElasticsearchUpsertTableSinkBase.SinkOption.BULK_FLUSH_BACKOFF_ENABLED)).ifPresent(v -> builder.setBulkFlushBackoff(Boolean.valueOf(v)));
        Optional.ofNullable(sinkOptions.get((Object)ElasticsearchUpsertTableSinkBase.SinkOption.BULK_FLUSH_BACKOFF_TYPE)).ifPresent(v -> builder.setBulkFlushBackoffType(ElasticsearchSinkBase.FlushBackoffType.valueOf(v)));
        Optional.ofNullable(sinkOptions.get((Object)ElasticsearchUpsertTableSinkBase.SinkOption.BULK_FLUSH_BACKOFF_RETRIES)).ifPresent(v -> builder.setBulkFlushBackoffRetries(Integer.valueOf(v)));
        Optional.ofNullable(sinkOptions.get((Object)ElasticsearchUpsertTableSinkBase.SinkOption.BULK_FLUSH_BACKOFF_DELAY)).ifPresent(v -> builder.setBulkFlushBackoffDelay(Long.valueOf(v)));
        builder.setRestClientFactory(new DefaultRestClientFactory(sinkOptions.get((Object)ElasticsearchUpsertTableSinkBase.SinkOption.REST_PATH_PREFIX)));
        ElasticsearchSink<Tuple2<Boolean, Row>> sink = builder.build();
        Optional.ofNullable(sinkOptions.get((Object)ElasticsearchUpsertTableSinkBase.SinkOption.DISABLE_FLUSH_ON_CHECKPOINT)).ifPresent(v -> {
            if (Boolean.valueOf(v).booleanValue()) {
                sink.disableFlushOnCheckpoint();
            }
        });
        return sink;
    }

    @VisibleForTesting
    ElasticsearchSink.Builder<Tuple2<Boolean, Row>> createBuilder(ElasticsearchUpsertTableSinkBase.ElasticsearchUpsertSinkFunction upsertSinkFunction, List<HttpHost> httpHosts) {
        return new ElasticsearchSink.Builder<Tuple2<Boolean, Row>>(httpHosts, upsertSinkFunction);
    }

    private static class Elasticsearch7RequestFactory
    implements ElasticsearchUpsertTableSinkBase.RequestFactory {
        private Elasticsearch7RequestFactory() {
        }

        @Override
        public UpdateRequest createUpdateRequest(String index, String docType, String key, XContentType contentType, byte[] document) {
            return new UpdateRequest(index, key).doc(document, contentType).upsert(document, contentType);
        }

        @Override
        public IndexRequest createIndexRequest(String index, String docType, XContentType contentType, byte[] document) {
            return new IndexRequest(index).source(document, contentType);
        }

        @Override
        public DeleteRequest createDeleteRequest(String index, String docType, String key) {
            return new DeleteRequest(index, key);
        }
    }

    @VisibleForTesting
    static class DefaultRestClientFactory
    implements RestClientFactory {
        private String pathPrefix;

        public DefaultRestClientFactory(@Nullable String pathPrefix) {
            this.pathPrefix = pathPrefix;
        }

        @Override
        public void configureRestClientBuilder(RestClientBuilder restClientBuilder) {
            if (this.pathPrefix != null) {
                restClientBuilder.setPathPrefix(this.pathPrefix);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultRestClientFactory that = (DefaultRestClientFactory)o;
            return Objects.equals(this.pathPrefix, that.pathPrefix);
        }

        public int hashCode() {
            return Objects.hash(this.pathPrefix);
        }
    }
}

