/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.secure_sm;

import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.secure_sm.SuppressForbidden;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.secure_sm.ThreadPermission;

public class SecureSM
extends SecurityManager {
    private final String[] classesThatCanExit;
    static final String[] TEST_RUNNER_PACKAGES = new String[]{"org\\.apache\\.maven\\.surefire\\.booter\\..*", "com\\.carrotsearch\\.ant\\.tasks\\.junit4\\.slave\\..*", "org\\.eclipse.jdt\\.internal\\.junit\\.runner\\..*", "com\\.intellij\\.rt\\.execution\\.junit\\..*", "com\\.intellij\\.rt\\.junit\\..*"};
    private static final boolean DEBUG = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            try {
                String v = System.getProperty("java.security.debug");
                return v != null && v.length() > 0;
            }
            catch (SecurityException e) {
                return false;
            }
        }
    });
    private static final Permission MODIFY_THREAD_PERMISSION = new RuntimePermission("modifyThread");
    private static final Permission MODIFY_ARBITRARY_THREAD_PERMISSION = new ThreadPermission("modifyArbitraryThread");
    private static final Permission MODIFY_THREADGROUP_PERMISSION = new RuntimePermission("modifyThreadGroup");
    private static final Permission MODIFY_ARBITRARY_THREADGROUP_PERMISSION = new ThreadPermission("modifyArbitraryThreadGroup");

    public SecureSM() {
        this(new String[0]);
    }

    public SecureSM(String[] classesThatCanExit) {
        this.classesThatCanExit = classesThatCanExit;
    }

    public static SecureSM createTestSecureSM() {
        return new SecureSM(TEST_RUNNER_PACKAGES);
    }

    @Override
    @SuppressForbidden(reason="java.security.debug messages go to standard error")
    public void checkAccess(Thread t) {
        try {
            this.checkThreadAccess(t);
        }
        catch (SecurityException e) {
            if (DEBUG) {
                System.err.println("access: caller thread=" + Thread.currentThread());
                System.err.println("access: target thread=" + t);
                this.debugThreadGroups(Thread.currentThread().getThreadGroup(), t.getThreadGroup());
            }
            throw e;
        }
    }

    @Override
    @SuppressForbidden(reason="java.security.debug messages go to standard error")
    public void checkAccess(ThreadGroup g2) {
        try {
            this.checkThreadGroupAccess(g2);
        }
        catch (SecurityException e) {
            if (DEBUG) {
                System.err.println("access: caller thread=" + Thread.currentThread());
                this.debugThreadGroups(Thread.currentThread().getThreadGroup(), g2);
            }
            throw e;
        }
    }

    @SuppressForbidden(reason="java.security.debug messages go to standard error")
    private void debugThreadGroups(ThreadGroup caller, ThreadGroup target) {
        System.err.println("access: caller group=" + caller);
        System.err.println("access: target group=" + target);
    }

    protected void checkThreadAccess(Thread t) {
        Objects.requireNonNull(t);
        this.checkPermission(MODIFY_THREAD_PERMISSION);
        ThreadGroup source = Thread.currentThread().getThreadGroup();
        ThreadGroup target = t.getThreadGroup();
        if (target == null) {
            return;
        }
        if (!source.parentOf(target)) {
            this.checkPermission(MODIFY_ARBITRARY_THREAD_PERMISSION);
        }
    }

    protected void checkThreadGroupAccess(ThreadGroup g2) {
        Objects.requireNonNull(g2);
        this.checkPermission(MODIFY_THREADGROUP_PERMISSION);
        ThreadGroup source = Thread.currentThread().getThreadGroup();
        ThreadGroup target = g2;
        if (source == null) {
            return;
        }
        if (!source.parentOf(target)) {
            this.checkPermission(MODIFY_ARBITRARY_THREADGROUP_PERMISSION);
        }
    }

    @Override
    public void checkExit(int status) {
        this.innerCheckExit(status);
    }

    protected void innerCheckExit(final int status) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                String systemClassName = System.class.getName();
                String runtimeClassName = Runtime.class.getName();
                String exitMethodHit = null;
                for (StackTraceElement se : Thread.currentThread().getStackTrace()) {
                    String className = se.getClassName();
                    String methodName = se.getMethodName();
                    if (("exit".equals(methodName) || "halt".equals(methodName)) && (systemClassName.equals(className) || runtimeClassName.equals(className))) {
                        exitMethodHit = className + '#' + methodName + '(' + status + ')';
                        continue;
                    }
                    if (exitMethodHit == null) continue;
                    if (SecureSM.this.classesThatCanExit == null || !SecureSM.classCanExit(className, SecureSM.this.classesThatCanExit)) break;
                    return null;
                }
                if (exitMethodHit == null) {
                    exitMethodHit = "JVM exit method";
                }
                throw new SecurityException(exitMethodHit + " calls are not allowed");
            }
        });
        super.checkExit(status);
    }

    static boolean classCanExit(String className, String[] classesThatCanExit) {
        for (String classThatCanExit : classesThatCanExit) {
            if (!className.matches(classThatCanExit)) continue;
            return true;
        }
        return false;
    }
}

