/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.lookup;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ExceptionsHelper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.logging.DeprecationLogger;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.IndexFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.ScriptDocValues;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MappedFieldType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MapperService;
import org.apache.logging.log4j.LogManager;

public class LeafDocLookup
implements Map<String, ScriptDocValues<?>> {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(LogManager.getLogger(LeafDocLookup.class));
    static final String TYPES_DEPRECATION_KEY = "type-field-doc-lookup";
    static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Looking up doc types [_type] in scripts is deprecated.";
    private final Map<String, ScriptDocValues<?>> localCacheFieldData = new HashMap(4);
    private final MapperService mapperService;
    private final Function<MappedFieldType, IndexFieldData<?>> fieldDataLookup;
    @Nullable
    private final String[] types;
    private final LeafReaderContext reader;
    private int docId = -1;

    LeafDocLookup(MapperService mapperService, Function<MappedFieldType, IndexFieldData<?>> fieldDataLookup, @Nullable String[] types, LeafReaderContext reader) {
        this.mapperService = mapperService;
        this.fieldDataLookup = fieldDataLookup;
        this.types = types;
        this.reader = reader;
    }

    public MapperService mapperService() {
        return this.mapperService;
    }

    public void setDocument(int docId) {
        this.docId = docId;
    }

    @Override
    public ScriptDocValues<?> get(Object key) {
        String fieldName;
        ScriptDocValues scriptValues;
        if ("_type".equals(key)) {
            DEPRECATION_LOGGER.deprecatedAndMaybeLog(TYPES_DEPRECATION_KEY, TYPES_DEPRECATION_MESSAGE, new Object[0]);
        }
        if ((scriptValues = this.localCacheFieldData.get(fieldName = key.toString())) == null) {
            final MappedFieldType fieldType = this.mapperService.fieldType(fieldName);
            if (fieldType == null) {
                throw new IllegalArgumentException("No field found for [" + fieldName + "] in mapping with types " + Arrays.toString(this.types));
            }
            scriptValues = (ScriptDocValues)AccessController.doPrivileged(new PrivilegedAction<ScriptDocValues<?>>(){

                @Override
                public ScriptDocValues<?> run() {
                    return ((IndexFieldData)LeafDocLookup.this.fieldDataLookup.apply(fieldType)).load(LeafDocLookup.this.reader).getScriptValues();
                }
            });
            this.localCacheFieldData.put(fieldName, scriptValues);
        }
        try {
            scriptValues.setNextDocId(this.docId);
        }
        catch (IOException e) {
            throw ExceptionsHelper.convertToElastic(e);
        }
        return scriptValues;
    }

    @Override
    public boolean containsKey(Object key) {
        MappedFieldType fieldType;
        String fieldName = key.toString();
        ScriptDocValues<?> scriptValues = this.localCacheFieldData.get(fieldName);
        return scriptValues != null || (fieldType = this.mapperService.fieldType(fieldName)) != null;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ScriptDocValues<?> put(String key, ScriptDocValues<?> value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ScriptDocValues<?> remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends ScriptDocValues<?>> m3) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<ScriptDocValues<?>> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<String, ScriptDocValues<?>>> entrySet() {
        throw new UnsupportedOperationException();
    }
}

