/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.lookup;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MappedFieldType;

public class FieldLookup {
    private final MappedFieldType fieldType;
    private Map<String, List<Object>> fields;
    private Object value;
    private boolean valueLoaded = false;
    private List<Object> values = new ArrayList<Object>();
    private boolean valuesLoaded = false;

    FieldLookup(MappedFieldType fieldType) {
        this.fieldType = fieldType;
    }

    public MappedFieldType fieldType() {
        return this.fieldType;
    }

    public Map<String, List<Object>> fields() {
        return this.fields;
    }

    public void fields(Map<String, List<Object>> fields) {
        this.fields = fields;
    }

    public void clear() {
        this.value = null;
        this.valueLoaded = false;
        this.values.clear();
        this.valuesLoaded = false;
        this.fields = null;
    }

    public boolean isEmpty() {
        if (this.valueLoaded) {
            return this.value == null;
        }
        if (this.valuesLoaded) {
            return this.values.isEmpty();
        }
        return this.getValue() == null;
    }

    public Object getValue() {
        if (this.valueLoaded) {
            return this.value;
        }
        this.valueLoaded = true;
        this.value = null;
        List<Object> values = this.fields.get(this.fieldType.name());
        return values != null ? (this.value = values.get(0)) : null;
    }

    public List<Object> getValues() {
        if (this.valuesLoaded) {
            return this.values;
        }
        this.valuesLoaded = true;
        this.values.clear();
        this.values = this.fields().get(this.fieldType.name());
        return this.values;
    }
}

