/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.Writeable;

public final class SearchContextId
implements Writeable {
    private final String readerId;
    private final long id;

    public SearchContextId(String readerId, long id) {
        this.readerId = Objects.requireNonNull(readerId);
        this.id = id;
    }

    public SearchContextId(StreamInput in) throws IOException {
        this.id = in.readLong();
        this.readerId = in.getVersion().onOrAfter(Version.V_7_7_0) ? in.readString() : "";
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.id);
        if (out.getVersion().onOrAfter(Version.V_7_7_0)) {
            out.writeString(this.readerId);
        }
    }

    public String getReaderId() {
        return this.readerId;
    }

    public long getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchContextId other = (SearchContextId)o;
        return this.id == other.id && this.readerId.equals(other.readerId);
    }

    public int hashCode() {
        return Objects.hash(this.readerId, this.id);
    }

    public String toString() {
        return "[" + this.readerId + "][" + this.id + "]";
    }
}

