/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.subphase.highlight;

import java.io.IOException;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.Analyzer;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.highlight.Encoder;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.uhighlight.BoundedBreakIteratorScanner;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.uhighlight.CustomPassageFormatter;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.uhighlight.CustomSeparatorBreakIterator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.uhighlight.CustomUnifiedHighlighter;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.uhighlight.PassageFormatter;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.uhighlight.Snippet;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.uhighlight.UnifiedHighlighter;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.CollectionUtil;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.text.Text;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.IndexSettings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.DocumentMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MappedFieldType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.TextSearchInfo;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.QueryShardContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.FetchPhaseExecutionException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.FetchSubPhase;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.subphase.highlight.HighlightUtils;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.subphase.highlight.Highlighter;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.subphase.highlight.HighlighterContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.subphase.highlight.SearchContextHighlight;

public class UnifiedHighlighter
implements Highlighter {
    @Override
    public boolean canHighlight(MappedFieldType fieldType) {
        return true;
    }

    @Override
    public HighlightField highlight(HighlighterContext highlighterContext) {
        MappedFieldType fieldType = highlighterContext.fieldType;
        SearchContextHighlight.Field field = highlighterContext.field;
        QueryShardContext context = highlighterContext.context;
        FetchSubPhase.HitContext hitContext = highlighterContext.hitContext;
        Encoder encoder = field.fieldOptions().encoder().equals("html") ? HighlightUtils.Encoders.HTML : HighlightUtils.Encoders.DEFAULT;
        int maxAnalyzedOffset = context.getIndexSettings().getHighlightMaxAnalyzedOffset();
        Integer keywordIgnoreAbove = null;
        if (fieldType instanceof KeywordFieldMapper.KeywordFieldType) {
            KeywordFieldMapper mapper = (KeywordFieldMapper)context.getMapperService().documentMapper().mappers().getMapper(highlighterContext.fieldName);
            keywordIgnoreAbove = mapper.ignoreAbove();
        }
        ArrayList<Snippet> snippets = new ArrayList<Snippet>();
        int numberOfFragments = field.fieldOptions().numberOfFragments();
        try {
            Snippet[] fieldSnippets;
            CustomUnifiedHighlighter highlighter;
            Analyzer analyzer = this.getAnalyzer(context.getMapperService().documentMapper(hitContext.hit().getType()), hitContext);
            List<Object> fieldValues = this.loadFieldValues(fieldType, field, context, hitContext, highlighterContext.highlight.forceSource(field));
            if (fieldValues.size() == 0) {
                return null;
            }
            PassageFormatter passageFormatter = this.getPassageFormatter(hitContext, field, encoder);
            IndexSearcher searcher = new IndexSearcher(hitContext.reader());
            String fieldValue = UnifiedHighlighter.mergeFieldValues(fieldValues, '\u0000');
            UnifiedHighlighter.OffsetSource offsetSource = this.getOffsetSource(fieldType);
            int fieldValueLength = fieldValue.length();
            if (keywordIgnoreAbove != null && fieldValueLength > keywordIgnoreAbove) {
                return null;
            }
            if (offsetSource == UnifiedHighlighter.OffsetSource.ANALYSIS && fieldValueLength > maxAnalyzedOffset) {
                throw new IllegalArgumentException("The length of [" + highlighterContext.fieldName + "] field of [" + hitContext.hit().getId() + "] doc of [" + context.index().getName() + "] index has exceeded [" + maxAnalyzedOffset + "] - maximum allowed to be analyzed for highlighting. This maximum can be set by changing the [" + IndexSettings.MAX_ANALYZED_OFFSET_SETTING.getKey() + "] index level setting. For large texts, indexing with offsets or term vectors is recommended!");
            }
            if (numberOfFragments == 0 || !fieldType.getTextSearchInfo().isTokenized()) {
                CustomSeparatorBreakIterator breakIterator = new CustomSeparatorBreakIterator('\u0000');
                highlighter = new CustomUnifiedHighlighter(searcher, analyzer, offsetSource, passageFormatter, field.fieldOptions().boundaryScannerLocale(), breakIterator, fieldValue, field.fieldOptions().noMatchSize());
                numberOfFragments = numberOfFragments == 0 ? fieldValues.size() : numberOfFragments;
            } else {
                BreakIterator bi = this.getBreakIterator(field);
                highlighter = new CustomUnifiedHighlighter(searcher, analyzer, offsetSource, passageFormatter, field.fieldOptions().boundaryScannerLocale(), bi, fieldValue, field.fieldOptions().noMatchSize());
                numberOfFragments = field.fieldOptions().numberOfFragments();
            }
            if (field.fieldOptions().requireFieldMatch().booleanValue()) {
                String fieldName = highlighterContext.fieldName;
                highlighter.setFieldMatcher(name -> fieldName.equals(name));
            } else {
                highlighter.setFieldMatcher(name -> !"_id".equals(name));
            }
            for (Snippet fieldSnippet : fieldSnippets = highlighter.highlightField(highlighterContext.fieldName, highlighterContext.query, hitContext.docId(), numberOfFragments)) {
                if (!Strings.hasText(fieldSnippet.getText())) continue;
                snippets.add(fieldSnippet);
            }
        }
        catch (IOException e) {
            throw new FetchPhaseExecutionException(highlighterContext.shardTarget, "Failed to highlight field [" + highlighterContext.fieldName + "]", e);
        }
        if (field.fieldOptions().scoreOrdered().booleanValue()) {
            CollectionUtil.introSort(snippets, (o1, o2) -> Double.compare(o2.getScore(), o1.getScore()));
        }
        String[] fragments = new String[snippets.size()];
        for (int i = 0; i < fragments.length; ++i) {
            fragments[i] = ((Snippet)snippets.get(i)).getText();
        }
        if (fragments.length > 0) {
            return new HighlightField(highlighterContext.fieldName, Text.convertFromStringArray(fragments));
        }
        return null;
    }

    protected PassageFormatter getPassageFormatter(FetchSubPhase.HitContext hitContext, SearchContextHighlight.Field field, Encoder encoder) {
        CustomPassageFormatter passageFormatter = new CustomPassageFormatter(field.fieldOptions().preTags()[0], field.fieldOptions().postTags()[0], encoder);
        return passageFormatter;
    }

    protected Analyzer getAnalyzer(DocumentMapper docMapper, FetchSubPhase.HitContext hitContext) {
        return docMapper.mappers().indexAnalyzer();
    }

    protected List<Object> loadFieldValues(MappedFieldType fieldType, SearchContextHighlight.Field field, QueryShardContext context, FetchSubPhase.HitContext hitContext, boolean forceSource) throws IOException {
        List<Object> fieldValues = HighlightUtils.loadFieldValues(fieldType, context, hitContext, forceSource);
        fieldValues = fieldValues.stream().map(s2 -> UnifiedHighlighter.convertFieldValue(fieldType, s2)).collect(Collectors.toList());
        return fieldValues;
    }

    protected BreakIterator getBreakIterator(SearchContextHighlight.Field field) {
        SearchContextHighlight.FieldOptions fieldOptions = field.fieldOptions();
        Locale locale = fieldOptions.boundaryScannerLocale() != null ? fieldOptions.boundaryScannerLocale() : Locale.ROOT;
        HighlightBuilder.BoundaryScannerType type = fieldOptions.boundaryScannerType() != null ? fieldOptions.boundaryScannerType() : HighlightBuilder.BoundaryScannerType.SENTENCE;
        int maxLen = fieldOptions.fragmentCharSize();
        switch (type) {
            case SENTENCE: {
                if (maxLen > 0) {
                    return BoundedBreakIteratorScanner.getSentence(locale, maxLen);
                }
                return BreakIterator.getSentenceInstance(locale);
            }
            case WORD: {
                return BreakIterator.getWordInstance(locale);
            }
        }
        throw new IllegalArgumentException("Invalid boundary scanner type: " + type.toString());
    }

    protected static String convertFieldValue(MappedFieldType type, Object value) {
        if (value instanceof BytesRef) {
            return type.valueForDisplay(value).toString();
        }
        return value.toString();
    }

    protected static String mergeFieldValues(List<Object> fieldValues, char valuesSeparator) {
        String rawValue = Strings.collectionToDelimitedString(fieldValues, String.valueOf(valuesSeparator));
        return rawValue.substring(0, Math.min(rawValue.length(), 0x7FFFFFFE));
    }

    protected UnifiedHighlighter.OffsetSource getOffsetSource(MappedFieldType fieldType) {
        TextSearchInfo tsi = fieldType.getTextSearchInfo();
        if (tsi.hasOffsets()) {
            return tsi.termVectors() != TextSearchInfo.TermVector.NONE ? UnifiedHighlighter.OffsetSource.POSTINGS_WITH_TERM_VECTORS : UnifiedHighlighter.OffsetSource.POSTINGS;
        }
        if (tsi.termVectors() == TextSearchInfo.TermVector.OFFSETS) {
            return UnifiedHighlighter.OffsetSource.TERM_VECTORS;
        }
        return UnifiedHighlighter.OffsetSource.ANALYSIS;
    }
}

