/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.AggregationUsageService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.AggregatorSupplier;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.ValuesSourceType;

public class ValuesSourceRegistry {
    private final AggregationUsageService usageService;
    private final Map<String, Map<ValuesSourceType, AggregatorSupplier>> aggregatorRegistry;

    public ValuesSourceRegistry(Map<String, List<Map.Entry<ValuesSourceType, AggregatorSupplier>>> aggregatorRegistry, AggregationUsageService usageService) {
        HashMap tmp = new HashMap();
        aggregatorRegistry.forEach((key, value) -> tmp.put(key, value.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))));
        this.aggregatorRegistry = Collections.unmodifiableMap(tmp);
        this.usageService = usageService;
    }

    private AggregatorSupplier findMatchingSuppier(ValuesSourceType valuesSourceType, Map<ValuesSourceType, AggregatorSupplier> supportedTypes) {
        return supportedTypes.get(valuesSourceType);
    }

    public boolean isRegistered(String aggregationName) {
        return this.aggregatorRegistry.containsKey(aggregationName);
    }

    public AggregatorSupplier getAggregator(ValuesSourceConfig valuesSourceConfig, String aggregationName) {
        if (aggregationName != null && this.aggregatorRegistry.containsKey(aggregationName)) {
            AggregatorSupplier supplier = this.findMatchingSuppier(valuesSourceConfig.valueSourceType(), this.aggregatorRegistry.get(aggregationName));
            if (supplier == null) {
                throw new IllegalArgumentException(valuesSourceConfig.getDescription() + " is not supported for aggregation [" + aggregationName + "]");
            }
            return supplier;
        }
        throw new AggregationExecutionException("Unregistered Aggregation [" + aggregationName + "]");
    }

    public AggregationUsageService getUsageService() {
        return this.usageService;
    }

    public static class Builder {
        private final AggregationUsageService.Builder usageServiceBuilder;
        private final Map<String, List<Map.Entry<ValuesSourceType, AggregatorSupplier>>> aggregatorRegistry = new HashMap<String, List<Map.Entry<ValuesSourceType, AggregatorSupplier>>>();

        public Builder() {
            this.usageServiceBuilder = new AggregationUsageService.Builder();
        }

        public synchronized void register(String aggregationName, ValuesSourceType valuesSourceType, AggregatorSupplier aggregatorSupplier) {
            if (!this.aggregatorRegistry.containsKey(aggregationName)) {
                this.aggregatorRegistry.put(aggregationName, new ArrayList());
            }
            this.aggregatorRegistry.get(aggregationName).add(new AbstractMap.SimpleEntry<ValuesSourceType, AggregatorSupplier>(valuesSourceType, aggregatorSupplier));
            this.registerUsage(aggregationName, valuesSourceType);
        }

        public void register(String aggregationName, List<ValuesSourceType> valuesSourceTypes, AggregatorSupplier aggregatorSupplier) {
            for (ValuesSourceType valuesSourceType : valuesSourceTypes) {
                this.register(aggregationName, valuesSourceType, aggregatorSupplier);
            }
        }

        public void registerUsage(String aggregationName, ValuesSourceType valuesSourceType) {
            this.usageServiceBuilder.registerAggregationUsage(aggregationName, valuesSourceType.typeName());
        }

        public void registerUsage(String aggregationName) {
            this.usageServiceBuilder.registerAggregationUsage(aggregationName);
        }

        public ValuesSourceRegistry build() {
            return new ValuesSourceRegistry(this.aggregatorRegistry, this.usageServiceBuilder.build());
        }
    }
}

