/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;

public class AggregationUsageService {
    private final Map<String, Map<String, LongAdder>> aggs;
    public static final String OTHER_SUBTYPE = "other";

    private AggregationUsageService(Builder builder) {
        this.aggs = builder.aggs;
    }

    public void incAggregationUsage(String aggregationName, String valuesSourceType) {
        Map<String, LongAdder> valuesSourceMap = this.aggs.get(aggregationName);
        if (valuesSourceMap != null) {
            LongAdder adder = valuesSourceMap.get(valuesSourceType);
            if (adder != null) {
                adder.increment();
            }
            assert (adder != null) : "Unknown subtype [" + aggregationName + "][" + valuesSourceType + "]";
        }
        assert (valuesSourceMap != null) : "Unknown aggregation [" + aggregationName + "][" + valuesSourceType + "]";
    }

    public Map<String, Object> getUsageStats() {
        HashMap<String, Object> aggsUsageMap = new HashMap<String, Object>();
        this.aggs.forEach((name, agg) -> {
            HashMap aggUsageMap = new HashMap();
            agg.forEach((k, v) -> {
                long val2 = v.longValue();
                if (val2 > 0L) {
                    aggUsageMap.put(k, val2);
                }
            });
            if (!aggUsageMap.isEmpty()) {
                aggsUsageMap.put((String)name, aggUsageMap);
            }
        });
        return aggsUsageMap;
    }

    public static class Builder {
        private final Map<String, Map<String, LongAdder>> aggs = new HashMap<String, Map<String, LongAdder>>();

        public void registerAggregationUsage(String aggregationName) {
            this.registerAggregationUsage(aggregationName, AggregationUsageService.OTHER_SUBTYPE);
        }

        public void registerAggregationUsage(String aggregationName, String valuesSourceType) {
            Map subAgg = this.aggs.computeIfAbsent(aggregationName, k -> new HashMap());
            if (subAgg.put(valuesSourceType, new LongAdder()) != null) {
                throw new IllegalArgumentException("stats for aggregation [" + aggregationName + "][" + valuesSourceType + "] already registered");
            }
        }

        public AggregationUsageService build() {
            return new AggregationUsageService(this);
        }
    }
}

