/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.SortedNumericDocValues;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lease.Releasables;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.BigArrays;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.LongArray;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.Aggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.InternalAggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.metrics.InternalValueCount;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.ValuesSource;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.SearchContext;

public class ValueCountAggregator
extends NumericMetricsAggregator.SingleValue {
    final ValuesSource valuesSource;
    LongArray counts;

    public ValueCountAggregator(String name, ValuesSourceConfig valuesSourceConfig, SearchContext aggregationContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, aggregationContext, parent, metadata);
        ValuesSource valuesSource = this.valuesSource = valuesSourceConfig.hasValues() ? valuesSourceConfig.getValuesSource() : null;
        if (this.valuesSource != null) {
            this.counts = this.context.bigArrays().newLongArray(1L, true);
        }
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.context.bigArrays();
        if (this.valuesSource instanceof ValuesSource.Numeric) {
            final SortedNumericDocValues values = ((ValuesSource.Numeric)this.valuesSource).longValues(ctx);
            return new LeafBucketCollectorBase(sub, values){

                @Override
                public void collect(int doc, long bucket) throws IOException {
                    ValueCountAggregator.this.counts = bigArrays.grow(ValueCountAggregator.this.counts, bucket + 1L);
                    if (values.advanceExact(doc)) {
                        ValueCountAggregator.this.counts.increment(bucket, values.docValueCount());
                    }
                }
            };
        }
        if (this.valuesSource instanceof ValuesSource.GeoPoint) {
            final MultiGeoPointValues values = ((ValuesSource.GeoPoint)this.valuesSource).geoPointValues(ctx);
            return new LeafBucketCollectorBase(sub, null){

                @Override
                public void collect(int doc, long bucket) throws IOException {
                    ValueCountAggregator.this.counts = bigArrays.grow(ValueCountAggregator.this.counts, bucket + 1L);
                    if (values.advanceExact(doc)) {
                        ValueCountAggregator.this.counts.increment(bucket, values.docValueCount());
                    }
                }
            };
        }
        final SortedBinaryDocValues values = this.valuesSource.bytesValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                ValueCountAggregator.this.counts = bigArrays.grow(ValueCountAggregator.this.counts, bucket + 1L);
                if (values.advanceExact(doc)) {
                    ValueCountAggregator.this.counts.increment(bucket, values.docValueCount());
                }
            }
        };
    }

    @Override
    public double metric(long owningBucketOrd) {
        return this.valuesSource == null || owningBucketOrd >= this.counts.size() ? 0.0 : (double)this.counts.get(owningBucketOrd);
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSource == null || bucket >= this.counts.size()) {
            return this.buildEmptyAggregation();
        }
        return new InternalValueCount(this.name, this.counts.get(bucket), this.metadata());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalValueCount(this.name, 0L, this.metadata());
    }

    @Override
    public void doClose() {
        Releasables.close(this.counts);
    }
}

