/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.CollectionUtils;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.script.Script;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.script.ScriptedMetricAggContexts;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.Aggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.InternalAggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.metrics.ScriptedMetric;

public class InternalScriptedMetric
extends InternalAggregation
implements ScriptedMetric {
    final Script reduceScript;
    private final List<Object> aggregations;

    InternalScriptedMetric(String name, Object aggregation, Script reduceScript, Map<String, Object> metadata) {
        this(name, Collections.singletonList(aggregation), reduceScript, metadata);
    }

    private InternalScriptedMetric(String name, List<Object> aggregations, Script reduceScript, Map<String, Object> metadata) {
        super(name, metadata);
        this.aggregations = aggregations;
        this.reduceScript = reduceScript;
    }

    public InternalScriptedMetric(StreamInput in) throws IOException {
        super(in);
        this.reduceScript = in.readOptionalWriteable(Script::new);
        this.aggregations = in.getVersion().before(Version.V_7_8_0) ? Collections.singletonList(in.readGenericValue()) : in.readList(StreamInput::readGenericValue);
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable(this.reduceScript);
        if (out.getVersion().before(Version.V_7_8_0)) {
            if (this.aggregations.size() > 0) {
                throw new IllegalArgumentException("scripted_metric doesn't support cross cluster search until 7.8.0");
            }
            out.writeGenericValue(this.aggregations.get(0));
        } else {
            out.writeCollection(this.aggregations, StreamOutput::writeGenericValue);
        }
    }

    @Override
    public String getWriteableName() {
        return "scripted_metric";
    }

    @Override
    public Object aggregation() {
        if (this.aggregations.size() != 1) {
            throw new IllegalStateException("aggregation was not reduced");
        }
        return this.aggregations.get(0);
    }

    List<Object> getAggregation() {
        return this.aggregations;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InternalAggregation reduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        void var5_9;
        ArrayList<Object> aggregationObjects = new ArrayList<Object>();
        for (InternalAggregation internalAggregation : aggregations) {
            InternalScriptedMetric mapReduceAggregation = (InternalScriptedMetric)internalAggregation;
            aggregationObjects.addAll(mapReduceAggregation.aggregations);
        }
        InternalScriptedMetric firstAggregation = (InternalScriptedMetric)aggregations.get(0);
        if (firstAggregation.reduceScript != null && reduceContext.isFinalReduce()) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (firstAggregation.reduceScript.getParams() != null) {
                params.putAll(firstAggregation.reduceScript.getParams());
            }
            ScriptedMetricAggContexts.ReduceScript.Factory factory = reduceContext.scriptService().compile(firstAggregation.reduceScript, ScriptedMetricAggContexts.ReduceScript.CONTEXT);
            ScriptedMetricAggContexts.ReduceScript script = factory.newInstance(params, aggregationObjects);
            Object scriptResult = script.execute();
            CollectionUtils.ensureNoSelfReferences(scriptResult, "reduce script");
            List<Object> list = Collections.singletonList(scriptResult);
        } else if (reduceContext.isFinalReduce()) {
            List list = Collections.singletonList(aggregationObjects);
        } else {
            ArrayList<Object> arrayList = aggregationObjects;
        }
        return new InternalScriptedMetric(firstAggregation.getName(), (List<Object>)var5_9, firstAggregation.reduceScript, this.getMetadata());
    }

    @Override
    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        if (path.size() == 1 && "value".equals(path.get(0))) {
            return this.aggregation();
        }
        throw new IllegalArgumentException("path not supported for [" + this.getName() + "]: " + path);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), this.aggregation());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalScriptedMetric other = (InternalScriptedMetric)obj;
        return Objects.equals(this.reduceScript, other.reduceScript) && Objects.equals(this.aggregations, other.aggregations);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.reduceScript, this.aggregations);
    }
}

