/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.BigArrays;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.DocValueFormat;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.Aggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.InternalAggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.metrics.Cardinality;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.metrics.HyperLogLogPlusPlus;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;

public final class InternalCardinality
extends InternalNumericMetricsAggregation.SingleValue
implements Cardinality {
    private final HyperLogLogPlusPlus counts;

    InternalCardinality(String name, HyperLogLogPlusPlus counts, Map<String, Object> metadata) {
        super(name, metadata);
        this.counts = counts;
    }

    public InternalCardinality(StreamInput in) throws IOException {
        super(in);
        this.format = in.readNamedWriteable(DocValueFormat.class);
        this.counts = in.readBoolean() ? HyperLogLogPlusPlus.readFrom(in, BigArrays.NON_RECYCLING_INSTANCE) : null;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.format);
        if (this.counts != null) {
            out.writeBoolean(true);
            this.counts.writeTo(0L, out);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public String getWriteableName() {
        return "cardinality";
    }

    @Override
    public double value() {
        return this.getValue();
    }

    @Override
    public long getValue() {
        return this.counts == null ? 0L : this.counts.cardinality(0L);
    }

    public HyperLogLogPlusPlus getCounts() {
        return this.counts;
    }

    @Override
    public InternalAggregation reduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        InternalCardinality reduced = null;
        for (InternalAggregation aggregation : aggregations) {
            InternalCardinality cardinality = (InternalCardinality)aggregation;
            if (cardinality.counts == null) continue;
            if (reduced == null) {
                reduced = new InternalCardinality(this.name, new HyperLogLogPlusPlus(cardinality.counts.precision(), BigArrays.NON_RECYCLING_INSTANCE, 1L), this.getMetadata());
            }
            reduced.merge(cardinality);
        }
        if (reduced == null) {
            return aggregations.get(0);
        }
        return reduced;
    }

    public void merge(InternalCardinality other) {
        assert (this.counts != null && other != null);
        this.counts.merge(0L, other.counts, 0L);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        long cardinality = this.getValue();
        builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), cardinality);
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.counts.hashCode(0L));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalCardinality other = (InternalCardinality)obj;
        return this.counts.equals(0L, other.counts);
    }

    HyperLogLogPlusPlus getState() {
        return this.counts;
    }
}

