/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.terms;

import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lease.Releasable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lease.Releasables;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.BigArrays;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.LongArray;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.LongHash;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.ObjectArray;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.CardinalityUpperBound;

public abstract class LongKeyedBucketOrds
implements Releasable {
    public static LongKeyedBucketOrds build(BigArrays bigArrays, CardinalityUpperBound cardinality) {
        return cardinality != CardinalityUpperBound.MANY ? new FromSingle(bigArrays) : new FromMany(bigArrays);
    }

    private LongKeyedBucketOrds() {
    }

    public abstract long add(long var1, long var3);

    public abstract long bucketsInOrd(long var1);

    public abstract long find(long var1, long var3);

    public abstract long size();

    public abstract long maxOwningBucketOrd();

    public abstract BucketOrdsEnum ordsEnum(long var1);

    public static class FromSingle
    extends LongKeyedBucketOrds {
        private final LongHash ords;

        public FromSingle(BigArrays bigArrays) {
            this.ords = new LongHash(1L, bigArrays);
        }

        @Override
        public long add(long owningBucketOrd, long value) {
            assert (owningBucketOrd == 0L);
            return this.ords.add(value);
        }

        @Override
        public long find(long owningBucketOrd, long value) {
            assert (owningBucketOrd == 0L);
            return this.ords.find(value);
        }

        @Override
        public long bucketsInOrd(long owningBucketOrd) {
            assert (owningBucketOrd == 0L);
            return this.ords.size();
        }

        @Override
        public long size() {
            return this.ords.size();
        }

        @Override
        public long maxOwningBucketOrd() {
            return 0L;
        }

        @Override
        public BucketOrdsEnum ordsEnum(long owningBucketOrd) {
            assert (owningBucketOrd == 0L);
            return new BucketOrdsEnum(){
                private long ord = -1L;
                private long value;

                @Override
                public boolean next() {
                    ++this.ord;
                    if (this.ord >= ords.size()) {
                        return false;
                    }
                    this.value = ords.get(this.ord);
                    return true;
                }

                @Override
                public long value() {
                    return this.value;
                }

                @Override
                public long ord() {
                    return this.ord;
                }
            };
        }

        @Override
        public void close() {
            this.ords.close();
        }
    }

    public static class FromMany
    extends LongKeyedBucketOrds {
        private final BigArrays bigArrays;
        private ObjectArray<Buckets> owningOrdToBuckets;
        private long lastGlobalOrd = -1L;

        public FromMany(BigArrays bigArrays) {
            this.bigArrays = bigArrays;
            this.owningOrdToBuckets = bigArrays.newObjectArray(1L);
        }

        @Override
        public long add(long owningBucketOrd, long value) {
            Buckets buckets = this.bucketsForOrd(owningBucketOrd);
            long thisBucketOrd = buckets.valueToThisBucketOrd.add(value);
            if (thisBucketOrd < 0L) {
                thisBucketOrd = -1L - thisBucketOrd;
                return -1L - buckets.thisBucketOrdToGlobalOrd.get(thisBucketOrd);
            }
            buckets.thisBucketOrdToGlobalOrd = this.bigArrays.grow(buckets.thisBucketOrdToGlobalOrd, thisBucketOrd + 1L);
            ++this.lastGlobalOrd;
            buckets.thisBucketOrdToGlobalOrd.set(thisBucketOrd, this.lastGlobalOrd);
            return this.lastGlobalOrd;
        }

        private Buckets bucketsForOrd(long owningBucketOrd) {
            if (this.owningOrdToBuckets.size() <= owningBucketOrd) {
                this.owningOrdToBuckets = this.bigArrays.grow(this.owningOrdToBuckets, owningBucketOrd + 1L);
                Buckets buckets = new Buckets(this.bigArrays);
                this.owningOrdToBuckets.set(owningBucketOrd, buckets);
                return buckets;
            }
            Buckets buckets = this.owningOrdToBuckets.get(owningBucketOrd);
            if (buckets == null) {
                buckets = new Buckets(this.bigArrays);
                this.owningOrdToBuckets.set(owningBucketOrd, buckets);
            }
            return buckets;
        }

        @Override
        public long find(long owningBucketOrd, long value) {
            if (owningBucketOrd >= this.owningOrdToBuckets.size()) {
                return -1L;
            }
            Buckets buckets = this.owningOrdToBuckets.get(owningBucketOrd);
            if (buckets == null) {
                return -1L;
            }
            long thisBucketOrd = buckets.valueToThisBucketOrd.find(value);
            if (thisBucketOrd < 0L) {
                return -1L;
            }
            return buckets.thisBucketOrdToGlobalOrd.get(thisBucketOrd);
        }

        @Override
        public long bucketsInOrd(long owningBucketOrd) {
            if (owningBucketOrd >= this.owningOrdToBuckets.size()) {
                return 0L;
            }
            Buckets buckets = this.owningOrdToBuckets.get(owningBucketOrd);
            if (buckets == null) {
                return 0L;
            }
            return buckets.valueToThisBucketOrd.size();
        }

        @Override
        public long size() {
            return this.lastGlobalOrd + 1L;
        }

        @Override
        public long maxOwningBucketOrd() {
            return this.owningOrdToBuckets.size() - 1L;
        }

        @Override
        public BucketOrdsEnum ordsEnum(long owningBucketOrd) {
            if (owningBucketOrd >= this.owningOrdToBuckets.size()) {
                return BucketOrdsEnum.EMPTY;
            }
            final Buckets buckets = this.owningOrdToBuckets.get(owningBucketOrd);
            if (buckets == null) {
                return BucketOrdsEnum.EMPTY;
            }
            return new BucketOrdsEnum(){
                private long thisBucketOrd = -1L;
                private long value;
                private long ord;

                @Override
                public boolean next() {
                    ++this.thisBucketOrd;
                    if (this.thisBucketOrd >= buckets.valueToThisBucketOrd.size()) {
                        return false;
                    }
                    this.value = buckets.valueToThisBucketOrd.get(this.thisBucketOrd);
                    this.ord = buckets.thisBucketOrdToGlobalOrd.get(this.thisBucketOrd);
                    return true;
                }

                @Override
                public long value() {
                    return this.value;
                }

                @Override
                public long ord() {
                    return this.ord;
                }
            };
        }

        @Override
        public void close() {
            for (long owningBucketOrd = 0L; owningBucketOrd < this.owningOrdToBuckets.size(); ++owningBucketOrd) {
                Buckets buckets = this.owningOrdToBuckets.get(owningBucketOrd);
                if (buckets == null) continue;
                buckets.close();
            }
            this.owningOrdToBuckets.close();
        }

        private static class Buckets
        implements Releasable {
            private final LongHash valueToThisBucketOrd;
            private LongArray thisBucketOrdToGlobalOrd;

            Buckets(BigArrays bigArrays) {
                this.valueToThisBucketOrd = new LongHash(1L, bigArrays);
                this.thisBucketOrdToGlobalOrd = bigArrays.newLongArray(1L, false);
            }

            @Override
            public void close() {
                Releasables.close(this.valueToThisBucketOrd, this.thisBucketOrdToGlobalOrd);
            }
        }
    }

    public static interface BucketOrdsEnum {
        public static final BucketOrdsEnum EMPTY = new BucketOrdsEnum(){

            @Override
            public boolean next() {
                return false;
            }

            @Override
            public long ord() {
                return 0L;
            }

            @Override
            public long value() {
                return 0L;
            }
        };

        public boolean next();

        public long ord();

        public long value();
    }
}

