/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.RangeFieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.RangeType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.Aggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.AggregatorFactories;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.BucketOrder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.histogram.AbstractHistogramAggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.ValuesSource;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.SearchContext;

public class RangeHistogramAggregator
extends AbstractHistogramAggregator {
    private final ValuesSource.Range valuesSource;

    public RangeHistogramAggregator(String name, AggregatorFactories factories, double interval, double offset, BucketOrder order, boolean keyed, long minDocCount, double minBound, double maxBound, ValuesSourceConfig valuesSourceConfig, SearchContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, interval, offset, order, keyed, minDocCount, minBound, maxBound, valuesSourceConfig.format(), context, parent, cardinality, metadata);
        ValuesSource.Range range = this.valuesSource = valuesSourceConfig.hasValues() ? (ValuesSource.Range)valuesSourceConfig.getValuesSource() : null;
        if (!this.valuesSource.rangeType().isNumeric()) {
            throw new IllegalArgumentException("Expected numeric range type but found non-numeric range [" + this.valuesSource.rangeType().name + "]");
        }
    }

    @Override
    protected LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final SortedBinaryDocValues values = this.valuesSource.bytesValues(ctx);
        final RangeType rangeType = this.valuesSource.rangeType();
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long owningBucketOrd) throws IOException {
                if (values.advanceExact(doc)) {
                    int valuesCount = values.docValueCount();
                    assert (valuesCount == 1) : "Value count for ranges should always be 1";
                    double previousKey = Double.NEGATIVE_INFINITY;
                    for (int i = 0; i < valuesCount; ++i) {
                        BytesRef encodedRanges = values.nextValue();
                        List<RangeFieldMapper.Range> ranges = rangeType.decodeRanges(encodedRanges);
                        double previousFrom = Double.NEGATIVE_INFINITY;
                        for (RangeFieldMapper.Range range : ranges) {
                            double key;
                            Double from = rangeType.doubleValue(range.getFrom());
                            assert (from >= previousFrom) : "Start of range not >= previous start";
                            Double to = rangeType.doubleValue(range.getTo());
                            double startKey = Math.floor((from - RangeHistogramAggregator.this.offset) / RangeHistogramAggregator.this.interval);
                            double endKey = Math.floor((to - RangeHistogramAggregator.this.offset) / RangeHistogramAggregator.this.interval);
                            double d = key = startKey > previousKey ? startKey : previousKey;
                            while (key <= endKey) {
                                if (key != previousKey) {
                                    long bucketOrd = RangeHistogramAggregator.this.bucketOrds.add(owningBucketOrd, Double.doubleToLongBits(key));
                                    if (bucketOrd < 0L) {
                                        bucketOrd = -1L - bucketOrd;
                                        RangeHistogramAggregator.this.collectExistingBucket(sub, doc, bucketOrd);
                                    } else {
                                        RangeHistogramAggregator.this.collectBucket(sub, doc, bucketOrd);
                                    }
                                }
                                key += 1.0;
                            }
                            if (!(endKey > previousKey)) continue;
                            previousKey = endKey;
                        }
                    }
                }
            }
        };
    }
}

