/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Locale;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Rounding;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.Writeable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.logging.DeprecationLogger;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.unit.TimeValue;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentFragment;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.histogram.DateIntervalConsumer;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.apache.logging.log4j.LogManager;

public class DateIntervalWrapper
implements ToXContentFragment,
Writeable {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(LogManager.getLogger(DateHistogramAggregationBuilder.class));
    private static final String DEPRECATION_TEXT = "[interval] on [date_histogram] is deprecated, use [fixed_interval] or [calendar_interval] in the future.";
    private static final ParseField FIXED_INTERVAL_FIELD = new ParseField("fixed_interval", new String[0]);
    private static final ParseField CALENDAR_INTERVAL_FIELD = new ParseField("calendar_interval", new String[0]);
    private DateHistogramInterval dateHistogramInterval;
    private IntervalTypeEnum intervalType = IntervalTypeEnum.NONE;

    public static <T extends DateIntervalConsumer> void declareIntervalFields(ObjectParser<T, String> parser) {
        parser.declareField((wrapper, interval) -> {
            if (interval instanceof Long) {
                wrapper.interval((Long)interval);
            } else {
                wrapper.dateHistogramInterval((DateHistogramInterval)interval);
            }
        }, p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                return p.longValue();
            }
            return new DateHistogramInterval(p.text());
        }, Histogram.INTERVAL_FIELD, ObjectParser.ValueType.LONG);
        parser.declareField(DateIntervalConsumer::calendarInterval, p -> new DateHistogramInterval(p.text()), CALENDAR_INTERVAL_FIELD, ObjectParser.ValueType.STRING);
        parser.declareField(DateIntervalConsumer::fixedInterval, p -> new DateHistogramInterval(p.text()), FIXED_INTERVAL_FIELD, ObjectParser.ValueType.STRING);
    }

    public DateIntervalWrapper() {
    }

    public DateIntervalWrapper(StreamInput in) throws IOException {
        if (in.getVersion().before(Version.V_7_2_0)) {
            long interval = in.readLong();
            DateHistogramInterval histoInterval = in.readOptionalWriteable(DateHistogramInterval::new);
            if (histoInterval != null) {
                this.dateHistogramInterval = histoInterval;
                this.intervalType = IntervalTypeEnum.LEGACY_DATE_HISTO;
            } else {
                this.dateHistogramInterval = new DateHistogramInterval(interval + "ms");
                this.intervalType = IntervalTypeEnum.LEGACY_INTERVAL;
            }
        } else {
            this.dateHistogramInterval = in.readOptionalWriteable(DateHistogramInterval::new);
            this.intervalType = IntervalTypeEnum.fromStream(in);
        }
    }

    public IntervalTypeEnum getIntervalType() {
        return this.intervalType;
    }

    @Deprecated
    public long interval() {
        DEPRECATION_LOGGER.deprecatedAndMaybeLog("date-interval-getter", DEPRECATION_TEXT, new Object[0]);
        if (this.intervalType.equals(IntervalTypeEnum.LEGACY_INTERVAL)) {
            return TimeValue.parseTimeValue(this.dateHistogramInterval.toString(), "interval").getMillis();
        }
        return 0L;
    }

    @Deprecated
    public void interval(long interval) {
        if (interval < 1L) {
            throw new IllegalArgumentException("[interval] must be 1 or greater for aggregation [date_histogram]");
        }
        this.setIntervalType(IntervalTypeEnum.LEGACY_INTERVAL);
        DEPRECATION_LOGGER.deprecatedAndMaybeLog("date-interval-setter", DEPRECATION_TEXT, new Object[0]);
        this.dateHistogramInterval = new DateHistogramInterval(interval + "ms");
    }

    @Deprecated
    public DateHistogramInterval dateHistogramInterval() {
        DEPRECATION_LOGGER.deprecatedAndMaybeLog("date-histogram-interval-getter", DEPRECATION_TEXT, new Object[0]);
        if (this.intervalType.equals(IntervalTypeEnum.LEGACY_DATE_HISTO)) {
            return this.dateHistogramInterval;
        }
        return null;
    }

    @Deprecated
    public void dateHistogramInterval(DateHistogramInterval dateHistogramInterval) {
        if (dateHistogramInterval == null || Strings.isNullOrEmpty(dateHistogramInterval.toString())) {
            throw new IllegalArgumentException("[dateHistogramInterval] must not be null: [date_histogram]");
        }
        this.setIntervalType(IntervalTypeEnum.LEGACY_DATE_HISTO);
        DEPRECATION_LOGGER.deprecatedAndMaybeLog("date-histogram-interval-setter", DEPRECATION_TEXT, new Object[0]);
        this.dateHistogramInterval = dateHistogramInterval;
    }

    public DateHistogramInterval getAsCalendarInterval() {
        if (this.intervalType.equals(IntervalTypeEnum.CALENDAR) || this.tryIntervalAsCalendarUnit() != null) {
            return this.dateHistogramInterval;
        }
        throw new IllegalStateException("Cannot convert [" + this.intervalType.toString() + "] interval type into calendar interval");
    }

    public void calendarInterval(DateHistogramInterval interval) {
        if (interval == null || Strings.isNullOrEmpty(interval.toString())) {
            throw new IllegalArgumentException("[interval] must not be null: [date_histogram]");
        }
        if (DateHistogramAggregationBuilder.DATE_FIELD_UNITS.get(interval.toString()) == null) {
            throw new IllegalArgumentException("The supplied interval [" + interval + "] could not be parsed as a calendar interval.");
        }
        this.setIntervalType(IntervalTypeEnum.CALENDAR);
        this.dateHistogramInterval = interval;
    }

    public DateHistogramInterval getAsFixedInterval() {
        if (this.intervalType.equals(IntervalTypeEnum.FIXED) || this.tryIntervalAsFixedUnit() != null) {
            return this.dateHistogramInterval;
        }
        throw new IllegalStateException("Cannot convert [" + this.intervalType.toString() + "] interval type into fixed interval");
    }

    public void fixedInterval(DateHistogramInterval interval) {
        if (interval == null || Strings.isNullOrEmpty(interval.toString())) {
            throw new IllegalArgumentException("[interval] must not be null: [date_histogram]");
        }
        this.setIntervalType(IntervalTypeEnum.FIXED);
        TimeValue.parseTimeValue(interval.toString(), "date_histogram.fixedInterval");
        this.dateHistogramInterval = interval;
    }

    Rounding.DateTimeUnit tryIntervalAsCalendarUnit() {
        if (this.intervalType.equals(IntervalTypeEnum.CALENDAR) || this.intervalType.equals(IntervalTypeEnum.LEGACY_DATE_HISTO)) {
            return DateHistogramAggregationBuilder.DATE_FIELD_UNITS.get(this.dateHistogramInterval.toString());
        }
        return null;
    }

    TimeValue tryIntervalAsFixedUnit() {
        if (this.dateHistogramInterval == null || Strings.isNullOrEmpty(this.dateHistogramInterval.toString())) {
            return null;
        }
        try {
            return TimeValue.parseTimeValue(this.dateHistogramInterval.toString(), null, this.getClass().getSimpleName() + ".interval");
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Rounding createRounding(ZoneId timeZone, long offset) {
        Rounding.Builder tzRoundingBuilder;
        if (this.isEmpty()) {
            throw new IllegalArgumentException("Invalid interval specified, must be non-null and non-empty");
        }
        IntervalTypeEnum intervalType = this.getIntervalType();
        if (intervalType.equals(IntervalTypeEnum.FIXED)) {
            tzRoundingBuilder = Rounding.builder(this.tryIntervalAsFixedUnit());
        } else if (intervalType.equals(IntervalTypeEnum.CALENDAR)) {
            tzRoundingBuilder = Rounding.builder(this.tryIntervalAsCalendarUnit());
        } else {
            Rounding.DateTimeUnit calInterval = this.tryIntervalAsCalendarUnit();
            TimeValue fixedInterval = this.tryIntervalAsFixedUnit();
            if (calInterval != null) {
                tzRoundingBuilder = Rounding.builder(calInterval);
            } else if (fixedInterval != null) {
                tzRoundingBuilder = Rounding.builder(fixedInterval);
            } else {
                throw new IllegalArgumentException("Unable to parse interval [" + this.dateHistogramInterval + "]");
            }
        }
        if (timeZone != null) {
            tzRoundingBuilder.timeZone(timeZone);
        }
        tzRoundingBuilder.offset(offset);
        return tzRoundingBuilder.build();
    }

    private void setIntervalType(IntervalTypeEnum type) {
        if (this.intervalType.equals(IntervalTypeEnum.NONE) || type.equals(this.intervalType)) {
            this.intervalType = type;
            return;
        }
        switch (type) {
            case LEGACY_INTERVAL: {
                if (this.intervalType.equals(IntervalTypeEnum.CALENDAR) || this.intervalType.equals(IntervalTypeEnum.FIXED)) {
                    throw new IllegalArgumentException("Cannot use [interval] with [fixed_interval] or [calendar_interval] configuration options.");
                }
                if (this.intervalType.equals(IntervalTypeEnum.LEGACY_DATE_HISTO)) break;
                this.intervalType = IntervalTypeEnum.LEGACY_INTERVAL;
                break;
            }
            case LEGACY_DATE_HISTO: {
                if (this.intervalType.equals(IntervalTypeEnum.CALENDAR) || this.intervalType.equals(IntervalTypeEnum.FIXED)) {
                    throw new IllegalArgumentException("Cannot use [interval] with [fixed_interval] or [calendar_interval] configuration options.");
                }
                this.intervalType = IntervalTypeEnum.LEGACY_DATE_HISTO;
                break;
            }
            case FIXED: {
                if (this.intervalType.equals(IntervalTypeEnum.LEGACY_INTERVAL) || this.intervalType.equals(IntervalTypeEnum.LEGACY_DATE_HISTO)) {
                    throw new IllegalArgumentException("Cannot use [fixed_interval] with [interval] configuration option.");
                }
                if (this.intervalType.equals(IntervalTypeEnum.CALENDAR)) {
                    throw new IllegalArgumentException("Cannot use [fixed_interval] with [calendar_interval] configuration option.");
                }
                this.intervalType = IntervalTypeEnum.FIXED;
                break;
            }
            case CALENDAR: {
                if (this.intervalType.equals(IntervalTypeEnum.LEGACY_INTERVAL) || this.intervalType.equals(IntervalTypeEnum.LEGACY_DATE_HISTO)) {
                    throw new IllegalArgumentException("Cannot use [calendar_interval] with [interval] configuration option.");
                }
                if (this.intervalType.equals(IntervalTypeEnum.FIXED)) {
                    throw new IllegalArgumentException("Cannot use [calendar_interval] with [fixed_interval] configuration option.");
                }
                this.intervalType = IntervalTypeEnum.CALENDAR;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown interval type.");
            }
        }
    }

    public boolean isEmpty() {
        if (this.intervalType.equals(IntervalTypeEnum.NONE)) {
            return true;
        }
        return this.dateHistogramInterval == null || Strings.isNullOrEmpty(this.dateHistogramInterval.toString());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().before(Version.V_7_2_0)) {
            if (this.intervalType.equals(IntervalTypeEnum.LEGACY_INTERVAL)) {
                out.writeLong(TimeValue.parseTimeValue(this.dateHistogramInterval.toString(), "date_histogram.innerWriteTo").getMillis());
            } else {
                out.writeLong(0L);
            }
            out.writeOptionalWriteable(this.dateHistogramInterval);
        } else {
            out.writeOptionalWriteable(this.dateHistogramInterval);
            this.intervalType.writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.intervalType.equals(IntervalTypeEnum.LEGACY_DATE_HISTO) || this.intervalType.equals(IntervalTypeEnum.LEGACY_INTERVAL)) {
            builder.field(Histogram.INTERVAL_FIELD.getPreferredName(), this.dateHistogramInterval.toString());
        } else if (this.intervalType.equals(IntervalTypeEnum.FIXED)) {
            builder.field(FIXED_INTERVAL_FIELD.getPreferredName(), this.dateHistogramInterval.toString());
        } else if (this.intervalType.equals(IntervalTypeEnum.CALENDAR)) {
            builder.field(CALENDAR_INTERVAL_FIELD.getPreferredName(), this.dateHistogramInterval.toString());
        }
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DateIntervalWrapper that = (DateIntervalWrapper)other;
        if (this.tryIntervalAsCalendarUnit() != null && that.tryIntervalAsCalendarUnit() == null) {
            return false;
        }
        if (this.tryIntervalAsCalendarUnit() == null && that.tryIntervalAsCalendarUnit() != null) {
            return false;
        }
        return Objects.equals(this.dateHistogramInterval, that.dateHistogramInterval);
    }

    public int hashCode() {
        boolean isCalendar = this.tryIntervalAsCalendarUnit() != null;
        return Objects.hash(this.dateHistogramInterval, isCalendar);
    }

    public static enum IntervalTypeEnum implements Writeable
    {
        NONE,
        FIXED,
        CALENDAR,
        LEGACY_INTERVAL,
        LEGACY_DATE_HISTO;


        public static IntervalTypeEnum fromString(String name) {
            return IntervalTypeEnum.valueOf(name.trim().toUpperCase(Locale.ROOT));
        }

        public static IntervalTypeEnum fromStream(StreamInput in) throws IOException {
            return in.readEnum(IntervalTypeEnum.class);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeEnum(this);
        }

        public String value() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

