/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.geogrid;

import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.geo.GeoBoundingBox;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.geo.GeoPoint;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.geogrid.CellIdSource;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.geogrid.CellValues;

class BoundedCellValues
extends CellValues {
    private final GeoBoundingBox geoBoundingBox;

    protected BoundedCellValues(MultiGeoPointValues geoValues, int precision, CellIdSource.GeoPointLongEncoder encoder, GeoBoundingBox geoBoundingBox) {
        super(geoValues, precision, encoder);
        this.geoBoundingBox = geoBoundingBox;
    }

    @Override
    int advanceValue(GeoPoint target, int valuesIdx) {
        if (this.geoBoundingBox.pointInBounds(target.getLon(), target.getLat())) {
            this.values[valuesIdx] = this.encoder.encode(target.getLon(), target.getLat(), this.precision);
            return valuesIdx + 1;
        }
        return valuesIdx;
    }
}

