/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.composite;

import java.io.IOException;
import java.util.Arrays;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.Writeable;

class CompositeKey
implements Writeable {
    private final Comparable[] values;

    CompositeKey(Comparable ... values) {
        this.values = values;
    }

    CompositeKey(StreamInput in) throws IOException {
        this.values = new Comparable[in.readVInt()];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = (Comparable)in.readGenericValue();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.values.length);
        for (int i = 0; i < this.values.length; ++i) {
            out.writeGenericValue(this.values[i]);
        }
    }

    Comparable[] values() {
        return this.values;
    }

    int size() {
        return this.values.length;
    }

    Comparable get(int pos) {
        assert (pos < this.values.length);
        return this.values[pos];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositeKey that = (CompositeKey)o;
        return Arrays.equals(this.values, that.values);
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    public String toString() {
        return "CompositeKey{values=" + Arrays.toString(this.values) + '}';
    }
}

