/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.FieldDoc;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.TopDocs;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ElasticsearchException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionRunnable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.OriginalIndices;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.SearchRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.SearchShardTask;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.SearchType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.ClusterState;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.service.ClusterService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.CheckedSupplier;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.UUIDs;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lucene.Lucene;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Setting;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.unit.TimeValue;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.BigArrays;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.CollectionUtils;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.concurrent.ConcurrentMapLong;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.core.internal.io.IOUtils;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.Index;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.IndexService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.IndexSettings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.engine.Engine;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.InnerHitContextBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.MatchNoneQueryBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.QueryBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.QueryRewriteContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.QueryShardContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.Rewriteable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.IndexEventListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.IndexShard;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.SearchOperationListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.indices.IndicesService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.node.ResponseCollectorService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.script.FieldScript;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.script.ScriptService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.DefaultSearchContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.SearchContextMissingException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.SearchException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.SearchExtBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.SearchPhaseResult;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.SearchShardTarget;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.AggregationInitializationException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.AggregatorFactories;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.InternalAggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.MultiBucketConsumerService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.SearchContextAggregations;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.builder.SearchSourceBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.collapse.CollapseContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.dfs.DfsPhase;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.dfs.DfsSearchResult;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.FetchPhase;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.FetchSearchResult;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.QueryFetchSearchResult;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.ScrollQueryFetchSearchResult;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.ShardFetchRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.subphase.FetchDocValuesContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.subphase.ScriptFieldsContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.AliasFilter;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.InternalScrollSearchRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.ScrollContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.SearchContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.SearchContextId;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.ShardSearchRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.profile.Profilers;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.query.QueryPhase;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.query.QuerySearchRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.query.QuerySearchResult;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.query.ScrollQuerySearchResult;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.rescore.RescorerBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.searchafter.SearchAfterBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.sort.FieldSortBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.sort.MinAndMax;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.sort.SortAndFormats;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.sort.SortBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.suggest.Suggest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.suggest.completion.CompletionSuggestion;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.threadpool.Scheduler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.threadpool.ThreadPool;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SearchService
extends AbstractLifecycleComponent
implements IndexEventListener {
    private static final Logger logger = LogManager.getLogger(SearchService.class);
    public static final Setting<TimeValue> DEFAULT_KEEPALIVE_SETTING = Setting.positiveTimeSetting("search.default_keep_alive", TimeValue.timeValueMinutes(5L), Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<TimeValue> MAX_KEEPALIVE_SETTING = Setting.positiveTimeSetting("search.max_keep_alive", TimeValue.timeValueHours(24L), Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<TimeValue> KEEPALIVE_INTERVAL_SETTING = Setting.positiveTimeSetting("search.keep_alive_interval", TimeValue.timeValueMinutes(1L), Setting.Property.NodeScope);
    public static final Setting<Boolean> ALLOW_EXPENSIVE_QUERIES = Setting.boolSetting("search.allow_expensive_queries", true, Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<Boolean> LOW_LEVEL_CANCELLATION_SETTING = Setting.boolSetting("search.low_level_cancellation", true, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final TimeValue NO_TIMEOUT = TimeValue.timeValueMillis(-1L);
    public static final Setting<TimeValue> DEFAULT_SEARCH_TIMEOUT_SETTING = Setting.timeSetting("search.default_search_timeout", NO_TIMEOUT, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Boolean> DEFAULT_ALLOW_PARTIAL_SEARCH_RESULTS = Setting.boolSetting("search.default_allow_partial_results", true, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> MAX_OPEN_SCROLL_CONTEXT = Setting.intSetting("search.max_open_scroll_context", 500, 0, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final int DEFAULT_SIZE = 10;
    public static final int DEFAULT_FROM = 0;
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final ScriptService scriptService;
    private final ResponseCollectorService responseCollectorService;
    private final BigArrays bigArrays;
    private final DfsPhase dfsPhase = new DfsPhase();
    private final QueryPhase queryPhase;
    private final FetchPhase fetchPhase;
    private volatile long defaultKeepAlive;
    private volatile long maxKeepAlive;
    private volatile TimeValue defaultSearchTimeout;
    private volatile boolean defaultAllowPartialSearchResults;
    private volatile boolean lowLevelCancellation;
    private volatile int maxOpenScrollContext;
    private final Scheduler.Cancellable keepAliveReaper;
    private final AtomicLong idGenerator = new AtomicLong();
    private final ConcurrentMapLong<SearchContext> activeContexts = ConcurrentCollections.newConcurrentMapLongWithAggressiveConcurrency();
    private final MultiBucketConsumerService multiBucketConsumerService;
    private final AtomicInteger openScrollContexts = new AtomicInteger();

    public SearchService(ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ScriptService scriptService, BigArrays bigArrays, FetchPhase fetchPhase, ResponseCollectorService responseCollectorService, CircuitBreakerService circuitBreakerService) {
        Settings settings = clusterService.getSettings();
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.scriptService = scriptService;
        this.responseCollectorService = responseCollectorService;
        this.bigArrays = bigArrays;
        this.queryPhase = new QueryPhase();
        this.fetchPhase = fetchPhase;
        this.multiBucketConsumerService = new MultiBucketConsumerService(clusterService, settings, circuitBreakerService.getBreaker("request"));
        TimeValue keepAliveInterval = KEEPALIVE_INTERVAL_SETTING.get(settings);
        this.setKeepAlives(DEFAULT_KEEPALIVE_SETTING.get(settings), MAX_KEEPALIVE_SETTING.get(settings));
        clusterService.getClusterSettings().addSettingsUpdateConsumer(DEFAULT_KEEPALIVE_SETTING, MAX_KEEPALIVE_SETTING, this::setKeepAlives, this::validateKeepAlives);
        this.keepAliveReaper = threadPool.scheduleWithFixedDelay(new Reaper(), keepAliveInterval, "same");
        this.defaultSearchTimeout = DEFAULT_SEARCH_TIMEOUT_SETTING.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(DEFAULT_SEARCH_TIMEOUT_SETTING, this::setDefaultSearchTimeout);
        this.defaultAllowPartialSearchResults = DEFAULT_ALLOW_PARTIAL_SEARCH_RESULTS.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(DEFAULT_ALLOW_PARTIAL_SEARCH_RESULTS, this::setDefaultAllowPartialSearchResults);
        this.maxOpenScrollContext = MAX_OPEN_SCROLL_CONTEXT.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MAX_OPEN_SCROLL_CONTEXT, this::setMaxOpenScrollContext);
        this.lowLevelCancellation = LOW_LEVEL_CANCELLATION_SETTING.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(LOW_LEVEL_CANCELLATION_SETTING, this::setLowLevelCancellation);
    }

    private void validateKeepAlives(TimeValue defaultKeepAlive, TimeValue maxKeepAlive) {
        if (defaultKeepAlive.millis() > maxKeepAlive.millis()) {
            throw new IllegalArgumentException("Default keep alive setting for scroll [" + DEFAULT_KEEPALIVE_SETTING.getKey() + "] should be smaller than max keep alive [" + MAX_KEEPALIVE_SETTING.getKey() + "], was (" + defaultKeepAlive + " > " + maxKeepAlive + ")");
        }
    }

    private void setKeepAlives(TimeValue defaultKeepAlive, TimeValue maxKeepAlive) {
        this.validateKeepAlives(defaultKeepAlive, maxKeepAlive);
        this.defaultKeepAlive = defaultKeepAlive.millis();
        this.maxKeepAlive = maxKeepAlive.millis();
    }

    private void setDefaultSearchTimeout(TimeValue defaultSearchTimeout) {
        this.defaultSearchTimeout = defaultSearchTimeout;
    }

    private void setDefaultAllowPartialSearchResults(boolean defaultAllowPartialSearchResults) {
        this.defaultAllowPartialSearchResults = defaultAllowPartialSearchResults;
    }

    public boolean defaultAllowPartialSearchResults() {
        return this.defaultAllowPartialSearchResults;
    }

    private void setMaxOpenScrollContext(int maxOpenScrollContext) {
        this.maxOpenScrollContext = maxOpenScrollContext;
    }

    private void setLowLevelCancellation(Boolean lowLevelCancellation) {
        this.lowLevelCancellation = lowLevelCancellation;
    }

    @Override
    public void afterIndexRemoved(Index index, IndexSettings indexSettings, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason reason) {
        if (reason == IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.DELETED || reason == IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.CLOSED || reason == IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.REOPENED) {
            this.freeAllContextForIndex(index);
        }
    }

    protected void putContext(SearchContext context) {
        SearchContext previous = this.activeContexts.put(context.id().getId(), context);
        assert (previous == null);
    }

    protected SearchContext removeContext(long id) {
        return this.activeContexts.remove(id);
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
        for (SearchContext context : this.activeContexts.values()) {
            this.freeContext(context.id());
        }
    }

    @Override
    protected void doClose() {
        this.doStop();
        this.keepAliveReaper.cancel();
    }

    public void executeDfsPhase(final ShardSearchRequest request, final SearchShardTask task, final ActionListener<SearchPhaseResult> listener) {
        IndexService indexService = this.indicesService.indexServiceSafe(request.shardId().getIndex());
        final IndexShard shard = indexService.getShard(request.shardId().id());
        this.rewriteAndFetchShardRequest(shard, request, new ActionListener<ShardSearchRequest>(){

            @Override
            public void onResponse(ShardSearchRequest rewritten) {
                SearchService.this.runAsync(shard, () -> SearchService.this.executeDfsPhase(request, task), listener);
            }

            @Override
            public void onFailure(Exception exc) {
                listener.onFailure(exc);
            }
        });
    }

    private DfsSearchResult executeDfsPhase(ShardSearchRequest request, SearchShardTask task) throws IOException {
        SearchContext context = this.createAndPutContext(request, task);
        context.incRef();
        try {
            this.contextProcessing(context);
            this.dfsPhase.execute(context);
            this.contextProcessedSuccessfully(context);
            DfsSearchResult dfsSearchResult = context.dfsResult();
            return dfsSearchResult;
        }
        catch (Exception e) {
            logger.trace("Dfs phase failed", (Throwable)e);
            this.processFailure(context, e);
            throw e;
        }
        finally {
            this.cleanContext(context);
        }
    }

    private void loadOrExecuteQueryPhase(ShardSearchRequest request, SearchContext context) throws Exception {
        boolean canCache = this.indicesService.canCache(request, context);
        context.getQueryShardContext().freezeContext();
        if (canCache) {
            this.indicesService.loadIntoContext(request, context, this.queryPhase);
        } else {
            this.queryPhase.execute(context);
        }
    }

    public void executeQueryPhase(ShardSearchRequest request, final SearchShardTask task, final ActionListener<SearchPhaseResult> listener) {
        assert (!request.canReturnNullResponseIfMatchNoDocs() || request.numberOfShards() > 1) : "empty responses require more than one shard";
        final IndexService indexService = this.indicesService.indexServiceSafe(request.shardId().getIndex());
        final IndexShard shard = indexService.getShard(request.shardId().id());
        this.rewriteAndFetchShardRequest(shard, request, new ActionListener<ShardSearchRequest>(){

            @Override
            public void onResponse(ShardSearchRequest orig) {
                if (orig.canReturnNullResponseIfMatchNoDocs()) {
                    ShardSearchRequest canMatchRequest = new ShardSearchRequest(orig);
                    try (Engine.Searcher searcher = shard.acquireCanMatchSearcher();){
                        QueryShardContext context = indexService.newQueryShardContext(canMatchRequest.shardId().id(), searcher, canMatchRequest::nowInMillis, canMatchRequest.getClusterAlias());
                        Rewriteable.rewrite(canMatchRequest.getRewriteable(), context, true);
                    }
                    catch (Exception exc) {
                        listener.onFailure(exc);
                        return;
                    }
                    if (SearchService.canRewriteToMatchNone(canMatchRequest.source()) && canMatchRequest.source().query() instanceof MatchNoneQueryBuilder) {
                        assert (canMatchRequest.scroll() == null) : "must always create search context for scroll requests";
                        listener.onResponse(QuerySearchResult.nullInstance());
                        return;
                    }
                }
                SearchService.this.runAsync(shard, () -> SearchService.this.executeQueryPhase(orig, task), listener);
            }

            @Override
            public void onFailure(Exception exc) {
                listener.onFailure(exc);
            }
        });
    }

    private <T> void runAsync(IndexShard shard, CheckedSupplier<T, Exception> command, ActionListener<T> listener) {
        Executor executor = this.getExecutor(shard);
        try {
            executor.execute(() -> {
                Object result;
                try {
                    result = command.get();
                }
                catch (Exception exc) {
                    listener.onFailure(exc);
                    return;
                }
                listener.onResponse(result);
            });
        }
        catch (Exception exc) {
            listener.onFailure(exc);
        }
    }

    private <T> void runAsync(SearchContextId contextId, Supplier<T> executable, ActionListener<T> listener) {
        this.getExecutor(contextId).execute(ActionRunnable.supply(listener, executable::get));
    }

    private SearchPhaseResult executeQueryPhase(ShardSearchRequest request, SearchShardTask task) throws Exception {
        SearchContext context = this.createAndPutContext(request, task);
        context.incRef();
        try {
            SearchPhaseResult searchPhaseResult;
            long afterQueryTime;
            try (SearchOperationListenerExecutor executor = new SearchOperationListenerExecutor(context);){
                this.contextProcessing(context);
                this.loadOrExecuteQueryPhase(request, context);
                if (!context.queryResult().hasSearchContext() && context.scrollContext() == null) {
                    this.freeContext(context.id());
                } else {
                    this.contextProcessedSuccessfully(context);
                }
                afterQueryTime = executor.success();
            }
            if (request.numberOfShards() == 1) {
                searchPhaseResult = this.executeFetchPhase(context, afterQueryTime);
                return searchPhaseResult;
            }
            searchPhaseResult = context.queryResult();
            return searchPhaseResult;
        }
        catch (Exception e) {
            if (e instanceof ExecutionException) {
                e = e.getCause() == null || e.getCause() instanceof Exception ? (Exception)e.getCause() : new ElasticsearchException(e.getCause());
            }
            logger.trace("Query phase failed", (Throwable)e);
            this.processFailure(context, e);
            throw e;
        }
        finally {
            this.cleanContext(context);
        }
    }

    private QueryFetchSearchResult executeFetchPhase(SearchContext context, long afterQueryTime) {
        try (SearchOperationListenerExecutor executor = new SearchOperationListenerExecutor(context, true, afterQueryTime);){
            this.shortcutDocIdsToLoad(context);
            this.fetchPhase.execute(context);
            if (this.fetchPhaseShouldFreeContext(context)) {
                this.freeContext(context.id());
            } else {
                this.contextProcessedSuccessfully(context);
            }
            executor.success();
        }
        return new QueryFetchSearchResult(context.queryResult(), context.fetchResult());
    }

    public void executeQueryPhase(InternalScrollSearchRequest request, SearchShardTask task, ActionListener<ScrollQuerySearchResult> listener) {
        this.runAsync(request.contextId(), () -> {
            SearchContext context = this.findContext(request.contextId(), request);
            context.incRef();
            try {
                SearchOperationListenerExecutor executor = new SearchOperationListenerExecutor(context);
                try {
                    context.setTask(task);
                    this.contextProcessing(context);
                    this.processScroll(request, context);
                    this.queryPhase.execute(context);
                    this.contextProcessedSuccessfully(context);
                    executor.success();
                    ScrollQuerySearchResult scrollQuerySearchResult = new ScrollQuerySearchResult(context.queryResult(), context.shardTarget());
                    executor.close();
                    return scrollQuerySearchResult;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            executor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        logger.trace("Query phase failed", (Throwable)e);
                        this.processFailure(context, e);
                        throw e;
                    }
                }
            }
            finally {
                this.cleanContext(context);
            }
        }, listener);
    }

    public void executeQueryPhase(QuerySearchRequest request, SearchShardTask task, ActionListener<QuerySearchResult> listener) {
        this.runAsync(request.contextId(), () -> {
            SearchContext context = this.findContext(request.contextId(), request);
            context.setTask(task);
            context.incRef();
            try {
                SearchOperationListenerExecutor executor = new SearchOperationListenerExecutor(context);
                try {
                    this.contextProcessing(context);
                    context.searcher().setAggregatedDfs(request.dfs());
                    this.queryPhase.execute(context);
                    if (!context.queryResult().hasSearchContext() && context.scrollContext() == null) {
                        this.freeContext(context.id());
                    } else {
                        this.contextProcessedSuccessfully(context);
                    }
                    executor.success();
                    QuerySearchResult querySearchResult = context.queryResult();
                    executor.close();
                    return querySearchResult;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            executor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        logger.trace("Query phase failed", (Throwable)e);
                        this.processFailure(context, e);
                        throw e;
                    }
                }
            }
            finally {
                this.cleanContext(context);
            }
        }, listener);
    }

    private boolean fetchPhaseShouldFreeContext(SearchContext context) {
        if (context.scrollContext() == null) {
            return true;
        }
        return context.scrollContext().scroll == null;
    }

    final Executor getExecutor(SearchContextId contextId) {
        SearchContext context = this.getContext(contextId);
        if (context == null) {
            throw new SearchContextMissingException(contextId);
        }
        return this.getExecutor(context.indexShard());
    }

    private Executor getExecutor(IndexShard indexShard) {
        assert (indexShard != null);
        return this.threadPool.executor(indexShard.indexSettings().isSearchThrottled() ? "search_throttled" : "search");
    }

    public void executeFetchPhase(InternalScrollSearchRequest request, SearchShardTask task, ActionListener<ScrollQueryFetchSearchResult> listener) {
        this.runAsync(request.contextId(), () -> {
            SearchContext context = this.findContext(request.contextId(), request);
            context.setTask(task);
            context.incRef();
            try {
                SearchOperationListenerExecutor executor = new SearchOperationListenerExecutor(context);
                try {
                    this.contextProcessing(context);
                    this.processScroll(request, context);
                    this.queryPhase.execute(context);
                    long afterQueryTime = executor.success();
                    QueryFetchSearchResult fetchSearchResult = this.executeFetchPhase(context, afterQueryTime);
                    ScrollQueryFetchSearchResult scrollQueryFetchSearchResult = new ScrollQueryFetchSearchResult(fetchSearchResult, context.shardTarget());
                    executor.close();
                    return scrollQueryFetchSearchResult;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            executor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        logger.trace("Fetch phase failed", (Throwable)e);
                        this.processFailure(context, e);
                        throw e;
                    }
                }
            }
            finally {
                this.cleanContext(context);
            }
        }, listener);
    }

    public void executeFetchPhase(ShardFetchRequest request, SearchShardTask task, ActionListener<FetchSearchResult> listener) {
        this.runAsync(request.contextId(), () -> {
            SearchContext context = this.findContext(request.contextId(), request);
            context.incRef();
            try {
                context.setTask(task);
                this.contextProcessing(context);
                if (request.lastEmittedDoc() != null) {
                    context.scrollContext().lastEmittedDoc = request.lastEmittedDoc();
                }
                context.docIdsToLoad(request.docIds(), 0, request.docIdsSize());
                try (Object executor = new SearchOperationListenerExecutor(context, true, System.nanoTime());){
                    this.fetchPhase.execute(context);
                    if (this.fetchPhaseShouldFreeContext(context)) {
                        this.freeContext(request.contextId());
                    } else {
                        this.contextProcessedSuccessfully(context);
                    }
                    ((SearchOperationListenerExecutor)executor).success();
                }
                executor = context.fetchResult();
                return executor;
            }
            catch (Exception e) {
                logger.trace("Fetch phase failed", (Throwable)e);
                this.processFailure(context, e);
                throw e;
            }
            finally {
                this.cleanContext(context);
            }
        }, listener);
    }

    private SearchContext getContext(SearchContextId contextId) {
        SearchContext context = this.activeContexts.get(contextId.getId());
        if (context == null) {
            return null;
        }
        if (context.id().getReaderId().equals(contextId.getReaderId()) || contextId.getReaderId().isEmpty()) {
            return context;
        }
        return null;
    }

    private SearchContext findContext(SearchContextId contextId, TransportRequest request) throws SearchContextMissingException {
        SearchContext context = this.getContext(contextId);
        if (context == null) {
            throw new SearchContextMissingException(contextId);
        }
        SearchOperationListener operationListener = context.indexShard().getSearchOperationListener();
        try {
            operationListener.validateSearchContext(context, request);
            return context;
        }
        catch (Exception e) {
            this.processFailure(context, e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final SearchContext createAndPutContext(ShardSearchRequest request, SearchShardTask task) throws IOException {
        SearchContext context = this.createContext(request, task);
        this.onNewContext(context);
        boolean success = false;
        try {
            this.putContext(context);
            this.indicesService.indexServiceSafe(request.shardId().getIndex());
            success = true;
            SearchContext searchContext = context;
            return searchContext;
        }
        finally {
            if (!success) {
                this.freeContext(context.id());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onNewContext(SearchContext context) {
        boolean success = false;
        try {
            if (context.scrollContext() != null) {
                context.indexShard().getSearchOperationListener().onNewScrollContext(context);
            }
            context.indexShard().getSearchOperationListener().onNewContext(context);
            success = true;
        }
        finally {
            if (!success) {
                try (SearchContext dummy = context;){
                    this.onFreeContext(context);
                }
            }
        }
    }

    final SearchContext createContext(ShardSearchRequest request, SearchShardTask searchTask) throws IOException {
        DefaultSearchContext context = this.createSearchContext(request, this.defaultSearchTimeout);
        try {
            if (request.scroll() != null) {
                context.addReleasable(this.openScrollContexts::decrementAndGet, SearchContext.Lifetime.CONTEXT);
                if (this.openScrollContexts.incrementAndGet() > this.maxOpenScrollContext) {
                    throw new ElasticsearchException("Trying to create too many scroll contexts. Must be less than or equal to: [" + this.maxOpenScrollContext + "]. This limit can be set by changing the [" + MAX_OPEN_SCROLL_CONTEXT.getKey() + "] setting.", new Object[0]);
                }
                context.scrollContext(new ScrollContext());
                context.scrollContext().scroll = request.scroll();
            }
            this.parseSource(context, request.source());
            if (context.from() == -1) {
                context.from(0);
            }
            if (context.size() == -1) {
                context.size(10);
            }
            context.setTask(searchTask);
            this.dfsPhase.preProcess(context);
            this.queryPhase.preProcess(context);
            this.fetchPhase.preProcess(context);
            long keepAlive = this.defaultKeepAlive;
            if (request.scroll() != null && request.scroll().keepAlive() != null) {
                keepAlive = request.scroll().keepAlive().millis();
            }
            this.contextScrollKeepAlive(context, keepAlive);
        }
        catch (Exception e) {
            context.close();
            throw e;
        }
        return context;
    }

    public DefaultSearchContext createSearchContext(ShardSearchRequest request, TimeValue timeout) throws IOException {
        return this.createSearchContext(request, timeout, "search");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DefaultSearchContext createSearchContext(ShardSearchRequest request, TimeValue timeout, String source) throws IOException {
        IndexService indexService = this.indicesService.indexServiceSafe(request.shardId().getIndex());
        IndexShard indexShard = indexService.getShard(request.shardId().getId());
        SearchShardTarget shardTarget = new SearchShardTarget(this.clusterService.localNode().getId(), indexShard.shardId(), request.getClusterAlias(), OriginalIndices.NONE);
        Engine.Searcher searcher = indexShard.acquireSearcher(source);
        boolean success = false;
        DefaultSearchContext searchContext = null;
        try {
            String readerId = UUIDs.base64UUID();
            SearchContextId searchContextId = new SearchContextId(readerId, this.idGenerator.incrementAndGet());
            searchContext = new DefaultSearchContext(searchContextId, request, shardTarget, searcher, this.clusterService, indexService, indexShard, this.bigArrays, this.threadPool::relativeTimeInMillis, timeout, this.fetchPhase, this.lowLevelCancellation, this.clusterService.state().nodes().getMinNodeVersion());
            QueryShardContext context = new QueryShardContext(searchContext.getQueryShardContext());
            Rewriteable.rewrite(request.getRewriteable(), context, true);
            assert (searchContext.getQueryShardContext().isCacheable());
            success = true;
            if (success) return searchContext;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(searcher);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(searcher);
        return searchContext;
    }

    private void freeAllContextForIndex(Index index) {
        assert (index != null);
        for (SearchContext ctx : this.activeContexts.values()) {
            if (!index.equals(ctx.indexShard().shardId().getIndex())) continue;
            this.freeContext(ctx.id());
        }
    }

    public boolean freeContext(SearchContextId contextId) {
        if (this.getContext(contextId) != null) {
            try (SearchContext context = this.removeContext(contextId.getId());){
                if (context != null) {
                    this.onFreeContext(context);
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    private void onFreeContext(SearchContext context) {
        assert (context.refCount() > 0) : " refCount must be > 0: " + context.refCount();
        assert (!this.activeContexts.containsKey(context.id().getId()));
        context.indexShard().getSearchOperationListener().onFreeContext(context);
        if (context.scrollContext() != null) {
            context.indexShard().getSearchOperationListener().onFreeScrollContext(context);
        }
    }

    public void freeAllScrollContexts() {
        for (SearchContext searchContext : this.activeContexts.values()) {
            if (searchContext.scrollContext() == null) continue;
            this.freeContext(searchContext.id());
        }
    }

    private void contextScrollKeepAlive(SearchContext context, long keepAlive) {
        if (keepAlive > this.maxKeepAlive) {
            throw new IllegalArgumentException("Keep alive for scroll (" + TimeValue.timeValueMillis(keepAlive) + ") is too large. It must be less than (" + TimeValue.timeValueMillis(this.maxKeepAlive) + "). This limit can be set by changing the [" + MAX_KEEPALIVE_SETTING.getKey() + "] cluster level setting.");
        }
        context.keepAlive(keepAlive);
    }

    private void contextProcessing(SearchContext context) {
        context.accessed(-1L);
    }

    private void contextProcessedSuccessfully(SearchContext context) {
        context.accessed(this.threadPool.relativeTimeInMillis());
    }

    private void cleanContext(SearchContext context) {
        try {
            context.clearReleasables(SearchContext.Lifetime.PHASE);
            context.setTask(null);
        }
        finally {
            context.decRef();
        }
    }

    private void processFailure(SearchContext context, Exception e) {
        this.freeContext(context.id());
        try {
            if (Lucene.isCorruptionException(e)) {
                context.indexShard().failShard("search execution corruption failure", e);
            }
        }
        catch (Exception inner) {
            inner.addSuppressed(e);
            logger.warn("failed to process shard failure to (potentially) send back shard failure on corruption", (Throwable)inner);
        }
    }

    private void parseSource(DefaultSearchContext context, SearchSourceBuilder source) throws SearchException {
        if (source == null) {
            return;
        }
        SearchShardTarget shardTarget = context.shardTarget();
        QueryShardContext queryShardContext = context.getQueryShardContext();
        context.from(source.from());
        context.size(source.size());
        HashMap<String, InnerHitContextBuilder> innerHitBuilders = new HashMap<String, InnerHitContextBuilder>();
        if (source.query() != null) {
            InnerHitContextBuilder.extractInnerHits(source.query(), innerHitBuilders);
            context.parsedQuery(queryShardContext.toQuery(source.query()));
        }
        if (source.postFilter() != null) {
            InnerHitContextBuilder.extractInnerHits(source.postFilter(), innerHitBuilders);
            context.parsedPostFilter(queryShardContext.toQuery(source.postFilter()));
        }
        if (innerHitBuilders.size() > 0) {
            for (Map.Entry entry : innerHitBuilders.entrySet()) {
                try {
                    ((InnerHitContextBuilder)entry.getValue()).build(context, context.innerHits());
                }
                catch (IOException e) {
                    throw new SearchException(shardTarget, "failed to build inner_hits", e);
                }
            }
        }
        if (source.sorts() != null) {
            try {
                Optional<SortAndFormats> optionalSort = SortBuilder.buildSort(source.sorts(), context.getQueryShardContext());
                if (optionalSort.isPresent()) {
                    context.sort(optionalSort.get());
                }
            }
            catch (IOException e) {
                throw new SearchException(shardTarget, "failed to create sort elements", e);
            }
        }
        context.trackScores(source.trackScores());
        if (source.trackTotalHitsUpTo() != null && source.trackTotalHitsUpTo() != Integer.MAX_VALUE && context.scrollContext() != null) {
            throw new SearchException(shardTarget, "disabling [track_total_hits] is not allowed in a scroll context");
        }
        if (source.trackTotalHitsUpTo() != null) {
            context.trackTotalHitsUpTo(source.trackTotalHitsUpTo());
        }
        if (source.minScore() != null) {
            context.minimumScore(source.minScore().floatValue());
        }
        if (source.profile()) {
            context.setProfilers(new Profilers(context.searcher()));
        }
        if (source.timeout() != null) {
            context.timeout(source.timeout());
        }
        context.terminateAfter(source.terminateAfter());
        if (source.aggregations() != null) {
            try {
                AggregatorFactories factories = source.aggregations().build(queryShardContext, null);
                context.aggregations(new SearchContextAggregations(factories, this.multiBucketConsumerService.create()));
            }
            catch (IOException e) {
                throw new AggregationInitializationException("Failed to create aggregators", e);
            }
        }
        if (source.suggest() != null) {
            try {
                context.suggest(source.suggest().build(queryShardContext));
            }
            catch (IOException e) {
                throw new SearchException(shardTarget, "failed to create SuggestionSearchContext", e);
            }
        }
        if (source.rescores() != null) {
            try {
                for (RescorerBuilder rescorerBuilder : source.rescores()) {
                    context.addRescore(rescorerBuilder.buildContext(queryShardContext));
                }
            }
            catch (IOException e) {
                throw new SearchException(shardTarget, "failed to create RescoreSearchContext", e);
            }
        }
        if (source.explain() != null) {
            context.explain(source.explain());
        }
        if (source.fetchSource() != null) {
            context.fetchSourceContext(source.fetchSource());
        }
        if (source.docValueFields() != null) {
            ArrayList<FetchDocValuesContext.FieldAndFormat> docValueFields = new ArrayList<FetchDocValuesContext.FieldAndFormat>();
            for (FetchDocValuesContext.FieldAndFormat format : source.docValueFields()) {
                Set<String> fieldNames = context.mapperService().simpleMatchToFullName(format.field);
                for (String fieldName : fieldNames) {
                    docValueFields.add(new FetchDocValuesContext.FieldAndFormat(fieldName, format.format));
                }
            }
            int n = context.mapperService().getIndexSettings().getMaxDocvalueFields();
            if (docValueFields.size() > n) {
                throw new IllegalArgumentException("Trying to retrieve too many docvalue_fields. Must be less than or equal to: [" + n + "] but was [" + docValueFields.size() + "]. This limit can be set by changing the [" + IndexSettings.MAX_DOCVALUE_FIELDS_SEARCH_SETTING.getKey() + "] index level setting.");
            }
            context.docValuesContext(new FetchDocValuesContext(docValueFields));
        }
        if (source.highlighter() != null) {
            HighlightBuilder highlightBuilder = source.highlighter();
            try {
                context.highlight(highlightBuilder.build(queryShardContext));
            }
            catch (IOException iOException) {
                throw new SearchException(shardTarget, "failed to create SearchContextHighlighter", iOException);
            }
        }
        if (source.scriptFields() != null && source.size() != 0) {
            int maxAllowedScriptFields = context.mapperService().getIndexSettings().getMaxScriptFields();
            if (source.scriptFields().size() > maxAllowedScriptFields) {
                throw new IllegalArgumentException("Trying to retrieve too many script_fields. Must be less than or equal to: [" + maxAllowedScriptFields + "] but was [" + source.scriptFields().size() + "]. This limit can be set by changing the [" + IndexSettings.MAX_SCRIPT_FIELDS_SETTING.getKey() + "] index level setting.");
            }
            for (SearchSourceBuilder.ScriptField field : source.scriptFields()) {
                FieldScript.Factory factory = this.scriptService.compile(field.script(), FieldScript.CONTEXT);
                FieldScript.LeafFactory searchScript = factory.newFactory(field.script().getParams(), context.lookup());
                context.scriptFields().add(new ScriptFieldsContext.ScriptField(field.fieldName(), searchScript, field.ignoreFailure()));
            }
        }
        if (source.ext() != null) {
            for (SearchExtBuilder searchExtBuilder : source.ext()) {
                context.addSearchExt(searchExtBuilder);
            }
        }
        if (source.version() != null) {
            context.version(source.version());
        }
        if (source.seqNoAndPrimaryTerm() != null) {
            context.seqNoAndPrimaryTerm(source.seqNoAndPrimaryTerm());
        }
        if (source.stats() != null) {
            context.groupStats(source.stats());
        }
        if (!CollectionUtils.isEmpty(source.searchAfter())) {
            if (context.scrollContext() != null) {
                throw new SearchException(shardTarget, "`search_after` cannot be used in a scroll context.");
            }
            if (context.from() > 0) {
                throw new SearchException(shardTarget, "`from` parameter must be set to 0 when `search_after` is used.");
            }
            FieldDoc fieldDoc = SearchAfterBuilder.buildFieldDoc(context.sort(), source.searchAfter());
            context.searchAfter(fieldDoc);
        }
        if (source.slice() != null) {
            if (context.scrollContext() == null) {
                throw new SearchException(shardTarget, "`slice` cannot be used outside of a scroll context");
            }
            context.sliceBuilder(source.slice());
        }
        if (source.storedFields() != null) {
            if (!source.storedFields().fetchFields()) {
                if (context.version()) {
                    throw new SearchException(shardTarget, "`stored_fields` cannot be disabled if version is requested");
                }
                if (context.sourceRequested()) {
                    throw new SearchException(shardTarget, "`stored_fields` cannot be disabled if _source is requested");
                }
            }
            context.storedFieldsContext(source.storedFields());
        }
        if (source.collapse() != null) {
            if (context.scrollContext() != null) {
                throw new SearchException(shardTarget, "cannot use `collapse` in a scroll context");
            }
            if (context.searchAfter() != null) {
                throw new SearchException(shardTarget, "cannot use `collapse` in conjunction with `search_after`");
            }
            if (context.rescore() != null && !context.rescore().isEmpty()) {
                throw new SearchException(shardTarget, "cannot use `collapse` in conjunction with `rescore`");
            }
            CollapseContext collapseContext = source.collapse().build(queryShardContext);
            context.collapse(collapseContext);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void shortcutDocIdsToLoad(SearchContext context) {
        int[] docIdsToLoad;
        TopDocs topDocs;
        List<Object> completionSuggestions;
        int docsOffset = 0;
        Suggest suggest = context.queryResult().suggest();
        int numSuggestDocs = 0;
        if (suggest != null && suggest.hasScoreDocs()) {
            completionSuggestions = suggest.filter(CompletionSuggestion.class);
            for (CompletionSuggestion completionSuggestion : completionSuggestions) {
                numSuggestDocs += completionSuggestion.getOptions().size();
            }
        } else {
            completionSuggestions = Collections.emptyList();
        }
        if (context.request().scroll() != null) {
            void var8_9;
            topDocs = context.queryResult().topDocs().topDocs;
            docIdsToLoad = new int[topDocs.scoreDocs.length + numSuggestDocs];
            boolean bl = false;
            while (var8_9 < topDocs.scoreDocs.length) {
                docIdsToLoad[docsOffset++] = topDocs.scoreDocs[var8_9].doc;
                ++var8_9;
            }
        } else {
            topDocs = context.queryResult().topDocs().topDocs;
            if (topDocs.scoreDocs.length < context.from()) {
                docIdsToLoad = new int[numSuggestDocs];
            } else {
                int n = context.from() + context.size();
                docIdsToLoad = new int[Math.min(topDocs.scoreDocs.length - context.from(), context.size()) + numSuggestDocs];
                for (int i = context.from(); i < Math.min(n, topDocs.scoreDocs.length); ++i) {
                    docIdsToLoad[docsOffset++] = topDocs.scoreDocs[i].doc;
                }
            }
        }
        for (CompletionSuggestion completionSuggestion : completionSuggestions) {
            for (CompletionSuggestion.Entry.Option option : completionSuggestion.getOptions()) {
                docIdsToLoad[docsOffset++] = option.getDoc().doc;
            }
        }
        context.docIdsToLoad(docIdsToLoad, 0, docIdsToLoad.length);
    }

    private void processScroll(InternalScrollSearchRequest request, SearchContext context) {
        context.from(context.from() + context.size());
        context.scrollContext().scroll = request.scroll();
        if (request.scroll() != null && request.scroll().keepAlive() != null) {
            this.contextScrollKeepAlive(context, request.scroll().keepAlive().millis());
        }
    }

    public int getActiveContexts() {
        return this.activeContexts.size();
    }

    public ResponseCollectorService getResponseCollectorService() {
        return this.responseCollectorService;
    }

    public AliasFilter buildAliasFilter(ClusterState state, String index, Set<String> resolvedExpressions) {
        return this.indicesService.buildAliasFilter(state, index, resolvedExpressions);
    }

    public CanMatchResponse canMatch(ShardSearchRequest request) throws IOException {
        assert (request.searchType() == SearchType.QUERY_THEN_FETCH) : "unexpected search type: " + (Object)((Object)request.searchType());
        IndexService indexService = this.indicesService.indexServiceSafe(request.shardId().getIndex());
        IndexShard indexShard = indexService.getShard(request.shardId().getId());
        boolean hasRefreshPending = indexShard.hasRefreshPending();
        try (Engine.Searcher searcher = indexShard.acquireCanMatchSearcher();){
            boolean canMatch;
            MinAndMax<?> minMax;
            QueryShardContext context = indexService.newQueryShardContext(request.shardId().id(), searcher, request::nowInMillis, request.getClusterAlias());
            Rewriteable.rewrite(request.getRewriteable(), context, false);
            boolean aliasFilterCanMatch = !(request.getAliasFilter().getQueryBuilder() instanceof MatchNoneQueryBuilder);
            FieldSortBuilder sortBuilder = FieldSortBuilder.getPrimaryFieldSortOrNull(request.source());
            MinAndMax<?> minAndMax = minMax = sortBuilder != null ? FieldSortBuilder.getMinMaxOrNull(context, sortBuilder) : null;
            if (SearchService.canRewriteToMatchNone(request.source())) {
                QueryBuilder queryBuilder = request.source().query();
                canMatch = aliasFilterCanMatch && !(queryBuilder instanceof MatchNoneQueryBuilder);
            } else {
                canMatch = aliasFilterCanMatch;
            }
            CanMatchResponse canMatchResponse = new CanMatchResponse(canMatch || hasRefreshPending, minMax);
            return canMatchResponse;
        }
    }

    public void canMatch(ShardSearchRequest request, ActionListener<CanMatchResponse> listener) {
        try {
            listener.onResponse(this.canMatch(request));
        }
        catch (IOException e) {
            listener.onFailure(e);
        }
    }

    public static boolean canRewriteToMatchNone(SearchSourceBuilder source) {
        if (source == null || source.query() == null || source.query() instanceof MatchAllQueryBuilder || source.suggest() != null) {
            return false;
        }
        AggregatorFactories.Builder aggregations = source.aggregations();
        return aggregations == null || !aggregations.mustVisitAllDocs();
    }

    private void rewriteAndFetchShardRequest(IndexShard shard, ShardSearchRequest request, ActionListener<ShardSearchRequest> listener) {
        ActionListener<Rewriteable> actionListener = ActionListener.wrap(r -> shard.awaitShardSearchActive(b -> listener.onResponse(request)), listener::onFailure);
        Rewriteable.rewriteAndFetch(request.getRewriteable(), this.indicesService.getRewriteContext(request::nowInMillis), actionListener);
    }

    public QueryRewriteContext getRewriteContext(LongSupplier nowInMillis) {
        return this.indicesService.getRewriteContext(nowInMillis);
    }

    public IndicesService getIndicesService() {
        return this.indicesService;
    }

    public InternalAggregation.ReduceContextBuilder aggReduceContextBuilder(final SearchRequest request) {
        return new InternalAggregation.ReduceContextBuilder(){

            @Override
            public InternalAggregation.ReduceContext forPartialReduction() {
                return InternalAggregation.ReduceContext.forPartialReduction(SearchService.this.bigArrays, SearchService.this.scriptService, () -> SearchService.requestToPipelineTree(request));
            }

            @Override
            public InternalAggregation.ReduceContext forFinalReduction() {
                PipelineAggregator.PipelineTree pipelineTree = SearchService.requestToPipelineTree(request);
                return InternalAggregation.ReduceContext.forFinalReduction(SearchService.this.bigArrays, SearchService.this.scriptService, SearchService.this.multiBucketConsumerService.create(), pipelineTree);
            }
        };
    }

    private static PipelineAggregator.PipelineTree requestToPipelineTree(SearchRequest request) {
        if (request.source() == null || request.source().aggregations() == null) {
            return PipelineAggregator.PipelineTree.EMPTY;
        }
        return request.source().aggregations().buildPipelineTree();
    }

    class Reaper
    implements Runnable {
        Reaper() {
        }

        @Override
        public void run() {
            long time = SearchService.this.threadPool.relativeTimeInMillis();
            for (SearchContext context : SearchService.this.activeContexts.values()) {
                long lastAccessTime = context.lastAccessTime();
                if (lastAccessTime == -1L || time - lastAccessTime <= context.keepAlive()) continue;
                logger.debug("freeing search context [{}], time [{}], lastAccessTime [{}], keepAlive [{}]", (Object)context.id(), (Object)time, (Object)lastAccessTime, (Object)context.keepAlive());
                SearchService.this.freeContext(context.id());
            }
        }
    }

    private static final class SearchOperationListenerExecutor
    implements AutoCloseable {
        private final SearchOperationListener listener;
        private final SearchContext context;
        private final long time;
        private final boolean fetch;
        private long afterQueryTime = -1L;
        private boolean closed = false;

        SearchOperationListenerExecutor(SearchContext context) {
            this(context, false, System.nanoTime());
        }

        SearchOperationListenerExecutor(SearchContext context, boolean fetch, long startTime) {
            this.listener = context.indexShard().getSearchOperationListener();
            this.context = context;
            this.time = startTime;
            this.fetch = fetch;
            if (fetch) {
                this.listener.onPreFetchPhase(context);
            } else {
                this.listener.onPreQueryPhase(context);
            }
        }

        long success() {
            this.afterQueryTime = System.nanoTime();
            return this.afterQueryTime;
        }

        @Override
        public void close() {
            assert (!this.closed) : "already closed - while technically ok double closing is a likely a bug in this case";
            if (!this.closed) {
                this.closed = true;
                if (this.afterQueryTime != -1L) {
                    if (this.fetch) {
                        this.listener.onFetchPhase(this.context, this.afterQueryTime - this.time);
                    } else {
                        this.listener.onQueryPhase(this.context, this.afterQueryTime - this.time);
                    }
                } else if (this.fetch) {
                    this.listener.onFailedFetchPhase(this.context);
                } else {
                    this.listener.onFailedQueryPhase(this.context);
                }
            }
        }
    }

    public static final class CanMatchResponse
    extends SearchPhaseResult {
        private final boolean canMatch;
        private final MinAndMax<?> estimatedMinAndMax;

        public CanMatchResponse(StreamInput in) throws IOException {
            super(in);
            this.canMatch = in.readBoolean();
            this.estimatedMinAndMax = in.getVersion().onOrAfter(Version.V_7_6_0) ? in.readOptionalWriteable(MinAndMax::new) : null;
        }

        public CanMatchResponse(boolean canMatch, MinAndMax<?> estimatedMinAndMax) {
            this.canMatch = canMatch;
            this.estimatedMinAndMax = estimatedMinAndMax;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this.canMatch);
            if (out.getVersion().onOrAfter(Version.V_7_6_0)) {
                out.writeOptionalWriteable(this.estimatedMinAndMax);
            }
        }

        public boolean canMatch() {
            return this.canMatch;
        }

        public MinAndMax<?> estimatedMinAndMax() {
            return this.estimatedMinAndMax;
        }
    }
}

