/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ElasticsearchException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestStatus;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.SearchContextId;

public class SearchContextMissingException
extends ElasticsearchException {
    private final SearchContextId contextId;

    public SearchContextMissingException(SearchContextId contextId) {
        super("No search context found for id [" + contextId.getId() + "]", new Object[0]);
        this.contextId = contextId;
    }

    public SearchContextId contextId() {
        return this.contextId;
    }

    @Override
    public RestStatus status() {
        return RestStatus.NOT_FOUND;
    }

    public SearchContextMissingException(StreamInput in) throws IOException {
        super(in);
        this.contextId = new SearchContextId(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.contextId.writeTo(out);
    }
}

