/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.script;

import java.security.AccessController;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.chrono.Chronology;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.ValueRange;
import java.util.Locale;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.SuppressForbidden;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.logging.DeprecationLogger;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.time.DateFormatter;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.time.DateFormatters;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.time.DateUtils;
import org.apache.logging.log4j.LogManager;
import org.joda.time.DateTime;

public class JodaCompatibleZonedDateTime
implements Comparable<ChronoZonedDateTime<?>>,
ChronoZonedDateTime<LocalDate>,
Temporal,
TemporalAccessor {
    private static final DateFormatter DATE_FORMATTER = DateFormatter.forPattern("strict_date_time");
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(JodaCompatibleZonedDateTime.class));
    private ZonedDateTime dt;

    private static void logDeprecated(String key, String message, Object ... params) {
        AccessController.doPrivileged(() -> {
            deprecationLogger.deprecatedAndMaybeLog(key, message, params);
            return null;
        });
    }

    private static void logDeprecatedMethod(String oldMethod, String newMethod) {
        JodaCompatibleZonedDateTime.logDeprecated(oldMethod, "Use of the joda time method [{}] is deprecated. Use [{}] instead.", oldMethod, newMethod);
    }

    public JodaCompatibleZonedDateTime(Instant instant, ZoneId zone) {
        this.dt = ZonedDateTime.ofInstant(instant, zone);
    }

    public ZonedDateTime getZonedDateTime() {
        return this.dt;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() == JodaCompatibleZonedDateTime.class) {
            JodaCompatibleZonedDateTime that = (JodaCompatibleZonedDateTime)o;
            return Objects.equals(this.dt, that.dt);
        }
        if (o.getClass() == ZonedDateTime.class) {
            ZonedDateTime that = (ZonedDateTime)o;
            return Objects.equals(this.dt, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.dt.hashCode();
    }

    @Override
    public String toString() {
        return DATE_FORMATTER.format(this.dt);
    }

    @Override
    public String format(DateTimeFormatter formatter) {
        return this.dt.format(formatter);
    }

    @Override
    public ValueRange range(TemporalField field) {
        return this.dt.range(field);
    }

    @Override
    public int get(TemporalField field) {
        return this.dt.get(field);
    }

    @Override
    public long getLong(TemporalField field) {
        return this.dt.getLong(field);
    }

    @Override
    public Chronology getChronology() {
        return this.dt.getChronology();
    }

    @Override
    public ZoneOffset getOffset() {
        return this.dt.getOffset();
    }

    @Override
    public boolean isSupported(TemporalField field) {
        return this.dt.isSupported(field);
    }

    @Override
    public boolean isSupported(TemporalUnit unit) {
        return this.dt.isSupported(unit);
    }

    @Override
    public long toEpochSecond() {
        return this.dt.toEpochSecond();
    }

    @Override
    public int compareTo(ChronoZonedDateTime<?> other) {
        return this.dt.compareTo(other);
    }

    @Override
    public boolean isBefore(ChronoZonedDateTime<?> other) {
        return this.dt.isBefore(other);
    }

    @Override
    public boolean isAfter(ChronoZonedDateTime<?> other) {
        return this.dt.isAfter(other);
    }

    @Override
    public boolean isEqual(ChronoZonedDateTime<?> other) {
        return this.dt.isEqual(other);
    }

    @Override
    public LocalTime toLocalTime() {
        return this.dt.toLocalTime();
    }

    public int getDayOfMonth() {
        return this.dt.getDayOfMonth();
    }

    public int getDayOfYear() {
        return this.dt.getDayOfYear();
    }

    public int getHour() {
        return this.dt.getHour();
    }

    @Override
    public LocalDate toLocalDate() {
        return this.dt.toLocalDate();
    }

    public LocalDateTime toLocalDateTime() {
        return this.dt.toLocalDateTime();
    }

    public int getMinute() {
        return this.dt.getMinute();
    }

    public Month getMonth() {
        return this.dt.getMonth();
    }

    public int getMonthValue() {
        return this.dt.getMonthValue();
    }

    public int getNano() {
        return this.dt.getNano();
    }

    public int getSecond() {
        return this.dt.getSecond();
    }

    public int getYear() {
        return this.dt.getYear();
    }

    @Override
    public ZoneId getZone() {
        return this.dt.getZone();
    }

    @Override
    public ZonedDateTime minus(TemporalAmount delta) {
        return this.dt.minus(delta);
    }

    @Override
    public ZonedDateTime minus(long amount, TemporalUnit unit) {
        return this.dt.minus(amount, unit);
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        return this.dt.query(query);
    }

    @Override
    public long until(Temporal temporal, TemporalUnit temporalUnit) {
        return this.dt.until(temporal, temporalUnit);
    }

    public ZonedDateTime minusYears(long amount) {
        return this.dt.minusYears(amount);
    }

    public ZonedDateTime minusMonths(long amount) {
        return this.dt.minusMonths(amount);
    }

    public ZonedDateTime minusWeeks(long amount) {
        return this.dt.minusWeeks(amount);
    }

    public ZonedDateTime minusDays(long amount) {
        return this.dt.minusDays(amount);
    }

    public ZonedDateTime minusHours(long amount) {
        return this.dt.minusHours(amount);
    }

    public ZonedDateTime minusMinutes(long amount) {
        return this.dt.minusMinutes(amount);
    }

    public ZonedDateTime minusSeconds(long amount) {
        return this.dt.minusSeconds(amount);
    }

    public ZonedDateTime minusNanos(long amount) {
        return this.dt.minusNanos(amount);
    }

    @Override
    public ZonedDateTime plus(TemporalAmount amount) {
        return this.dt.plus(amount);
    }

    @Override
    public ZonedDateTime plus(long amount, TemporalUnit unit) {
        return this.dt.plus(amount, unit);
    }

    public ZonedDateTime plusDays(long amount) {
        return this.dt.plusDays(amount);
    }

    public ZonedDateTime plusHours(long amount) {
        return this.dt.plusHours(amount);
    }

    public ZonedDateTime plusMinutes(long amount) {
        return this.dt.plusMinutes(amount);
    }

    public ZonedDateTime plusMonths(long amount) {
        return this.dt.plusMonths(amount);
    }

    public ZonedDateTime plusNanos(long amount) {
        return this.dt.plusNanos(amount);
    }

    public ZonedDateTime plusSeconds(long amount) {
        return this.dt.plusSeconds(amount);
    }

    public ZonedDateTime plusWeeks(long amount) {
        return this.dt.plusWeeks(amount);
    }

    public ZonedDateTime plusYears(long amount) {
        return this.dt.plusYears(amount);
    }

    @Override
    public Instant toInstant() {
        return this.dt.toInstant();
    }

    public OffsetDateTime toOffsetDateTime() {
        return this.dt.toOffsetDateTime();
    }

    @SuppressForbidden(reason="only exposing the method as a passthrough")
    public ZonedDateTime truncatedTo(TemporalUnit unit) {
        return this.dt.truncatedTo(unit);
    }

    @Override
    public ZonedDateTime with(TemporalAdjuster adjuster) {
        return this.dt.with(adjuster);
    }

    @Override
    public ZonedDateTime with(TemporalField field, long newValue) {
        return this.dt.with(field, newValue);
    }

    public ZonedDateTime withDayOfMonth(int value) {
        return this.dt.withDayOfMonth(value);
    }

    public ZonedDateTime withDayOfYear(int value) {
        return this.dt.withDayOfYear(value);
    }

    public ZonedDateTime withEarlierOffsetAtOverlap() {
        return this.dt.withEarlierOffsetAtOverlap();
    }

    public ZonedDateTime withFixedOffsetZone() {
        return this.dt.withFixedOffsetZone();
    }

    public ZonedDateTime withHour(int value) {
        return this.dt.withHour(value);
    }

    public ZonedDateTime withLaterOffsetAtOverlap() {
        return this.dt.withLaterOffsetAtOverlap();
    }

    public ZonedDateTime withMinute(int value) {
        return this.dt.withMinute(value);
    }

    public ZonedDateTime withMonth(int value) {
        return this.dt.withMonth(value);
    }

    public ZonedDateTime withNano(int value) {
        return this.dt.withNano(value);
    }

    public ZonedDateTime withSecond(int value) {
        return this.dt.withSecond(value);
    }

    public ZonedDateTime withYear(int value) {
        return this.dt.withYear(value);
    }

    public ZonedDateTime withZoneSameLocal(ZoneId zone) {
        return this.dt.withZoneSameLocal(zone);
    }

    public ZonedDateTime withZoneSameInstant(ZoneId zone) {
        return this.dt.withZoneSameInstant(zone);
    }

    @Deprecated
    public long getMillis() {
        JodaCompatibleZonedDateTime.logDeprecatedMethod("getMillis()", "toInstant().toEpochMilli()");
        return this.dt.toInstant().toEpochMilli();
    }

    @Deprecated
    public int getCenturyOfEra() {
        JodaCompatibleZonedDateTime.logDeprecatedMethod("getCenturyOfEra()", "get(ChronoField.YEAR_OF_ERA) / 100");
        return this.dt.get(ChronoField.YEAR_OF_ERA) / 100;
    }

    @Deprecated
    public int getEra() {
        JodaCompatibleZonedDateTime.logDeprecatedMethod("getEra()", "get(ChronoField.ERA)");
        return this.dt.get(ChronoField.ERA);
    }

    @Deprecated
    public int getHourOfDay() {
        JodaCompatibleZonedDateTime.logDeprecatedMethod("getHourOfDay()", "getHour()");
        return this.dt.getHour();
    }

    @Deprecated
    public int getMillisOfDay() {
        JodaCompatibleZonedDateTime.logDeprecatedMethod("getMillisOfDay()", "get(ChronoField.MILLI_OF_DAY)");
        return this.dt.get(ChronoField.MILLI_OF_DAY);
    }

    @Deprecated
    public int getMillisOfSecond() {
        JodaCompatibleZonedDateTime.logDeprecatedMethod("getMillisOfSecond()", "get(ChronoField.MILLI_OF_SECOND)");
        return this.dt.get(ChronoField.MILLI_OF_SECOND);
    }

    @Deprecated
    public int getMinuteOfDay() {
        JodaCompatibleZonedDateTime.logDeprecatedMethod("getMinuteOfDay()", "get(ChronoField.MINUTE_OF_DAY)");
        return this.dt.get(ChronoField.MINUTE_OF_DAY);
    }

    @Deprecated
    public int getMinuteOfHour() {
        JodaCompatibleZonedDateTime.logDeprecatedMethod("getMinuteOfHour()", "getMinute()");
        return this.dt.getMinute();
    }

    @Deprecated
    public int getMonthOfYear() {
        JodaCompatibleZonedDateTime.logDeprecatedMethod("getMonthOfYear()", "getMonthValue()");
        return this.dt.getMonthValue();
    }

    @Deprecated
    public int getSecondOfDay() {
        JodaCompatibleZonedDateTime.logDeprecatedMethod("getSecondOfDay()", "get(ChronoField.SECOND_OF_DAY)");
        return this.dt.get(ChronoField.SECOND_OF_DAY);
    }

    @Deprecated
    public int getSecondOfMinute() {
        JodaCompatibleZonedDateTime.logDeprecatedMethod("getSecondOfMinute()", "getSecond()");
        return this.dt.getSecond();
    }

    @Deprecated
    public int getWeekOfWeekyear() {
        JodaCompatibleZonedDateTime.logDeprecatedMethod("getWeekOfWeekyear()", "get(DateFormatters.WEEK_FIELDS_ROOT.weekOfWeekBasedYear())");
        return this.dt.get(DateFormatters.WEEK_FIELDS_ROOT.weekOfWeekBasedYear());
    }

    @Deprecated
    public int getWeekyear() {
        JodaCompatibleZonedDateTime.logDeprecatedMethod("getWeekyear()", "get(DateFormatters.WEEK_FIELDS_ROOT.weekBasedYear())");
        return this.dt.get(DateFormatters.WEEK_FIELDS_ROOT.weekBasedYear());
    }

    @Deprecated
    public int getYearOfCentury() {
        JodaCompatibleZonedDateTime.logDeprecatedMethod("getYearOfCentury()", "get(ChronoField.YEAR_OF_ERA) % 100");
        return this.dt.get(ChronoField.YEAR_OF_ERA) % 100;
    }

    @Deprecated
    public int getYearOfEra() {
        JodaCompatibleZonedDateTime.logDeprecatedMethod("getYearOfEra()", "get(ChronoField.YEAR_OF_ERA)");
        return this.dt.get(ChronoField.YEAR_OF_ERA);
    }

    @Deprecated
    public String toString(String format) {
        JodaCompatibleZonedDateTime.logDeprecatedMethod("toString(String)", "a DateTimeFormatter");
        return new DateTime(this.dt.toInstant().toEpochMilli(), DateUtils.zoneIdToDateTimeZone(this.dt.getZone())).toString(format);
    }

    @Deprecated
    public String toString(String format, Locale locale) {
        JodaCompatibleZonedDateTime.logDeprecatedMethod("toString(String,Locale)", "a DateTimeFormatter");
        return new DateTime(this.dt.toInstant().toEpochMilli(), DateUtils.zoneIdToDateTimeZone(this.dt.getZone())).toString(format, locale);
    }

    public DayOfWeek getDayOfWeekEnum() {
        return this.dt.getDayOfWeek();
    }

    @Deprecated
    public int getDayOfWeek() {
        JodaCompatibleZonedDateTime.logDeprecated("getDayOfWeek()", "The return type of [getDayOfWeek()] will change to an enum in 7.0. Use getDayOfWeekEnum().getValue().", new Object[0]);
        return this.dt.getDayOfWeek().getValue();
    }
}

