/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.script;

import java.io.IOException;
import java.util.HashMap;
import java.util.function.Function;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Scorable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ElasticsearchException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.collect.Map;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.logging.DeprecationLogger;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lucene.ScorerAware;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.ScriptDocValues;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.script.DynamicMap;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.lookup.LeafSearchLookup;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.lookup.SearchLookup;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.lookup.SourceLookup;
import org.apache.logging.log4j.LogManager;

abstract class AbstractSortScript
implements ScorerAware {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(DynamicMap.class));
    private static final java.util.Map<String, Function<Object, Object>> PARAMS_FUNCTIONS = Map.of("doc", value -> {
        deprecationLogger.deprecatedAndMaybeLog("sort-script_doc", "Accessing variable [doc] via [params.doc] from within an sort-script is deprecated in favor of directly accessing [doc].", new Object[0]);
        return value;
    }, "_doc", value -> {
        deprecationLogger.deprecatedAndMaybeLog("sort-script__doc", "Accessing variable [doc] via [params._doc] from within an sort-script is deprecated in favor of directly accessing [doc].", new Object[0]);
        return value;
    }, "_source", value -> ((SourceLookup)value).loadSourceIfNeeded());
    private final java.util.Map<String, Object> params;
    private Scorable scorer;
    private final LeafSearchLookup leafLookup;

    AbstractSortScript(java.util.Map<String, Object> params, SearchLookup lookup, LeafReaderContext leafContext) {
        this.leafLookup = lookup.getLeafSearchLookup(leafContext);
        HashMap<String, Object> parameters = new HashMap<String, Object>(params);
        parameters.putAll(this.leafLookup.asMap());
        this.params = new DynamicMap(parameters, PARAMS_FUNCTIONS);
    }

    protected AbstractSortScript() {
        this.params = null;
        this.leafLookup = null;
    }

    public java.util.Map<String, Object> getParams() {
        return this.params;
    }

    @Override
    public void setScorer(Scorable scorer) {
        this.scorer = scorer;
    }

    public double get_score() {
        try {
            return this.scorer.score();
        }
        catch (IOException e) {
            throw new ElasticsearchException("couldn't lookup score", (Throwable)e, new Object[0]);
        }
    }

    public java.util.Map<String, ScriptDocValues<?>> getDoc() {
        return this.leafLookup.doc();
    }

    public void setDocument(int docid) {
        this.leafLookup.setDocument(docid);
    }
}

